<?php
/**
 *
 *  Joonte Billing System
 *
 *  Copyright © 2020 Alex Keda, for www.host-food.ru
 *
 */

class HostingOrdersSuspendedMsg extends Message {
	#-------------------------------------------------------------------------------
	public function __construct(array $params, $toUser) {
		#-------------------------------------------------------------------------------
		parent::__construct('HostingOrdersSuspended', $toUser, $params);
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	public function getParams() {
		#-------------------------------------------------------------------------------
		$HostingScheme = DB_Select('HostingSchemes', Array('*'), Array('UNIQ', 'Where' => SPrintF('`ID` = %u',$this->params['SchemeID'])));
		#-------------------------------------------------------------------------------
		if(!Is_Array($HostingScheme))
			return ERROR | @Trigger_Error(500);
		#-------------------------------------------------------------------------------
		$this->params['HostingScheme'] = $HostingScheme;
		#-------------------------------------------------------------------------------
		#-------------------------------------------------------------------------------
		// ссылка на продление заказа
		$this->params['ProlongLink'] = SPrintF('%s://%s/v2/HostingOrderPay/%u/',URL_SCHEME,HOST_ID,$this->params['OrderID']);
		#-------------------------------------------------------------------------------
		#-------------------------------------------------------------------------------
		// ссылка на смену тарифа
		$this->params['SchemeChangeLink'] = SPrintF('%s://%s/v2/HostingOrders/%u/SchemeChange/',URL_SCHEME,HOST_ID,$this->params['OrderID']);
		#-------------------------------------------------------------------------------
		#-------------------------------------------------------------------------------
		return $this->params;
		#-------------------------------------------------------------------------------
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
}

