<?php
#-------------------------------------------------------------------------------
/** @author Alex Keda, for www.host-food.ru */
#-------------------------------------------------------------------------------
if(Is_Error(System_Load('libs/HTTP.php')))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
function DSScripting_Create($Settings,$Attribs){
	/******************************************************************************/
	// параметры управляющего сервера, параметры управляемого сервера
	$__args_types = Array('array','array');
	#-------------------------------------------------------------------------------
	$__args__ = Func_Get_Args(); Eval(FUNCTION_INIT);
	/******************************************************************************/
	// создаём файл с настрйоками
	$SettingsFile = DSScripting_SaveFile($Settings,$Attribs);
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	$File = DSScripting_CheckFile($Settings['Params']['Action']);
	if(Is_Error($IsUpdate))
		return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	Exec(SPrintF('"%s" "Create" "%s" 2>&1',$File,$SettingsFile),$Out,$ReturnValue);
	#-------------------------------------------------------------------------------
	Debug(SPrintF('[DSScripting_Create]: exec return code = %s, Out = %s',$ReturnValue,print_r($Out,true)));
	#-------------------------------------------------------------------------------
	// удаляем файл. результат - наверное не важен...
	DSScripting_DeleteFile($SettingsFile);
	#-------------------------------------------------------------------------------
	if($ReturnValue != 0)
		return new gException('ERROR_EXECUTE_COMMAND','Произошла ошибка при выполнении команды назначенной статусу');
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	return TRUE;
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
function DSScripting_Active($Settings,$Attribs = Array()){
	/******************************************************************************/
	$__args_types = Array('array','array');
	#-------------------------------------------------------------------------------
	$__args__ = Func_Get_Args(); Eval(FUNCTION_INIT);
	/******************************************************************************/
	#$authinfo = SPrintF('%s:%s',$Settings['Login'],$Settings['Password']);
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	// создаём файл с настрйоками
	$SettingsFile = DSScripting_SaveFile($Settings,$Attribs);
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	$File = DSScripting_CheckFile($Settings['Params']['Action']);
	if(Is_Error($IsUpdate))
		return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------------
	Exec(SPrintF('"%s" "Active" "%s" 2>&1',$File,$SettingsFile),$Out,$ReturnValue);
	#-------------------------------------------------------------------------------
	Debug(SPrintF('[DSScripting_Active]: exec return code = %s, Out = %s',$ReturnValue,print_r($Out,true)));
	#-------------------------------------------------------------------------------
	// удаляем файл. результат - наверное не важен...
	DSScripting_DeleteFile($SettingsFile);
	#-------------------------------------------------------------------------------
	if($ReturnValue != 0)
		return new gException('ERROR_EXECUTE_COMMAND','Произошла ошибка при выполнении команды назначенной статусу');
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	return TRUE;
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
function DSScripting_Delete($Settings,$Attribs = Array()){
	/******************************************************************************/
	$__args_types = Array('array','array');
	#-------------------------------------------------------------------------------
	$__args__ = Func_Get_Args(); Eval(FUNCTION_INIT);
	/******************************************************************************/
	#$authinfo = SPrintF('%s:%s',$Settings['Login'],$Settings['Password']);
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	// создаём файл с настрйоками
	$SettingsFile = DSScripting_SaveFile($Settings,$Attribs);
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	$File = DSScripting_CheckFile($Settings['Params']['Action']);
	if(Is_Error($IsUpdate))
		return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------------
	Exec(SPrintF('"%s" "Delete" "%s" 2>&1',$File,$SettingsFile),$Out,$ReturnValue);
	#-------------------------------------------------------------------------------
	Debug(SPrintF('[DSScripting_Delete]: exec return code = %s, Out = %s',$ReturnValue,print_r($Out,true)));
	#-------------------------------------------------------------------------------
	// удаляем файл. результат - наверное не важен...
	DSScripting_DeleteFile($SettingsFile);
	#-------------------------------------------------------------------------------
	if($ReturnValue != 0)
		return new gException('ERROR_EXECUTE_COMMAND','Произошла ошибка при выполнении команды назначенной статусу');
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	return TRUE;
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
function DSScripting_Suspend($Settings,$Attribs = Array()){
	/******************************************************************************/
	$__args_types = Array('array','array');
	#-------------------------------------------------------------------------------
	$__args__ = Func_Get_Args(); Eval(FUNCTION_INIT);
	/******************************************************************************/
	#$authinfo = SPrintF('%s:%s',$Settings['Login'],$Settings['Password']);
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	// создаём файл с настрйоками
	$SettingsFile = DSScripting_SaveFile($Settings,$Attribs);
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	$File = DSScripting_CheckFile($Settings['Params']['Action']);
	if(Is_Error($IsUpdate))
		return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------------
	Exec(SPrintF('"%s" "Suspend" "%s" 2>&1',$File,$SettingsFile),$Out,$ReturnValue);
	#-------------------------------------------------------------------------------
	Debug(SPrintF('[DSScripting_Suspend]: exec return code = %s, Out = %s',$ReturnValue,print_r($Out,true)));
	#-------------------------------------------------------------------------------
	// удаляем файл. результат - наверное не важен...
	DSScripting_DeleteFile($SettingsFile);
	#-------------------------------------------------------------------------------
	if($ReturnValue != 0)
		return new gException('ERROR_EXECUTE_COMMAND','Произошла ошибка при выполнении команды назначенной статусу');
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	return TRUE;
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
}


#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
# added by lissyara 2025-12-26 in 10:47 MSK, for JBS-1751
function DSScripting_Get_Account_Usage($Settings,$Scheme,$Users){
	/******************************************************************************/
	$__args_types = Array('array','array','array');
	#-------------------------------------------------------------------------------
	$__args__ = Func_Get_Args(); Eval(FUNCTION_INIT);
	/******************************************************************************/
	// на вход принимаются юзеры по одному, т.к. тарифы тоже по одному влетают...
	// может подумать, и сделать тут выборку тарифа - номер заказа есть, достать всё что надо по тарифу. подумаю...
	if(SizeOf($Users) != 1)
		return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------------
	$User = Current($Users);
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	// массивы для обработки
	$OutTmp = $Keys = Array();
	#-------------------------------------------------------------------------------
	// выхлоп сразу с юзером, если пустой вернуть, так и будет к одному и тому же серверу долбится
	$Out = Array($User=>Array('Last'=>Array()));
	#-------------------------------------------------------------------------------
	// массив замены для ключей
	$Replace = Array(' ','/','01-','02-');
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	// перебираем конфиг, создаём массив с полями которые необходимо передать дальше
	$Config = Config();
	$Graphs = $Config['Other']['Graphs'];
	#-------------------------------------------------------------------------------
	foreach(Array_Keys($Graphs) as $Key)
		foreach(Array_Keys($Graphs[$Key]['Keys']) as $ExtKey)
			$Keys[$ExtKey] = $Key;
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	// статус
	$Status = DSScripting_IPMI_Execute($Scheme,'chassis status');
	//Debug(SPrintF('[DSScripting_Get_Account_Usage]: Status = %s',print_r($Status,true)));
	#-------------------------------------------------------------------------------
	if($Status){
		#-------------------------------------------------------------------------------
		foreach($Status as $OutLine){
			#-------------------------------------------------------------------------------
			$Line = Explode(":",$OutLine);
			#-------------------------------------------------------------------------------
			if(!IsSet($Line[1]))
				continue;
			#-------------------------------------------------------------------------------
			$OutTmp[Str_Replace($Replace,'_',Trim($Line[0]))] = Trim($Line[1]);
			#-------------------------------------------------------------------------------
		}
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	// сенсоры
	$SDR = DSScripting_IPMI_Execute($Scheme,'sdr');
	#-------------------------------------------------------------------------------
	if($SDR){
		#-------------------------------------------------------------------------------
		foreach($SDR as $OutLine){
			#-------------------------------------------------------------------------------
			$Line = Explode("|",$OutLine);
			#-------------------------------------------------------------------------------
			if(!IsSet($Line[1]))
				continue;
			#-------------------------------------------------------------------------------
			if(!IsSet($Line[2]))
				continue;
			#-------------------------------------------------------------------------------
			$OutTmp[Str_Replace($Replace,'_',Trim($Line[0]))] = Trim($Line[1]);
			#-------------------------------------------------------------------------------
		}
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	$Replace2 = Array(' degrees C',' RPM',' Watts',' percent');
	#-------------------------------------------------------------------------------
	foreach(Array_Keys($OutTmp) as $Key){
		#-------------------------------------------------------------------------------
		Debug(SPrintF('[DSScripting_Get_Account_Usage]: %s: Key = %s; Value = %s',$Scheme['Name'],$Key,$OutTmp[$Key]));
		#-------------------------------------------------------------------------------
		// стрёмные значения
		if(In_Array($OutTmp[$Key],Array('no reading','0x00','0x01')))
			continue;
		#-------------------------------------------------------------------------------
		// если ключа нет - то не надо этот график
		if(!Array_Key_Exists($Key,$Keys))
			continue;
		#-------------------------------------------------------------------------------
		#-------------------------------------------------------------------------------
		// удаляем из значений лишнее
		$Used = Str_Replace($Replace2,'',$OutTmp[$Key]);
		#-------------------------------------------------------------------------------
		// меняем значения
		$Used = Str_Replace(Array('on','off','false','true'),Array('Включен','Выклчюен','нет','да'),$Used);
		#-------------------------------------------------------------------------------
		// добавляем к выходным значениям
		$Out[$User]['Last'][$Keys[$Key]] = Array('Used'=>$Used);
		#-------------------------------------------------------------------------------
	}

	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	return $Out;
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
}

#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
# Функции используемые для внутреннего употребления =)
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
# надо вынести сюда кусок повторяющийся во всех функциях
function DSScripting_Build_HTTP($Settings){
	/******************************************************************************/
	$__args_types = Array('array');
	$__args__ = Func_Get_Args(); Eval(FUNCTION_INIT);
	/******************************************************************************/
	$authinfo = SPrintF('%s:%s',$Settings['Login'],$Settings['Password']);
	#-------------------------------------------------------------------------------
	$HTTP = Array(
			'Address'	=> $Settings['Params']['IP'],
			'Port'		=> $Settings['Port'],
			'Host'		=> $Settings['Address'],
			'Protocol'	=> $Settings['Protocol'],
			'Hidden'	=> $authinfo,
			'IsLogging'	=> $Settings['Params']['IsLogging']
			);
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	return $HTTP;
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
}

#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
// путь к файлу куда скидываются настройки сервера
function DSScripting_SaveFile($Settings,$Attribs){
	/******************************************************************************/
	$__args_types = Array('array','array');
	$__args__ = Func_Get_Args(); Eval(FUNCTION_INIT);
	/******************************************************************************/
	// определяем путь к файлу
	$Tmp = System_Element('tmp');
	if(Is_Error($Tmp))
		return ERROR | @Trigger_Error('[system/libs/DSScripting]: не удалось найти временную папку');
	#-------------------------------------------------------------------------------
	$File = SPrintF('%s/files/%s',$Tmp,UniqID('DS'));
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	// готовим настройки 
	$Content = Array('#!/bin/sh');
	#-------------------------------------------------------------------------------
	// настройки управляющего сервера
	$Array = Array_ToLine($Settings);
	#-------------------------------------------------------------------------------
	foreach(Array_Keys($Array) as $Key){
		#-------------------------------------------------------------------------------
		$Name = SPrintF('Settings%s',Str_Replace('.','',$Key));
		$Content[] = SPrintF('%s="%s"',$Name,$Array[$Key]);
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	// настройки тарифа
	$Array = Array_ToLine($Attribs);
	#-------------------------------------------------------------------------------
	foreach(Array_Keys($Array) as $Key){
		#-------------------------------------------------------------------------------
		$Name = SPrintF('Scheme%s',Str_Replace('.','',$Key));
		$Content[] = SPrintF('%s="%s"',$Name,$Array[$Key]);
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	// сохраняем настройки в файл
	$IsWrited = IO_Write($File,Implode("\n",$Content),TRUE);
	if(Is_Error($IsWrited))
		return ERROR | @Trigger_Error('[system/libs/DSScripting->SaveFile]: не удалось сохранить файл');
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	return $File;
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
}

#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
// путь к файлу куда скидываются настройки управляющего и управлемого серверов
function DSScripting_DeleteFile($File){
	/******************************************************************************/
	$__args_types = Array('string');
	$__args__ = Func_Get_Args(); Eval(FUNCTION_INIT);
	/******************************************************************************/
	// удаляем файл с настройками
	if(!UnLink($File))
		return new gException('CANNOT_DELETE_FILE',SPrintF('Не удалось удалить файл: %s',$File));
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	return TRUE;
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
}

#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
// путь к файлу куда скидываются настройки управляющего и управлемого серверов
function DSScripting_CheckFile($File){
	/******************************************************************************/
	$__args_types = Array('string');
	$__args__ = Func_Get_Args(); Eval(FUNCTION_INIT);
	/******************************************************************************/
	# находим полный путь к файлу
	if(SubStr($File,0,1) != '/')
		$File = SPrintF('%s/hosts/%s/scripts/%s',SYSTEM_PATH,HOST_ID,$File);
	#-------------------------------------------------------------------------------
	# проверяем наличие файла по этому пути
	if(!File_Exists($File))
		return ERROR | @Trigger_Error(SPrintF('[system/libs/DSScripting->CheckFile]: отсутствует файл: %s',$File));
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	return $File;
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
}

#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
// выполнение IPMI
function DSScripting_IPMI_Execute($Scheme,$Command){
	#-------------------------------------------------------------------------------
	#ipmitool -c -I lanplus -H bld2-ds01-IPMI.test-hf.su -U ADMIN -P XXXXXX chassis status
	#-------------------------------------------------------------------------------
	// достаём имя сервера
	$ParseUrl = Parse_Url($Scheme['ILOaddr']);
	#-------------------------------------------------------------------------------
	// может быть IP адрес или голый хостнейм без http
	$Address = IsSet($ParseUrl['host'])?$ParseUrl['host']:$ParseUrl['path'];
	#-------------------------------------------------------------------------------
	$Line = SPrintF('ipmitool -I lanplus -N 1 -R 1 -H %s -U %s -P %s %s',$Address,$Scheme['ILOuser'],$Scheme['ILOpass'],$Command);
	#-------------------------------------------------------------------------------
	Debug(SPrintF('[system/libs/IPMI.SuperMicro.php]: выполняем: %s',Preg_Replace(SPrintF('/%s/',$Scheme['ILOpass']),'***HIDDEN***',$Line)));
	// выполянем команду
	Exec(SPrintF("%s 2>&1",$Line),$Out,$ReturnValue);
	#-------------------------------------------------------------------------------
	Debug(SPrintF('[IPMI_Execute]: exec return code = %s, Out = %s',$ReturnValue,print_r($Out,true)));
	#-------------------------------------------------------------------------------
	if($ReturnValue != 0)
		return FALSE;
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	// вертаем выхлоп
	return $Out;
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
}



?>
