<?php
#-------------------------------------------------------------------------------
/** @author Великодный В.В. (Joonte Ltd.) */
#-------------------------------------------------------------------------------
if(Is_Error(System_Load('libs/HTTP.php','classes/Net_IDNA.class.php')))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
function IspManager4_Logon($Settings,$Params){
	/******************************************************************************/
	$__args_types = Array('array','array');
	#-------------------------------------------------------------------------------
	$__args__ = Func_Get_Args(); Eval(FUNCTION_INIT);
	/******************************************************************************/
	return Array('Url'=>$Settings['Params']['Url'],'Args'=>Array('lang'=>$Settings['Params']['Language'],'theme'=>$Settings['Params']['Theme'],'checkcookie'=>'no','username'=>$Params['Login'],'password'=>$Params['Password'],'func'=>'auth'));
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
function IspManager4_Get_Domains($Settings){
	/****************************************************************************/
	$__args_types = Array('array');
	#-----------------------------------------------------------------------------
	$__args__ = Func_Get_Args(); Eval(FUNCTION_INIT);
	/****************************************************************************/
	$authinfo = SPrintF('%s:%s',$Settings['Login'],$Settings['Password']);
	#-----------------------------------------------------------------------------
	$HTTP = IspManager4_Build_HTTP($Settings);
	#-------------------------------------------------------------------------------
	# достаём список пользователей/реселлеров
	$Response = HTTP_Send('/manager/ispmgr',$HTTP,Array(),Array('authinfo'=>$authinfo,'out'=>'xml','func'=>'user'));
	if(Is_Error($Response))
		return new gException('NOT_CONNECTED_TO_SERVER','Не удалось соедениться с сервером');
	#-------------------------------------------------------------------------------
	$Response = Trim($Response['Body']);
	#-----------------------------------------------------------------------------
	$XML = String_XML_Parse($Response);
	if(Is_Exception($XML))
		return new gException('WRONG_SERVER_ANSWER',$Response,$XML);
	#-----------------------------------------------------------------------------
	$XML = $XML->ToArray('elem');
	#-----------------------------------------------------------------------------
	$Elems = $XML['doc'];
	#-----------------------------------------------------------------------------
	if(IsSet($Elems['error']))
		return new gException('GET_USERS_ERROR',$Elems['error']);
	#-----------------------------------------------------------------------------
	$Resellers = Array();
	#-----------------------------------------------------------------------------
	if(Is_Array($Elems)){
		#-------------------------------------------------------------------------------
		foreach($Elems as $Elem)
			if(IsSet($Elem['owner']) && !In_Array($Elem['owner'],$Resellers))
				$Resellers[] = $Elem['owner'];
		#-------------------------------------------------------------------------------
	}
	#Debug(SPrintF('[system/libs/IspManager4.php]: Resellers = %s',print_r($Resellers,true)));
	#-----------------------------------------------------------------------------
	#-----------------------------------------------------------------------------
	$Owners = Array();
	#-----------------------------------------------------------------------------
	if(Is_Array($Elems)){
		#-------------------------------------------------------------------------------
		foreach($Elems as $Elem)
			if(IsSet($Elem['owner']) && In_Array($Elem['owner'],$Resellers))
				$Owners[$Elem['name']] = $Elem['owner'];
		#-------------------------------------------------------------------------------
	}
	#Debug(SPrintF('[system/libs/IspManager4.php]: Owners = %s',print_r($Owners,true)));
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	# строим выхлопной массив
	$Users = Array();
	#-------------------------------------------------------------------------------
	# достаём список www доменов
	$Response = HTTP_Send('/manager/ispmgr',$HTTP,Array(),Array('authinfo'=>$authinfo,'out'=>'xml','func'=>'wwwdomain'));
	if(Is_Error($Response))
		return new gException('NOT_CONNECTED_TO_SERVER','Не удалось соедениться с сервером');
	#-----------------------------------------------------------------------------
	$Response = Trim($Response['Body']);
	#-----------------------------------------------------------------------------
	$XML = String_XML_Parse($Response);
	if(Is_Exception($XML))
		return new gException('WRONG_SERVER_ANSWER',$Response,$XML);
	#-----------------------------------------------------------------------------
	$XML = $XML->ToArray('elem');
	#-----------------------------------------------------------------------------
	$Domains = $XML['doc'];
	#-----------------------------------------------------------------------------
	if(!Is_Array($Domains))
		return new gException('WWW_DOMAINS_NOT_FOUND','WWW доменов не обнаружено');
	#-----------------------------------------------------------------------------
	if(IsSet($Domains['error']))
		return new gException('GET_WWW_DOMAINS_ERROR',$Domains['error']);
	#-----------------------------------------------------------------------------
	foreach($Domains as $Domain){
		#---------------------------------------------------------------------------
		if(!IsSet($Domain['owner']))
			continue;
		#---------------------------------------------------------------------------
		$Owner = $Domain['owner'];
		#---------------------------------------------------------------------------
		if(!IsSet($Users[$Owner]))
			$Users[$Owner] = Array();
		#---------------------------------------------------------------------------
		$Users[$Owner][] = $Domain['name'];
		#---------------------------------------------------------------------------
		# домены юзеров реселлеров
		if(IsSet($Owners[$Owner])){
			#---------------------------------------------------------------------------
			if(!IsSet($Users[$Owners[$Owner]]))
				$Users[$Owners[$Owner]] = Array();
			#---------------------------------------------------------------------------
			$Users[$Owners[$Owner]][] = $Domain['name'];
		}
		#---------------------------------------------------------------------------
	}
	#-----------------------------------------------------------------------------
	#-----------------------------------------------------------------------------
	# достаём DNS домены
	$Response = HTTP_Send('/manager/ispmgr',$HTTP,Array(),Array('authinfo'=>$authinfo,'out'=>'xml','func'=>'domain'));
	if(Is_Error($Response))
		return new gException('NOT_CONNECTED_TO_SERVER','Не удалось соедениться с сервером');
	#-----------------------------------------------------------------------------
	$Response = Trim($Response['Body']);
	#-----------------------------------------------------------------------------
	$XML = String_XML_Parse($Response);
	if(Is_Exception($XML))
		return new gException('WRONG_SERVER_ANSWER',$Response,$XML);
	#-----------------------------------------------------------------------------
	$XML = $XML->ToArray('elem');
	#-----------------------------------------------------------------------------
	$Domains = $XML['doc'];
	#-----------------------------------------------------------------------------
	if(!Is_Array($Domains))
		return new gException('DNS_DOMAINS_NOT_FOUND','DNS доменов не обнаружено');
	#-----------------------------------------------------------------------------
	if(IsSet($Domains['error']))
		return new gException('GET_DNS_DOMAINS_ERROR',$Domains['error']);
	#-----------------------------------------------------------------------------
	foreach($Domains as $Domain){
		#---------------------------------------------------------------------------
		if(!IsSet($Domain['owner']))
			continue;
		#---------------------------------------------------------------------------
		$Owner = $Domain['owner'];
		#---------------------------------------------------------------------------
		if(!IsSet($Users[$Owner]))
			$Users[$Owner] = Array();
		#---------------------------------------------------------------------------
		if(!In_Array($Domain['name'],$Users[$Owner]))
			$Users[$Owner][] = $Domain['name'];
		#---------------------------------------------------------------------------
		# домены юзеров реселлеров
		if(IsSet($Owners[$Owner])){
			#---------------------------------------------------------------------------
			if(!IsSet($Users[$Owners[$Owner]]))
				$Users[$Owners[$Owner]] = Array();
			#---------------------------------------------------------------------------
			if(!In_Array($Domain['name'],$Users[$Owners[$Owner]]))
				$Users[$Owners[$Owner]][] = $Domain['name'];
		}
		#---------------------------------------------------------------------------
	}
	#-----------------------------------------------------------------------------
	#-----------------------------------------------------------------------------
	# достаём Email домены
	$Response = HTTP_Send('/manager/ispmgr',$HTTP,Array(),Array('authinfo'=>$authinfo,'out'=>'xml','func'=>'emaildomain'));
	if(Is_Error($Response))
		return new gException('NOT_CONNECTED_TO_SERVER','Не удалось соедениться с сервером');
	#-----------------------------------------------------------------------------
	$Response = Trim($Response['Body']);
	#-----------------------------------------------------------------------------
	$XML = String_XML_Parse($Response);
	if(Is_Exception($XML))
		return new gException('WRONG_SERVER_ANSWER',$Response,$XML);
	#-----------------------------------------------------------------------------
	$XML = $XML->ToArray('elem');
	#-----------------------------------------------------------------------------
	$Domains = $XML['doc'];
	#-----------------------------------------------------------------------------
	if(!Is_Array($Domains))
		return new gException('EMAIL_DOMAINS_NOT_FOUND','Email доменов не обнаружено');
	#-----------------------------------------------------------------------------
	if(IsSet($Domains['error']))
		return new gException('GET_EMAIL_DOMAINS_ERROR',$Domains['error']);
	#-----------------------------------------------------------------------------
	foreach($Domains as $Domain){
		#---------------------------------------------------------------------------
		if(!IsSet($Domain['owner']))
			continue;
		#---------------------------------------------------------------------------
		$Owner = $Domain['owner'];
		#---------------------------------------------------------------------------
		if(!IsSet($Users[$Owner]))
			$Users[$Owner] = Array();
		#---------------------------------------------------------------------------
		if(!In_Array($Domain['name'],$Users[$Owner]))
			$Users[$Owner][] = $Domain['name'];
		#---------------------------------------------------------------------------
		# домены юзеров реселлеров
		if(IsSet($Owners[$Owner])){
			#---------------------------------------------------------------------------
			if(!IsSet($Users[$Owners[$Owner]]))
				$Users[$Owners[$Owner]] = Array();
			#---------------------------------------------------------------------------
			if(!In_Array($Domain['name'],$Users[$Owners[$Owner]]))
				$Users[$Owners[$Owner]][] = $Domain['name'];
		}
		#---------------------------------------------------------------------------
	}

	#Debug(SPrintF('[system/libs/IspManager4.php]: UsersList = %s',print_r($Users,true)));
	return $Users;
	#-----------------------------------------------------------------------------
}
#-----------------------------------------------------------------------------
#-------------------------------------------------------------------------------
function IspManager4_Get_Users($Settings){
  /****************************************************************************/
  $__args_types = Array('array');
  #-----------------------------------------------------------------------------
  $__args__ = Func_Get_Args(); Eval(FUNCTION_INIT);
  /****************************************************************************/
  $Version = IspManager4_Check_Version($Settings);
  #-------------------------------------------------------------------------------
  $authinfo = SPrintF('%s:%s',$Settings['Login'],$Settings['Password']);
  #-----------------------------------------------------------------------------
  $HTTP = IspManager4_Build_HTTP($Settings);
  #-----------------------------------------------------------------------------
  $Response = HTTP_Send('/manager/ispmgr',$HTTP,Array(),Array('authinfo'=>$authinfo,'out'=>'xml','func'=>'user'));
  if(Is_Error($Response))
    return new gException('NOT_CONNECTED_TO_SERVER','Не удалось соедениться с сервером');
  #-----------------------------------------------------------------------------
  $Response = Trim($Response['Body']);
  #-----------------------------------------------------------------------------
  $XML = String_XML_Parse($Response);
  if(Is_Exception($XML))
    return new gException('WRONG_SERVER_ANSWER',$Response,$XML);
  #-----------------------------------------------------------------------------
  $XML = $XML->ToArray('elem');
  #-----------------------------------------------------------------------------
  $Users = $XML['doc'];
  #-----------------------------------------------------------------------------
  if(IsSet($Users['error']))
    return new gException('GET_USERS_ERROR',$Users['error']);
  #-----------------------------------------------------------------------------
  $Result = Array();
  #-----------------------------------------------------------------------------
  foreach($Users as $User){
    #---------------------------------------------------------------------------
    if(!IsSet($User['name']))
      continue;
    #---------------------------------------------------------------------------
    if(!IsSet($User['owner']))
      if($Version != 'Lite')
        continue;
    #---------------------------------------------------------------------------
    if(!IsSet($User['owner']))
      $User['owner'] = $Settings['Login'];
    #-------------------------------------------------------------------------------
    if($User['owner'] == $Settings['Login'])
      $Result[] = $User['name'];
  }
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	if($Version != 'Lite'){
		#-------------------------------------------------------------------------------
		$Response = HTTP_Send('/manager/ispmgr',$HTTP,Array(),Array('authinfo'=>$authinfo,'out'=>'xml','func'=>'reseller'));
		if(Is_Error($Response))
			return new gException('NOT_CONNECTED_TO_SERVER','Не удалось соедениться с сервером');
		#-------------------------------------------------------------------------------
		$Response = Trim($Response['Body']);
		#-------------------------------------------------------------------------------
		$XML = String_XML_Parse($Response);
		if(Is_Exception($XML))
			return new gException('WRONG_SERVER_ANSWER',$Response,$XML);
		#-------------------------------------------------------------------------------
		$XML = $XML->ToArray('elem');
		#-------------------------------------------------------------------------------
		$Users = $XML['doc'];
		#-------------------------------------------------------------------------------
		if(IsSet($Users['error']))
			return new gException('GET_USERS_ERROR',$Users['error']);
		#-------------------------------------------------------------------------------
		if(Is_Array($Users)){
			#-------------------------------------------------------------------------------
			foreach($Users as $User){
				#-------------------------------------------------------------------------------
				if(!IsSet($User['name']))
					continue;
				#-------------------------------------------------------------------------------
				$Result[] = $User['name'];
				#-------------------------------------------------------------------------------
			}
			#-------------------------------------------------------------------------------
		}
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
  $Response = HTTP_Send('/manager/ispmgr',$HTTP,Array(),Array('authinfo'=>$authinfo,'out'=>'xml','func'=>'mgradmin'));
  if(Is_Error($Response))
    return new gException('NOT_CONNECTED_TO_SERVER','Не удалось соедениться с сервером');
  #-----------------------------------------------------------------------------
  $Response = Trim($Response['Body']);
  #-----------------------------------------------------------------------------
  $XML = String_XML_Parse($Response);
  if(Is_Exception($XML))
    return new gException('WRONG_SERVER_ANSWER',$Response,$XML);
  #-----------------------------------------------------------------------------
  $XML = $XML->ToArray('elem');
  #-----------------------------------------------------------------------------
  $Users = $XML['doc'];
  #-----------------------------------------------------------------------------
  if(IsSet($Users['error']))
    return new gException('GET_USERS_ERROR',$Users['error']);
  #-----------------------------------------------------------------------------
  if(Is_Array($Users)){
    foreach($Users as $User){
      #---------------------------------------------------------------------------
      if(!IsSet($User['name']))
        continue;
      #---------------------------------------------------------------------------
      if($User['name'] != $Settings['Login'])
        $Result[] = $User['name'];
    }
  }
  #-----------------------------------------------------------------------------
  #-----------------------------------------------------------------------------
  return $Result;
}

#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
function IspManager4_Create($Settings,$Login,$Password,$Domain,$IP,$HostingScheme,$Email,$PersonID = 'Default',$Person = Array()){
/******************************************************************************/
	$__args_types = Array('array','string','string','string','string','array','string','string','array');
	#-------------------------------------------------------------------------------
	$__args__ = Func_Get_Args(); Eval(FUNCTION_INIT);
	/******************************************************************************/
	$authinfo = SPrintF('%s:%s',$Settings['Login'],$Settings['Password']);
	#-------------------------------------------------------------------------------
	$HTTP = IspManager4_Build_HTTP($Settings);
	#-------------------------------------------------------------------------------
	$IsReselling = $HostingScheme['IsReselling'];
	$IsReselling = FALSE;	// нахер. не пользуюсь.
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	# JBS-543, проверяем наличие такого юзера
	$Request = Array('authinfo'=>$authinfo,'func'=>$IsReselling?'reseller.edit':'user.edit','out'=>'xml','elid'=>$Login);
	#-------------------------------------------------------------------------------
	$Response = HTTP_Send('/manager/ispmgr',$HTTP,Array(),$Request);
	if(Is_Error($Response))
		return new gException('NOT_CONNECTED_TO_SERVER','Не удалось соедениться с сервером');
	#-------------------------------------------------------------------------------
	$Response = Trim($Response['Body']);
	#-------------------------------------------------------------------------------
	$XML = String_XML_Parse($Response);
	if(Is_Exception($XML))
		return new gException('WRONG_SERVER_ANSWER',$Response,$XML);
	#-------------------------------------------------------------------------------
	$XML = $XML->ToArray();
	#-------------------------------------------------------------------------------
	$Doc = $XML['doc'];
	#-------------------------------------------------------------------------------
	if(!IsSet($Doc['error']))
		return TRUE;
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	$IDNA = new Net_IDNA();
	$Domain = $IDNA->encode($Domain);
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	$Request = Array(
			'authinfo'	=> $authinfo,
			'out'		=> 'xml', # Формат вывода
			'func'		=> ($IsReselling?'reseller.edit':'user.edit'), # Целевая функция
			'sok'		=> 'yes', # Значение параметра должно быть равно "yes"
			'name'		=> $Login, # Имя пользователя (реселлера)
			'passwd'	=> $Password, # Пароль
			'confirm'	=> $Password, # Подтверждение
			'ip'		=> ($IsReselling?'noassign':$IP), # IP-адрес
			'preset'	=> $HostingScheme['PackageID'], # Шаблон
			'email'		=> $Email,
			);
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	// считываем XML и составляем запрос
	$Fields = System_XML(SPrintF('config/Schemes.%s.xml',$HostingScheme['SchemeParams']['SystemID']));
	if(Is_Error($Fields))
		return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------------
	foreach(Array_Keys($Fields) as $Key){
		#-------------------------------------------------------------------------------
		$Field = $Fields[$Key];
		#-------------------------------------------------------------------------------
		$Value = IsSet($HostingScheme['SchemeParams'][$Key])?$HostingScheme['SchemeParams'][$Key]:$Field['Value'];
		#-------------------------------------------------------------------------------
		$Request[$Key] = $Value;
		if(IsSet($Field['Min']))
			$Request[$Key] = IntVal($Value);
		#-------------------------------------------------------------------------------
		if(IsSet($Field['Type']) && $Field['Type'] == 'CheckBox')
			$Request[$Key] = ($Request[$Key])?'on':'off';
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	if($HostingScheme['SchemeParams']['webdomainlimit'])
		$Request['domain'] = $Domain; # Домен
	#-------------------------------------------------------------------------------
	$Request['owner'] = $Settings['Login']; # Владелец
	#-------------------------------------------------------------------------------
	$Response = HTTP_Send('/manager/ispmgr',$HTTP,Array(),$Request);
	if(Is_Error($Response))
		return ERROR | @Trigger_Error('[IspManager4_Create]: не удалось соедениться с сервером');
	#-------------------------------------------------------------------------------
	$Response = Trim($Response['Body']);
	#-------------------------------------------------------------------------------
	$XML = String_XML_Parse($Response);
	if(Is_Exception($XML))
		return new gException('WRONG_SERVER_ANSWER',$Response,$XML);
	#-------------------------------------------------------------------------------
	$XML = $XML->ToArray();
	#-------------------------------------------------------------------------------
	$Doc = $XML['doc'];
	#-------------------------------------------------------------------------------
	if(IsSet($Doc['error']))
		return new gException('ACCOUNT_CREATE_ERROR','Не удалось создать заказ хостинга');
	#-------------------------------------------------------------------------------
	if(!$Settings['Params']['NoRestartCreate']){
		#-------------------------------------------------------------------------------
		$Request = Array('authinfo'=>SPrintF('%s:%s',$Settings['Login'],$Settings['Password']),'out'=>'xml','func'=>'restart');
		#-------------------------------------------------------------------------------
		$Response = HTTP_Send('/manager/ispmgr',$HTTP,Array(),$Request);
		if(Is_Error($Response))
			return ERROR | @Trigger_Error('[IspManager4_Create]: не удалось соедениться с сервером');
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	return TRUE;
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
}


#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
function IspManager4_Active($Settings,$Login,$IsReseller = FALSE){
  /****************************************************************************/
  $__args_types = Array('array','string','boolean');
  #-----------------------------------------------------------------------------
  $__args__ = Func_Get_Args(); Eval(FUNCTION_INIT);
  /****************************************************************************/
  $authinfo = SPrintF('%s:%s',$Settings['Login'],$Settings['Password']);
  #-----------------------------------------------------------------------------
  $HTTP = IspManager4_Build_HTTP($Settings);
  #-----------------------------------------------------------------------------
  $Response = HTTP_Send('/manager/ispmgr',$HTTP,Array(),Array('authinfo'=>$authinfo,'out'=>'xml','func'=>$IsReseller?'reseller.enable':'user.enable','elid'=>$Login));
  if(Is_Error($Response))
    return ERROR | @Trigger_Error('[IspManager4_Activate]: не удалось соедениться с сервером');
  #-----------------------------------------------------------------------------
  $Response = Trim($Response['Body']);
  #-----------------------------------------------------------------------------
  $XML = String_XML_Parse($Response);
  if(Is_Exception($XML))
    return new gException('WRONG_SERVER_ANSWER',$Response,$XML);
  #-----------------------------------------------------------------------------
  $XML = $XML->ToArray();
  #-----------------------------------------------------------------------------
  $Doc = $XML['doc'];
  #-----------------------------------------------------------------------------
  if(IsSet($Doc['error']))
    return new gException('ACCOUNT_ACTIVATE_ERROR','Не удалось активировать заказ хостинга');
  #-----------------------------------------------------------------------------
  if(!$Settings['Params']['NoRestartActive']){
          $Request = Array(
            #---------------------------------------------------------------------------
            'authinfo' => SPrintF('%s:%s',$Settings['Login'],$Settings['Password']),
            'out'      => 'xml',
            'func'     => 'restart'
          );
          #-----------------------------------------------------------------------------
          $Response = HTTP_Send('/manager/ispmgr',$HTTP,Array(),$Request);
          if(Is_Error($Response))
            return ERROR | @Trigger_Error('[IspManager4_Activate]: не удалось соедениться с сервером');
  }
  #-----------------------------------------------------------------------------
  return TRUE;
}
#-------------------------------------------------------------------------------
function IspManager4_Suspend($Settings,$Login,$IsReseller = FALSE){
  /****************************************************************************/
  $__args_types = Array('array','string','boolean');
  #-----------------------------------------------------------------------------
  $__args__ = Func_Get_Args(); Eval(FUNCTION_INIT);
  /****************************************************************************/
  $authinfo = SPrintF('%s:%s',$Settings['Login'],$Settings['Password']);
  #-----------------------------------------------------------------------------
  $HTTP = IspManager4_Build_HTTP($Settings);
  #-----------------------------------------------------------------------------
  $Response = HTTP_Send('/manager/ispmgr',$HTTP,Array(),Array('authinfo'=>$authinfo,'out'=>'xml','func'=>$IsReseller?'reseller.disable':'user.disable','elid'=>$Login));
  if(Is_Error($Response))
    return ERROR | @Trigger_Error('[IspManager4_Suspend]: не удалось соедениться с сервером');
  #-----------------------------------------------------------------------------
  $Response = Trim($Response['Body']);
  #-----------------------------------------------------------------------------
  $XML = String_XML_Parse($Response);
  if(Is_Exception($XML))
    return new gException('WRONG_SERVER_ANSWER',$Response,$XML);
  #-----------------------------------------------------------------------------
  $XML = $XML->ToArray();
  #-----------------------------------------------------------------------------
  $Doc = $XML['doc'];
  #-----------------------------------------------------------------------------
  if(IsSet($Doc['error']))
    return new gException('ACCOUNT_SUSPEND_ERROR','Не удалось заблокировать заказ хостинга');
  #-----------------------------------------------------------------------------
  if(!$Settings['Params']['NoRestartSuspend']){
          $Request = Array(
            #---------------------------------------------------------------------------
            'authinfo' => SPrintF('%s:%s',$Settings['Login'],$Settings['Password']),
            'out'      => 'xml',
            'func'     => 'restart'
          );
          #-----------------------------------------------------------------------------
          $Response = HTTP_Send('/manager/ispmgr',$HTTP,Array(),$Request);
          if(Is_Error($Response))
            return ERROR | @Trigger_Error('[IspManager4_Suspend]: не удалось соедениться с сервером');
  }
  #-----------------------------------------------------------------------------
  return TRUE;
}
#-------------------------------------------------------------------------------
function IspManager4_Delete($Settings,$Login,$IsReseller = FALSE){
  /****************************************************************************/
  $__args_types = Array('array','string','boolean');
  #-----------------------------------------------------------------------------
  $__args__ = Func_Get_Args(); Eval(FUNCTION_INIT);
  /****************************************************************************/
  $authinfo = SPrintF('%s:%s',$Settings['Login'],$Settings['Password']);
  #-----------------------------------------------------------------------------
  $HTTP = IspManager4_Build_HTTP($Settings);
  #-----------------------------------------------------------------------------
  #-----------------------------------------------------------------------------
  # JBS-543, проверяем наличие такого юзера
  $Request = Array(
                    'authinfo'      => $authinfo,
                    'func'          => $IsReseller?'reseller.edit':'user.edit',
                    'out'           => 'xml',
                    'elid'          => $Login
		   );
  #-----------------------------------------------------------------------------
  $Response = HTTP_Send('/manager/ispmgr',$HTTP,Array(),$Request);
  if(Is_Error($Response))
    return new gException('NOT_CONNECTED_TO_SERVER','Не удалось соедениться с сервером');
  #-----------------------------------------------------------------------------
  $Response = Trim($Response['Body']);
  $XML = String_XML_Parse($Response);
  if(Is_Exception($XML))
    return new gException('WRONG_SERVER_ANSWER',$Response,$XML);
  #-----------------------------------------------------------------------------
  $XML = $XML->ToArray();
  #-----------------------------------------------------------------------------
  $Doc = $XML['doc'];
  #-----------------------------------------------------------------------------
  if(IsSet($Doc['error']))
    return TRUE;
  #-----------------------------------------------------------------------------
  #-----------------------------------------------------------------------------
  # проверка что это реселлер, если так - надо дропать его юзеров
  if($IsReseller){
  	# достаём список всех юзеров
	$Request = Array(
			'authinfo'      => $authinfo,
			'func'          => 'user',
			'out'           => 'xml',
			'su'            => $Login
		);
	#-----------------------------------------------------------------------------
	$Response = HTTP_Send('/manager/ispmgr',$HTTP,Array(),$Request);
	if(Is_Error($Response))
		return new gException('NOT_CONNECTED_TO_SERVER','Не удалось соедениться с сервером');
	#-----------------------------------------------------------------------------
	$Response = Trim($Response['Body']);
	$XML = String_XML_Parse($Response);
	if(Is_Exception($XML))
		return new gException('WRONG_SERVER_ANSWER',$Response,$XML);
	#-----------------------------------------------------------------------------
	$XML = $XML->ToArray('elem');
	$Users = $XML['doc'];
	if(Is_Array($Users)){
		#-----------------------------------------------------------------------------
		# дропаем юзеров
		foreach($Users as $User){
			#-----------------------------------------------------------------------------
			$Request = Array(
					'authinfo'      => $authinfo,
					'func'		=> 'user.delete',
					'out'		=> 'xml',
					'su'		=> $Login,
					'elid'		=> $User['name']
				);
			#-----------------------------------------------------------------------------
			$Response = HTTP_Send('/manager/ispmgr',$HTTP,Array(),$Request);
			if(Is_Error($Response))
				return ERROR | @Trigger_Error('[IspManager4_Delete]: не удалось соедениться с сервером');
			# я так думаю, неважно чё он там ответил, если ответил...
			#-----------------------------------------------------------------------------
		}
		#-----------------------------------------------------------------------------
	}
	#-----------------------------------------------------------------------------
  }
  #-----------------------------------------------------------------------------
  $Response = HTTP_Send('/manager/ispmgr',$HTTP,Array(),Array('authinfo'=>$authinfo,'out'=>'xml','func'=>$IsReseller?'reseller.delete':'user.delete','elid'=>$Login));
  if(Is_Error($Response))
    return ERROR | @Trigger_Error('[IspManager4_Delete]: не удалось соедениться с сервером');
  #-----------------------------------------------------------------------------
  $Response = Trim($Response['Body']);
  #-----------------------------------------------------------------------------
  $XML = String_XML_Parse($Response);
  if(Is_Exception($XML))
    return new gException('WRONG_SERVER_ANSWER',$Response,$XML);
  #-----------------------------------------------------------------------------
  $XML = $XML->ToArray();
  #-----------------------------------------------------------------------------
  $Doc = $XML['doc'];
  #-----------------------------------------------------------------------------
  if(IsSet($Doc['error']))
    return new gException('ACCOUNT_DELETE_ERROR','Не удалось удалить заказ хостинга');
  #-----------------------------------------------------------------------------
  if(!$Settings['Params']['NoRestartDelete']){
          $Request = Array(
            #---------------------------------------------------------------------------
            'authinfo' => SPrintF('%s:%s',$Settings['Login'],$Settings['Password']),
            'out'      => 'xml',
            'func'     => 'restart'
          );
          #-----------------------------------------------------------------------------
          $Response = HTTP_Send('/manager/ispmgr',$HTTP,Array(),$Request);
          if(Is_Error($Response))
            return ERROR | @Trigger_Error('[IspManager4_Delete]: не удалось соедениться с сервером');
  }
  #-----------------------------------------------------------------------------
  return TRUE;
}


#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
function IspManager4_Scheme_Change($Settings,$Login,$HostingScheme){
	/******************************************************************************/
	$__args_types = Array('array','string','array');
	#-------------------------------------------------------------------------------
	$__args__ = Func_Get_Args(); Eval(FUNCTION_INIT);
	/******************************************************************************/
	$authinfo = SPrintF('%s:%s',$Settings['Login'],$Settings['Password']);
	#-------------------------------------------------------------------------------
	$HTTP = IspManager4_Build_HTTP($Settings);
	#-------------------------------------------------------------------------------
	$IsReselling = $HostingScheme['IsReselling'];
	$IsReselling = FALSE;	// не пользуюсь, // lissyara
	#-------------------------------------------------------------------------------
	$Request = Array(
			'authinfo'	=> $authinfo,
			'out'		=> 'xml', # Формат вывода
			'func'		=> ($IsReselling?'reseller.edit':'user.edit'), # Целевая функция
			'elid'		=> $Login, # Уникальный идентификатор
			'sok'		=> 'yes', # Значение параметра должно быть равно "yes"
			'name'		=> $Login, # Имя пользователя (реселлера)
			'ip'		=> ($IsReselling?'noassign':$Settings['Params']['IP']), # IP-адрес
			);
	#-------------------------------------------------------------------------------
	$Fields = System_XML(SPrintF('config/Schemes.%s.xml',$HostingScheme['SchemeParams']['SystemID']));
	if(Is_Error($Fields))
		return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------------
	foreach(Array_Keys($Fields) as $Key){
		#-------------------------------------------------------------------------------
		$Field = $Fields[$Key];
		#-------------------------------------------------------------------------------
		if(!$Field['IsSchemeChange'])
			continue;
		#-------------------------------------------------------------------------------
		$Value = IsSet($HostingScheme['SchemeParams'][$Key])?$HostingScheme['SchemeParams'][$Key]:$Field['Value'];
		#-------------------------------------------------------------------------------
		$Request[$Key] = $Value;
		#-------------------------------------------------------------------------------
		if(IsSet($Field['Min']))
			$Request[$Key] = IntVal($Value);
		#-------------------------------------------------------------------------------
		if(IsSet($Field['Type']) && $Field['Type'] == 'CheckBox')
			$Request[$Key] = ($Request[$Key])?'on':'off';
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	$Request['preset']	= $HostingScheme['PackageID']; # Шаблон
	#-------------------------------------------------------------------------------
	if(!$IsReselling){
		#-------------------------------------------------------------------------------
		$Request['owner']= $Settings['Login']; # Владелец
		#-------------------------------------------------------------------------------
	}else{
		#-------------------------------------------------------------------------------
		$Request['userlimit'] = 10; #$HostingScheme['SchemeParams']['']; # Пользователи
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	$Response = HTTP_Send('/manager/ispmgr',$HTTP,Array(),$Request);
	if(Is_Error($Response))
		return ERROR | @Trigger_Error('[IspManager4_Scheme_Change]: не удалось соедениться с сервером');
	#-------------------------------------------------------------------------------
	$Response = Trim($Response['Body']);
	#-------------------------------------------------------------------------------
	$XML = String_XML_Parse($Response);
	if(Is_Exception($XML))
		return new gException('WRONG_SERVER_ANSWER',$Response,$XML);
	#-------------------------------------------------------------------------------
	$XML = $XML->ToArray();
	#-------------------------------------------------------------------------------
	$Doc = $XML['doc'];
	#-------------------------------------------------------------------------------
	if(IsSet($Doc['error']))
		return new gException('SCHEME_CHANGE_ERROR','Не удалось изменить тарифный план для заказа хостинга');
	#-------------------------------------------------------------------------------
	if(!$Settings['Params']['NoRestartSchemeChange']){
		#-------------------------------------------------------------------------------
		$Request = Array('authinfo'=>SPrintF('%s:%s',$Settings['Login'],$Settings['Password']),'out'=>'xml','func'=>'restart');
		#-------------------------------------------------------------------------------
		$Response = HTTP_Send('/manager/ispmgr',$HTTP,Array(),$Request);
		if(Is_Error($Response))
			return ERROR | @Trigger_Error('[IspManager4_Scheme_Change]: не удалось соедениться с сервером');
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	return TRUE;
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
}

#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
function IspManager4_Password_Change($Settings,$Login,$Password,$Params){
  /****************************************************************************/
  $__args_types = Array('array','string','string','array');
  #-----------------------------------------------------------------------------
  $__args__ = Func_Get_Args(); Eval(FUNCTION_INIT);
  /****************************************************************************/
  $authinfo = SPrintF('%s:%s',$Settings['Login'],$Settings['Password']);
  #-----------------------------------------------------------------------------
  $HTTP = IspManager4_Build_HTTP($Settings);
  #-----------------------------------------------------------------------------
  #-----------------------------------------------------------------------------
  # /usr/local/ispmgr/sbin/mgrctl -m ispmgr -o xml usrparam sok=ok atype=atany su=h33502
  $Request = Array(
    #---------------------------------------------------------------------------
    'authinfo' => $authinfo,
    'out'      => 'xml',
    'func'     => 'usrparam',
    'su'       => $Login,
    'sok'      => 'ok',
    'atype'    => 'atany',         # разрешаем доступ к панели с любого IP
    'passwd'   => $Password,
    'confirm'  => $Password,
  );
  #-----------------------------------------------------------------------------
  $Response = HTTP_Send('/manager/ispmgr',$HTTP,Array(),$Request);
  if(Is_Error($Response))
    return ERROR | @Trigger_Error('[IspManager4_Password_Change]: не удалось соедениться с сервером');
  #-----------------------------------------------------------------------------
  $Response = Trim($Response['Body']);
  #-----------------------------------------------------------------------------
  $XML = String_XML_Parse($Response);
  if(Is_Exception($XML))
    return ERROR | @Trigger_Error('[IspManager4_Password_Change]: неверный ответ от сервера');
  #-----------------------------------------------------------------------------
  $XML = $XML->ToArray();
  #-----------------------------------------------------------------------------
  $Doc = $XML['doc'];
  #-----------------------------------------------------------------------------
  if(IsSet($Doc['error']))
    return new gException('PASSWORD_CHANGE_ERROR','Не удалось изменить пароль для заказа хостинга');
  #-----------------------------------------------------------------------------
  return TRUE;
}
#-------------------------------------------------------------------------------
function IspManager4_Get_Email_Boxes($Settings){
  /****************************************************************************/
  $__args_types = Array('array');
  #-----------------------------------------------------------------------------
  $__args__ = Func_Get_Args(); Eval(FUNCTION_INIT);
  /****************************************************************************/
  $authinfo = SPrintF('%s:%s',$Settings['Login'],$Settings['Password']);
  #-----------------------------------------------------------------------------
  $HTTP = IspManager4_Build_HTTP($Settings);
  #-----------------------------------------------------------------------------
  $Response = HTTP_Send('/manager/ispmgr',$HTTP,Array(),Array('authinfo'=>$authinfo,'out'=>'xml','func'=>'emaildomain'));
  if(Is_Error($Response))
    return new gException('NOT_CONNECTED_TO_SERVER','Не удалось соедениться с сервером');
  #-----------------------------------------------------------------------------
  $Response = Trim($Response['Body']);
  #-----------------------------------------------------------------------------
  $XML = String_XML_Parse($Response);
  if(Is_Exception($XML))
    return new gException('WRONG_SERVER_ANSWER',$Response,$XML);
  #-----------------------------------------------------------------------------
  $XML = $XML->ToArray('elem');
  #-----------------------------------------------------------------------------
  $Result = $XML['doc'];
  #-----------------------------------------------------------------------------
  if(!Is_Array($Result))
    return new gException('BOXES_NOT_FOUND','Почтовых доменов не обнаружено');
  #-----------------------------------------------------------------------------
  if(IsSet($Result['error']))
    return ERROR | @Trigger_Error('[IspManager4_Get_Email_Boxes]: не удалось получить список почтовых ящиков');
  #-----------------------------------------------------------------------------
  $Domains = Array();
  #-----------------------------------------------------------------------------
  foreach($Result as $Domain){
    #---------------------------------------------------------------------------
    if(!Is_Array($Domain))
      continue;
    #---------------------------------------------------------------------------
    $Owner = $Domain['owner'];
    #---------------------------------------------------------------------------
    if(!IsSet($Users[$Owner]))
      $Users[$Owner] = Array();
    #---------------------------------------------------------------------------
    $Domains[$Domain['name']] = Array('Owner'=>$Owner,'Boxes'=>Array());
  }
  #-----------------------------------------------------------------------------
  $Response = HTTP_Send('/manager/ispmgr',$HTTP,Array(),Array('authinfo'=>$authinfo,'out'=>'xml','func'=>'email'));
  if(Is_Error($Response))
    return new gException('NOT_CONNECTED_TO_SERVER','Не удалось соедениться с сервером');
  #-----------------------------------------------------------------------------
  $Response = $Response['Body'];
  #-----------------------------------------------------------------------------
  $XML = String_XML_Parse($Response);
  if(Is_Exception($XML))
    return new gException('WRONG_SERVER_ANSWER','Неверный ответ от сервера');
  #-----------------------------------------------------------------------------
  $XML = $XML->ToArray('elem',Array('used','limit'));
  #-----------------------------------------------------------------------------
  $Result = $XML['doc'];
  #-----------------------------------------------------------------------------
  if(!Is_Array($Result))
    return new gException('BOXES_NOT_FOUND','Почтовых ящиков не обнаружено');
  #-----------------------------------------------------------------------------
  if(IsSet($Result['error']))
    return ERROR | @Trigger_Error('[IspManager4_Get_Email_Boxes]: не удалось получить список почтовых ящиков');
  #-----------------------------------------------------------------------------
  foreach($Result as $Box){
    #---------------------------------------------------------------------------
    if(!Is_Array($Box))
      continue;
    #---------------------------------------------------------------------------
    $Name = Explode('@',$Box['name']);
    #---------------------------------------------------------------------------
    if(!IsSet($Domains[$Domain = Next($Name)]))
      continue;
    #---------------------------------------------------------------------------
    $Domains[$Domain]['Boxes'][$Box['name']] = Array_Values($Box['size']);
  }
  #-----------------------------------------------------------------------------
  $Users = Array();
  #-----------------------------------------------------------------------------
  foreach($Domains as $DomainID=>$Domain){
    #---------------------------------------------------------------------------
    $Owner = $Domain['Owner'];
    #---------------------------------------------------------------------------
    if(!IsSet($Users[$Owner]))
      $Users[$Owner] = Array();
    #---------------------------------------------------------------------------
    foreach($Domain['Boxes'] as $Email=>$Box)
      $Users[$Owner][$Email] = $Box;
  }
  #-----------------------------------------------------------------------------
  return $Users;
}

#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
# added by lissyara 2011-08-08 in 11:25 MSK
function IspManager4_AddIP($Settings,$Login,$ID,$Domain,$IP,$AddressType){
        /******************************************************************************/
        $__args_types = Array('array','string','string','string','string','string');
        $__args__ = Func_Get_Args(); Eval(FUNCTION_INIT);
        /******************************************************************************/
	$Version = IspManager4_Check_Version($Settings);
	#-------------------------------------------------------------------------------
	Debug(SPrintF('[IspManager4_AddIP]: ISPmanager = %s',$Version));
	#-------------------------------------------------------------------------------
	if($Version == 'Lite')
		return new gException('LITE_NOT_SUPPORT_MANAGE_IP_ADDRESS_LIST','Версия ISPmanager Lite 5 не подерживает управление IP адресами');
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
        $authinfo = SPrintF('%s:%s',$Settings['Login'],$Settings['Password']);
        #-----------------------------------------------------------------------------
	$HTTP = IspManager4_Build_HTTP($Settings);
        #-----------------------------------------------------------------------------
        $Request = Array(
                'authinfo'      => $authinfo,
                'out'           => 'xml',
                'func'          => 'iplist.edit',
                'elid'          => '',
                'sok'           => 'ok',
                'stat'          => 'assigned',
                'rname'         => $Domain,
                'owner'         => $Login,
                'type'          => StrToLower($AddressType)
        );
        $Response = HTTP_Send('/manager/ispmgr',$HTTP,Array(),$Request);
        if(Is_Error($Response))
                return new gException('NOT_CONNECTED_TO_SERVER','Не удалось соедениться с сервером');
        #-----------------------------------------------------------------------------
        $Response = Trim($Response['Body']);
        #-----------------------------------------------------------------------------
        $XML = String_XML_Parse($Response);
        if(Is_Exception($XML))
                return new gException('WRONG_SERVER_ANSWER',$Response,$XML);
        $XML = $XML->ToArray();
        #-----------------------------------------------------------------------------
        $Doc = $XML['doc'];
        #-----------------------------------------------------------------------------
        if(IsSet($Doc['error']))
                return new gException('IP_ADD_CREATE_ERROR','Не удалось добавить IP адрес');
        #-----------------------------------------------------------------------------
        #-----------------------------------------------------------------------------
        return Array('ID'=>$ID,'IP'=>$Doc['ip']);
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
}

# added by lissyara 2011-08-10 in 10:13 MSK
#-------------------------------------------------------------------------------
function IspManager4_DeleteIP($Settings,$ExtraIP){
	/****************************************************************************/
        $__args_types = Array('array','string');
        $__args__ = Func_Get_Args(); Eval(FUNCTION_INIT);
        #Debug("ExtraIP order ID = " . $ID);
	/****************************************************************************/
	$Version = IspManager4_Check_Version($Settings);
	#-------------------------------------------------------------------------------
	Debug(SPrintF('[IspManager4_AddIP]: ISPmanager = %s',$Version));
	#-------------------------------------------------------------------------------
	if($Version == 'Lite')
		return new gException('LITE_NOT_SUPPORT_MANAGE_IP_ADDRESS_LIST','Версия ISPmanager Lite 5 не подерживает управление IP адресами');
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	$authinfo = SPrintF('%s:%s',$Settings['Login'],$Settings['Password']);
	#-----------------------------------------------------------------------------
	$HTTP = IspManager4_Build_HTTP($Settings);
        # Логика.
        # 1. определяем число доменов на этом адресе.
        # 2. если доменов больше нуля - переносим их на шаред адрес
        # 3. удаляем IP
        #
        # func=iplist.edit&elid=91.227.16.38
        # func=iplist&clickstat=yes
        $Request = Array(
                'authinfo'      => $authinfo,
                'func'          => 'iplist.edit',
                'out'           => 'xml',
                'elid'          => $ExtraIP
        );
        $Response = HTTP_Send('/manager/ispmgr',$HTTP,Array(),$Request);
        if(Is_Error($Response))
                return ERROR | @Trigger_Error('[IspManager4_DeleteIP]: не удалось соедениться с сервером');
        $Response = Trim($Response['Body']);
        $XML = String_XML_Parse($Response);
        if(Is_Exception($XML))
                return new gException('WRONG_SERVER_ANSWER',$Response,$XML);
        $XML = $XML->ToArray();
        $Doc = $XML['doc'];
        if(IsSet($Doc['error']))
                return new gException('CHECK_IP_STATUS_ERROR','Не удалось проверить статус IP');
        #-----------------------------------------------------------------------------
        #-----------------------------------------------------------------------------
        if(IsSet($Doc['domain'])){
                # IP in use, have some domains
                # func=wwwdomain
                $Request = Array(
                        'authinfo'      => $authinfo,
                        'func'          => 'wwwdomain',
                        'out'           => 'xml',
                        'su'            => $Settings['UserLogin']
                );
                $Response = HTTP_Send('/manager/ispmgr',$HTTP,Array(),$Request);
                if(Is_Error($Response))
                        return new gException('NOT_CONNECTED_TO_SERVER','Не удалось соедениться с сервером');
		#-----------------------------------------------------------------------------
                $Response = Trim($Response['Body']);
		#-----------------------------------------------------------------------------
                $XML = String_XML_Parse($Response);
                if(Is_Exception($XML))
                        return new gException('WRONG_SERVER_ANSWER',$Response,$XML);
		#-----------------------------------------------------------------------------
                $XML = $XML->ToArray('elem');
		#-----------------------------------------------------------------------------
                $Domains = $XML['doc'];
		#-----------------------------------------------------------------------------
                if(!Is_Array($Domains))
                        return new gException('DOMAINS_NOT_FOUND','Доменов не обнаружено');
		#-----------------------------------------------------------------------------
                if(IsSet($Domains['error']))
                        return new gException('GET_DOMAINS_ERROR',$Domains['error']);
		#-----------------------------------------------------------------------------
                foreach($Domains as $Domain){
			#-----------------------------------------------------------------------------
                        if($Domain['ip'] == $ExtraIP){
				#-----------------------------------------------------------------------------
                                #Debug("[system/libs/IspManager4.php]: on IP " . $ExtraIP . " found domain " . $Domain['name']);
                                # get domain settings
                                # func=wwwdomain.edit&elid=ffffff.ru
                                $Request = Array(
                                        'authinfo'      => $authinfo,
                                        'func'          => 'wwwdomain.edit',
                                        'elid'          => $Domain['name'],
                                        'out'           => 'xml',
                                        'su'            => $Settings['UserLogin']
                                );
				#-----------------------------------------------------------------------------
                                $Response = HTTP_Send('/manager/ispmgr',$HTTP,Array(),$Request);
                                if(Is_Error($Response))
                                        return ERROR | @Trigger_Error('[IspManager4_DeleteIP]: не удалось соедениться с сервером');
				#-----------------------------------------------------------------------------
                                $Response = Trim($Response['Body']);
				#-----------------------------------------------------------------------------
                                $XML = String_XML_Parse($Response);
				#-----------------------------------------------------------------------------
                                if(Is_Exception($XML))
                                        return new gException('WRONG_SERVER_ANSWER',$Response,$XML);
				#-----------------------------------------------------------------------------
                                $XML = $XML->ToArray();
				#-----------------------------------------------------------------------------
                                $Doc = $XML['doc'];
				#-----------------------------------------------------------------------------
                                if(IsSet($Doc['error']))
                                        return new gException('USER_DATA_TAKE_ERROR','Ошибка получения данных пользователя из системы управления');
				#-----------------------------------------------------------------------------
                                # change settings
                                $Request = Array(
                                        'authinfo'      => $authinfo,
                                        'out'           => 'xml',
                                        'func'          => 'wwwdomain.edit',
                                        'elid'          => $Domain['name'],
                                        'sok'           => 'ok'
                                );
				#-----------------------------------------------------------------------------
                                foreach(Array_Keys($Doc) as $ParamID)
                                        $Request[$ParamID] = $Doc[$ParamID];
				#-----------------------------------------------------------------------------
                                # change IP to shared
                                $Request['ip']  = $Settings['Params']['IP'];
				#-----------------------------------------------------------------------------
                                $Response = HTTP_Send('/manager/ispmgr',$HTTP,Array(),$Request);
                                if(Is_Error($Response))
                                        return ERROR | @Trigger_Error('[IspManager4_DeleteIP]: не удалось соедениться с сервером');
				#-----------------------------------------------------------------------------
                                $Response = $Response['Body'];
				#-----------------------------------------------------------------------------
                                $XML = String_XML_Parse($Response);
				#-----------------------------------------------------------------------------
                                if(Is_Exception($XML))
                                        return ERROR | @Trigger_Error('[IspManager4_DeleteIP]: неверный ответ от сервера');
				#-----------------------------------------------------------------------------
                                $XML = $XML->ToArray();
				#-----------------------------------------------------------------------------
                                $Doc = $XML['doc'];
				#-----------------------------------------------------------------------------
                                if(IsSet($Doc['error']))
                                        return new gException('IspManager4_DeleteIP','Не удалось изменить IP для домена' . $Domain['name']);
				#-----------------------------------------------------------------------------
                        }
			#-----------------------------------------------------------------------------
                }
		#-----------------------------------------------------------------------------
        }
        #-----------------------------------------------------------------------------
        #-----------------------------------------------------------------------------
	# added by lissyara, 2014-09-19 in 09:02 MSK, for JBS-720
	# 1. достаём все почтовые домены
	# 2. перебираем их, проверяем IP адреса
	# 3. при совпадении с удаляемым - проставляем почтовому домену шареш адрес
	$Request = Array(
			'authinfo'	=> $authinfo,
			'func'		=> 'emaildomain',
			'out'		=> 'xml',
			'su'		=> $Settings['UserLogin']
			);
	#-----------------------------------------------------------------------------
	$Response = HTTP_Send('/manager/ispmgr',$HTTP,Array(),$Request);
	if(Is_Error($Response))
		return new gException('NOT_CONNECTED_TO_SERVER','Не удалось соедениться с сервером');
	#-----------------------------------------------------------------------------
	$Response = Trim($Response['Body']);
	#-----------------------------------------------------------------------------
	$XML = String_XML_Parse($Response);
	if(Is_Exception($XML))
		return new gException('WRONG_SERVER_ANSWER',$Response,$XML);
	#-----------------------------------------------------------------------------
	$XML = $XML->ToArray('elem');
	#-----------------------------------------------------------------------------
	$Domains = $XML['doc'];
	#-----------------------------------------------------------------------------
	if(!Is_Array($Domains)){
		#-----------------------------------------------------------------------------
		Debug('[system/libs/IspManager4.php]: Почтовых доменов не обнаружено');
		#-----------------------------------------------------------------------------
	}else{
		#-----------------------------------------------------------------------------
		if(IsSet($Domains['error']))
			return new gException('GET_DOMAINS_ERROR',$Domains['error']);
		#-----------------------------------------------------------------------------
		foreach($Domains as $Domain){
			#-----------------------------------------------------------------------------
			$Request = Array(
					'authinfo'	=> $authinfo,
					'func'		=> 'emaildomain.edit',
					'elid'		=> $Domain['name'],
					'out'		=> 'xml',
					'su'		=> $Settings['UserLogin']
					);
			#-----------------------------------------------------------------------------
			$Response = HTTP_Send('/manager/ispmgr',$HTTP,Array(),$Request);
			if(Is_Error($Response))
				return new gException('NOT_CONNECTED_TO_SERVER','Не удалось соедениться с сервером');
			#-----------------------------------------------------------------------------
			$Response = Trim($Response['Body']);
			#-----------------------------------------------------------------------------
			$XML = String_XML_Parse($Response);
			if(Is_Exception($XML))
				return new gException('WRONG_SERVER_ANSWER',$Response,$XML);
			#-----------------------------------------------------------------------------
			$XML = $XML->ToArray();
			#-----------------------------------------------------------------------------
			$Doc = $XML['doc'];
			#-----------------------------------------------------------------------------
			if(IsSet($Doc['error']))
				return new gException('IspManager4_DeleteIP',SPrintF('Не удалось изменить IP для email домена %s',$Domain['name']));
			#-----------------------------------------------------------------------------
			if(IsSet($Doc['ip']) && $Doc['ip'] == $ExtraIP){
				#-----------------------------------------------------------------------------
                                # change settings
				$Request = Array(
						'authinfo'      => $authinfo,
						'out'           => 'xml',
						'func'          => 'emaildomain.edit',
						'sok'           => 'ok'
						);
				#-----------------------------------------------------------------------------
				foreach(Array_Keys($Doc) as $ParamID)
					$Request[$ParamID] = $Doc[$ParamID];
				#-----------------------------------------------------------------------------
				# change IP to shared
				$Request['ip']  = $Settings['Params']['IP'];
				#-----------------------------------------------------------------------------
				$Response = HTTP_Send('/manager/ispmgr',$HTTP,Array(),$Request);
				if(Is_Error($Response))
					return ERROR | @Trigger_Error('[IspManager4_DeleteIP]: не удалось соедениться с сервером');
				#-----------------------------------------------------------------------------
				$Response = $Response['Body'];
				#-----------------------------------------------------------------------------
				$XML = String_XML_Parse($Response);
				#-----------------------------------------------------------------------------
				if(Is_Exception($XML))
					return ERROR | @Trigger_Error('[IspManager4_DeleteIP]: неверный ответ от сервера');
				#-----------------------------------------------------------------------------
				$XML = $XML->ToArray();
				#-----------------------------------------------------------------------------
				$Doc = $XML['doc'];
				#-----------------------------------------------------------------------------
				if(IsSet($Doc['error']))
					return new gException('IspManager4_DeleteIP',SPrintF('Не удалось изменить IP для email домена %s',$Domain['name']));
				#-----------------------------------------------------------------------------
			}
			#-----------------------------------------------------------------------------
		}
		#-----------------------------------------------------------------------------
	}
	#-----------------------------------------------------------------------------
	#-----------------------------------------------------------------------------
        # func=iplist.delete&elid=91.227.16.36
        $Request = Array(
                'authinfo'      => $authinfo,
                'func'          => 'iplist.delete',
                'out'           => 'xml',
                'elid'          => $ExtraIP,
                'sok'           => 'ok'
        );
        #Debug(var_export($Settings, true));
	#-----------------------------------------------------------------------------
	$Response = HTTP_Send('/manager/ispmgr',$HTTP,Array(),$Request);
	if(Is_Error($Response))
		return ERROR | @Trigger_Error('[IspManager4_DeleteIP]: не удалось соедениться с сервером');
	#-----------------------------------------------------------------------------
        $Response = Trim($Response['Body']);
        $XML = String_XML_Parse($Response);
        if(Is_Exception($XML))
                return new gException('WRONG_SERVER_ANSWER',$Response,$XML);
        #-----------------------------------------------------------------------------
        $XML = $XML->ToArray();
        #-----------------------------------------------------------------------------
        $Doc = $XML['doc'];
        #-----------------------------------------------------------------------------
        if(IsSet($Doc['error']))
                return new gException('DeleteIP_ERROR','Не удалось удалить IP у заказа хостинга');
        #-----------------------------------------------------------------------------
        #-----------------------------------------------------------------------------
	#-----------------------------------------------------------------------------
	return TRUE;
}

# added by lissyara 2014-01-16 in 10:46 MSK, for JBS-764
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
function IspManager4_Get_Disk_Usage($Settings){
	/******************************************************************************/
	$__args_types = Array('array');
	#-------------------------------------------------------------------------------
	$__args__ = Func_Get_Args(); Eval(FUNCTION_INIT);
	/******************************************************************************/
	$authinfo = SPrintF('%s:%s',$Settings['Login'],$Settings['Password']);
	#-------------------------------------------------------------------------------
	$Version = IspManager4_Check_Version($Settings);
	#-------------------------------------------------------------------------------
	Debug(SPrintF('[IspManager4_Get_Disk_Usage]: ISPmanager = %s',$Version));
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	$HTTP = IspManager4_Build_HTTP($Settings);
	#-------------------------------------------------------------------------------
	$Out = Array();
	#-------------------------------------------------------------------------------
	# перебираем функции
	foreach(Array('user','reseller') as $Func){
		#-------------------------------------------------------------------------------
		# в Lite нет реселлеров
		if($Version == 'Lite')
			if($Func == 'reseller')
				continue;
		#-------------------------------------------------------------------------------
		$Response = HTTP_Send('/manager/ispmgr',$HTTP,Array(),Array('authinfo'=>$authinfo,'out'=>'xml','func'=>$Func));
		if(Is_Error($Response))
			return new gException('NOT_CONNECTED_TO_SERVER','Не удалось соедениться с сервером');
		#-----------------------------------------------------------------------------
		$Response = Trim($Response['Body']);
		#-----------------------------------------------------------------------------
		$XML = String_XML_Parse($Response);
		if(Is_Exception($XML))
			return new gException('WRONG_SERVER_ANSWER',$Response,$XML);
		#-----------------------------------------------------------------------------
		$XML = $XML->ToArray('elem',Array('used','limit'));
		#-----------------------------------------------------------------------------
		$Users = $XML['doc'];
		#-----------------------------------------------------------------------------
		if(IsSet($Users['error']))
			return new gException('GET_USERS_ERROR',$Users['error']);
		#-----------------------------------------------------------------------------
		$Result = Array();
		#-----------------------------------------------------------------------------
		if(IsSet($Users) && Is_Array($Users)){
			#-----------------------------------------------------------------------------
			foreach($Users as $User){
				#---------------------------------------------------------------------------
				if(!IsSet($User['name']))
					continue;
				#-----------------------------------------------------------------------------
				if(!IsSet($User['disk'])){
					#-----------------------------------------------------------------------------
					Debug(SPrintF('[system/libs/IspManager4.php]: user (%s) does not have disk limit',$User['name']));
					$User['disk']['limit'] = -1;
					$User['disk']['used'] = -1;
					#-----------------------------------------------------------------------------
				}
				#-----------------------------------------------------------------------------
				$Out[$User['name']] = Array('Limit'=>$User['disk']['limit'],'Used'=>$User['disk']['used'],'Disabled'=>(IsSet($User['disabled'])?TRUE:FALSE));
				#-----------------------------------------------------------------------------
			}
			#-----------------------------------------------------------------------------
		}
	#-----------------------------------------------------------------------------
	}
	#-----------------------------------------------------------------------------
	#-----------------------------------------------------------------------------
	return $Out;
	#-----------------------------------------------------------------------------
	#-----------------------------------------------------------------------------
}


#-----------------------------------------------------------------------------
#-----------------------------------------------------------------------------
// added by lissyara, 2025-12-22 in 19:02 MSK
function IspManager4_Get_Account_Usage($Settings,$Users){
	/******************************************************************************/
	$__args_types = Array('array');
	#-------------------------------------------------------------------------------
	$__args__ = Func_Get_Args(); Eval(FUNCTION_INIT);
	/******************************************************************************/
	$authinfo = SPrintF('%s:%s',$Settings['Login'],$Settings['Password']);
	#-------------------------------------------------------------------------------
	$Version = IspManager4_Check_Version($Settings);
	#-------------------------------------------------------------------------------
	Debug(SPrintF('[IspManager4_Get_Account_Usage]: ISPmanager = %s',$Version));
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	//Debug(SPrintF('[IspManager4_Get_Account_Usage]: Users = %s',print_r($Users,true)));
	$HTTP = IspManager4_Build_HTTP($Settings);
	#-------------------------------------------------------------------------------
	$Out = Array();
	#-------------------------------------------------------------------------------
	# перебираем функции
	foreach(Array('user','reseller') as $Func){
		#-------------------------------------------------------------------------------
		# в Lite нет реселлеров
		if($Version == 'Lite')
			if($Func == 'reseller')
				continue;
		#-------------------------------------------------------------------------------
		$Response = HTTP_Send('/manager/ispmgr',$HTTP,Array(),Array('authinfo'=>$authinfo,'out'=>'json','func'=>$Func));
		if(Is_Error($Response))
			return new gException('NOT_CONNECTED_TO_SERVER','Не удалось соедениться с сервером');
		#-----------------------------------------------------------------------------
		$Response = Trim($Response['Body']);
		#-----------------------------------------------------------------------------
		$Json = Json_Decode($Response,TRUE);
		if(Is_Exception($Json))
			return new gException('WRONG_SERVER_ANSWER',$Response,$Json);
		#-----------------------------------------------------------------------------
		if(IsSet($Json['error']))
			return new gException('GET_USERS_ERROR',$Json['error']);
		#-----------------------------------------------------------------------------
		//Debug(SPrintF('[IspManager4_Get_Account_Usage]: $Json = %s',print_r($Json,true)));
		$Accounts = $Json['elem'];
		#-----------------------------------------------------------------------------
		if(IsSet($Accounts) && Is_Array($Accounts)){
			#-----------------------------------------------------------------------------
			foreach($Accounts as $Account){
				#---------------------------------------------------------------------------
				if(!IsSet($Account['name']))
					continue;
				#-----------------------------------------------------------------------------
				if(!IsSet($Account['disk'])){
					#-----------------------------------------------------------------------------
					Debug(SPrintF('[IspManager4_Get_Account_Usage]: user (%s) does not have disk limit',$Account['name']));
					$Account['disk']['limit'] = -1;
					$Account['disk']['used'] = -1;
					#-----------------------------------------------------------------------------
				}
				#-----------------------------------------------------------------------------
				if(In_Array($Account['name'],$Users))
					$Out[$Account['name']]['Last']['HDD'] = Array(
												'Limit'	=> (double)$Account['disk']['limit'],
												'Used'	=> (double)$Account['disk']['used']
												);
				#-----------------------------------------------------------------------------
			}
			#-----------------------------------------------------------------------------
		}
		#-----------------------------------------------------------------------------
	}
	#-----------------------------------------------------------------------------
	//Debug(SPrintF('[IspManager4_Get_Account_Usage]: Out = %s',print_r($Out,true)));
	#-----------------------------------------------------------------------------
	#-----------------------------------------------------------------------------
	return $Out;
	#-----------------------------------------------------------------------------
	#-----------------------------------------------------------------------------
}










#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------



#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
# Функции используемые для внутреннего употребления =)
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
function IspManager4_Check_Version($Settings){
	/******************************************************************************/
	$__args_types = Array('array','string');
	#-------------------------------------------------------------------------------
	$__args__ = Func_Get_Args(); Eval(FUNCTION_INIT);
	/******************************************************************************/
	$HTTP = IspManager4_Build_HTTP($Settings);
	#-------------------------------------------------------------------------------
	$authinfo = SPrintF('%s:%s',$Settings['Login'],$Settings['Password']);
	#-------------------------------------------------------------------------------
	# достаём информацию о лицензии
	$Response = HTTP_Send('/ispmgr',$HTTP,Array(),Array('authinfo'=>$authinfo,'out'=>'xml','func'=>'softinfo'));
	if(Is_Error($Response))
		return new gException('NOT_CONNECTED_TO_SERVER','Не удалось соедениться с сервером');
	#-------------------------------------------------------------------------------
	$Response = Trim($Response['Body']);
	#-------------------------------------------------------------------------------
	$XML = String_XML_Parse($Response);
	if(Is_Exception($XML))
		return new gException('WRONG_SERVER_ANSWER',$Response,$XML);
	#-------------------------------------------------------------------------------
	$XML = $XML->ToArray();
	#-------------------------------------------------------------------------------
	$Info = $XML['doc'];
	#-------------------------------------------------------------------------------
	if(IsSet($Info['error']))
		return new gException('GET_LICENSE_INFO_ERROR',$Info['error']);
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	return ((Preg_Match('/Lite/',$Info['mgrver']))?'Lite':'Pro');
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
function IspManager4_Build_HTTP($Settings){
	/******************************************************************************/
	$__args_types = Array('array');
	#-------------------------------------------------------------------------------
	$__args__ = Func_Get_Args(); Eval(FUNCTION_INIT);
	/******************************************************************************/
	$authinfo = SPrintF('%s:%s',$Settings['Login'],$Settings['Password']);
	#-------------------------------------------------------------------------------
	$HTTP = Array(
			'Address'	=> $Settings['Params']['IP'],
			'Port'		=> $Settings['Port'],
			'Host'		=> $Settings['Address'],
			'Protocol'	=> $Settings['Protocol'],
			'Hidden'	=> $authinfo,
			'IsLogging'	=> $Settings['Params']['IsLogging']
			);
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	return $HTTP;
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------






?>
