<?php
#-------------------------------------------------------------------------------
/** @author Alex Keda, for www.host-food.ru */
#-------------------------------------------------------------------------------
if(Is_Error(System_Load('libs/HTTP.php','classes/Net_IDNA.class.php')))
	return ERROR | @Trigger_Error(500);

#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
function IspManager5_Logon($Settings,$Params){
	/******************************************************************************/
	$__args_types = Array('array','array');
	#-------------------------------------------------------------------------------
	$__args__ = Func_Get_Args(); Eval(FUNCTION_INIT);
	/******************************************************************************/
	return Array('Url'=>$Settings['Params']['Url'],'Args'=>Array('lang'=>$Settings['Params']['Language'],'theme'=>($GLOBALS['IsMobile'])?'z-mobile':$Settings['Params']['Theme'],'checkcookie'=>'no','username'=>$Params['Login'],'password'=>$Params['Password'],'func'=>'auth'));
	#-------------------------------------------------------------------------------
}

#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
function IspManager5_Get_Domains($Settings){
	/****************************************************************************/
	$__args_types = Array('array');
	#-----------------------------------------------------------------------------
	$__args__ = Func_Get_Args(); Eval(FUNCTION_INIT);
	/****************************************************************************/
	$authinfo = SPrintF('%s:%s',$Settings['Login'],$Settings['Password']);
	#-----------------------------------------------------------------------------
	$HTTP = IspManager5_Build_HTTP($Settings);
	#-------------------------------------------------------------------------------
	# достаём список пользователей/реселлеров
	$Response = HTTP_Send('/ispmgr',$HTTP,Array(),Array('authinfo'=>$authinfo,'out'=>'xml','func'=>'user'));
	if(Is_Error($Response))
		return new gException('NOT_CONNECTED_TO_SERVER','Не удалось соедениться с сервером');
	#-------------------------------------------------------------------------------
	$Response = Trim($Response['Body']);
	#-----------------------------------------------------------------------------
	$XML = String_XML_Parse($Response);
	if(Is_Exception($XML))
		return new gException('WRONG_SERVER_ANSWER',$Response,$XML);
	#-----------------------------------------------------------------------------
	$XML = $XML->ToArray('elem');
	#-----------------------------------------------------------------------------
	$Elems = $XML['doc'];
	#-----------------------------------------------------------------------------
	if(IsSet($Elems['error']))
		return new gException('GET_USERS_ERROR',$Elems['error']);
	#-----------------------------------------------------------------------------
	$Resellers = Array();
	#-----------------------------------------------------------------------------
	if(Is_Array($Elems)){
		#-------------------------------------------------------------------------------
		foreach($Elems as $Elem)
			if(IsSet($Elem['owner']) && !In_Array($Elem['owner'],$Resellers))
				$Resellers[] = $Elem['owner'];
		#-------------------------------------------------------------------------------
	}
	#Debug(SPrintF('[system/libs/IspManager5.php]: Resellers = %s',print_r($Resellers,true)));
	#-----------------------------------------------------------------------------
	#-----------------------------------------------------------------------------
	$Owners = Array();
	#-----------------------------------------------------------------------------
	if(Is_Array($Elems)){
		#-------------------------------------------------------------------------------
		foreach($Elems as $Elem)
			if(IsSet($Elem['owner']) && In_Array($Elem['owner'],$Resellers))
				$Owners[$Elem['name']] = $Elem['owner'];
		#-------------------------------------------------------------------------------
	}
	#Debug(SPrintF('[system/libs/IspManager5.php]: Owners = %s',print_r($Owners,true)));
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	# строим выхлопной массив
	$Users = Array();
	#-------------------------------------------------------------------------------
	# достаём список www доменов
	$Response = HTTP_Send('/ispmgr',$HTTP,Array(),Array('authinfo'=>$authinfo,'out'=>'xml','func'=>'webdomain'));
	if(Is_Error($Response))
		return new gException('NOT_CONNECTED_TO_SERVER','Не удалось соедениться с сервером');
	#-----------------------------------------------------------------------------
	$Response = Trim($Response['Body']);
	#-----------------------------------------------------------------------------
	$XML = String_XML_Parse($Response);
	if(Is_Exception($XML))
		return new gException('WRONG_SERVER_ANSWER',$Response,$XML);
	#-----------------------------------------------------------------------------
	$XML = $XML->ToArray('elem');
	#-----------------------------------------------------------------------------
	$Domains = $XML['doc'];
	#-----------------------------------------------------------------------------
	if(!Is_Array($Domains))
		return new gException('WWW_DOMAINS_NOT_FOUND','WWW доменов не обнаружено');
	#-----------------------------------------------------------------------------
	if(IsSet($Domains['error']))
		return new gException('GET_WWW_DOMAINS_ERROR',$Domains['error']);
	#-----------------------------------------------------------------------------
	foreach($Domains as $Domain){
		#---------------------------------------------------------------------------
		if(!IsSet($Domain['owner']))
			continue;
		#---------------------------------------------------------------------------
		$Owner = $Domain['owner'];
		#---------------------------------------------------------------------------
		if(!IsSet($Users[$Owner]))
			$Users[$Owner] = Array();
		#---------------------------------------------------------------------------
		$Users[$Owner][] = $Domain['name'];
		#---------------------------------------------------------------------------
		# домены юзеров реселлеров
		if(IsSet($Owners[$Owner])){
			#---------------------------------------------------------------------------
			if(!IsSet($Users[$Owners[$Owner]]))
				$Users[$Owners[$Owner]] = Array();
			#---------------------------------------------------------------------------
			$Users[$Owners[$Owner]][] = $Domain['name'];
		}
		#---------------------------------------------------------------------------
	}
	#-----------------------------------------------------------------------------
	#-----------------------------------------------------------------------------
	# достаём DNS домены
	$Response = HTTP_Send('/ispmgr',$HTTP,Array(),Array('authinfo'=>$authinfo,'out'=>'xml','func'=>'domain'));
	if(Is_Error($Response))
		return new gException('NOT_CONNECTED_TO_SERVER','Не удалось соедениться с сервером');
	#-----------------------------------------------------------------------------
	$Response = Trim($Response['Body']);
	#-----------------------------------------------------------------------------
	$XML = String_XML_Parse($Response);
	if(Is_Exception($XML))
		return new gException('WRONG_SERVER_ANSWER',$Response,$XML);
	#-----------------------------------------------------------------------------
	$XML = $XML->ToArray('elem');
	#-----------------------------------------------------------------------------
	$Domains = $XML['doc'];
	#-----------------------------------------------------------------------------
	if(!Is_Array($Domains))
		return new gException('DNS_DOMAINS_NOT_FOUND','DNS доменов не обнаружено');
	#-----------------------------------------------------------------------------
	if(IsSet($Domains['error']))
		return new gException('GET_DNS_DOMAINS_ERROR',$Domains['error']);
	#-----------------------------------------------------------------------------
	foreach($Domains as $Domain){
		#---------------------------------------------------------------------------
		if(!IsSet($Domain['user']))
			continue;
		#---------------------------------------------------------------------------
		$Owner = $Domain['user'];
		#---------------------------------------------------------------------------
		if(!IsSet($Users[$Owner]))
			$Users[$Owner] = Array();
		#---------------------------------------------------------------------------
		if(!In_Array($Domain['displayname'],$Users[$Owner]))
			$Users[$Owner][] = $Domain['displayname'];
		#---------------------------------------------------------------------------
		# домены юзеров реселлеров
		if(IsSet($Owners[$Owner])){
			#---------------------------------------------------------------------------
			if(!IsSet($Users[$Owners[$Owner]]))
				$Users[$Owners[$Owner]] = Array();
			#---------------------------------------------------------------------------
			if(!In_Array($Domain['displayname'],$Users[$Owners[$Owner]]))
				$Users[$Owners[$Owner]][] = $Domain['displayname'];
		}
		#---------------------------------------------------------------------------
	}
	#-----------------------------------------------------------------------------
	#Debug(SPrintF('[system/libs/IspManager5.php]: UsersList = %s',print_r($Users,true)));
	#-----------------------------------------------------------------------------
	#-----------------------------------------------------------------------------
	# достаём Email домены
	$Response = HTTP_Send('/ispmgr',$HTTP,Array(),Array('authinfo'=>$authinfo,'out'=>'xml','func'=>'emaildomain'));
	if(Is_Error($Response))
		return new gException('NOT_CONNECTED_TO_SERVER','Не удалось соедениться с сервером');
	#-----------------------------------------------------------------------------
	$Response = Trim($Response['Body']);
	#-----------------------------------------------------------------------------
	$XML = String_XML_Parse($Response);
	if(Is_Exception($XML))
		return new gException('WRONG_SERVER_ANSWER',$Response,$XML);
	#-----------------------------------------------------------------------------
	$XML = $XML->ToArray('elem');
	#-----------------------------------------------------------------------------
	$Domains = $XML['doc'];
	#-----------------------------------------------------------------------------
	if(!Is_Array($Domains))
		return new gException('EMAIL_DOMAINS_NOT_FOUND','Email доменов не обнаружено');
	#-----------------------------------------------------------------------------
	if(IsSet($Domains['error']))
		return new gException('GET_EMAIL_DOMAINS_ERROR',$Domains['error']);
	#-----------------------------------------------------------------------------
	foreach($Domains as $Domain){
		#---------------------------------------------------------------------------
		if(!IsSet($Domain['owner']))
			continue;
		#---------------------------------------------------------------------------
		$Owner = $Domain['owner'];
		#---------------------------------------------------------------------------
		if(!IsSet($Users[$Owner]))
			$Users[$Owner] = Array();
		#---------------------------------------------------------------------------
		if(!In_Array($Domain['name'],$Users[$Owner]))
			$Users[$Owner][] = $Domain['name'];
		#---------------------------------------------------------------------------
		# домены юзеров реселлеров
		if(IsSet($Owners[$Owner])){
			#---------------------------------------------------------------------------
			if(!IsSet($Users[$Owners[$Owner]]))
				$Users[$Owners[$Owner]] = Array();
			#---------------------------------------------------------------------------
			if(!In_Array($Domain['name'],$Users[$Owners[$Owner]]))
				$Users[$Owners[$Owner]][] = $Domain['name'];
			#---------------------------------------------------------------------------
		}
		#---------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	#Debug(SPrintF('[system/libs/IspManager5.php]: UsersList = %s',print_r($Users,true)));
	return $Users;
	#-----------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
function IspManager5_Get_Users($Settings){
	/******************************************************************************/
	$__args_types = Array('array');
	#-------------------------------------------------------------------------------
	$__args__ = Func_Get_Args(); Eval(FUNCTION_INIT);
	/******************************************************************************/
	$Version = IspManager5_Check_Version($Settings);
	#-------------------------------------------------------------------------------
	Debug(SPrintF('[IspManager5_Get_Get_Users]: ISPmanager = %s',print_r($Version,true)));
	//Debug(SPrintF('[IspManager5_Get_Get_Users]: ISPmanager = %s',$Version));
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	$authinfo = SPrintF('%s:%s',$Settings['Login'],$Settings['Password']);
	#-------------------------------------------------------------------------------
	$HTTP = IspManager5_Build_HTTP($Settings);
	#-------------------------------------------------------------------------------
	$Response = HTTP_Send('/ispmgr',$HTTP,Array(),Array('authinfo'=>$authinfo,'out'=>'xml','func'=>'user'));
	if(Is_Error($Response))
		return new gException('NOT_CONNECTED_TO_SERVER','Не удалось соедениться с сервером');
	#-------------------------------------------------------------------------------
	$Response = Trim($Response['Body']);
	#-------------------------------------------------------------------------------
	$XML = String_XML_Parse($Response);
	#-------------------------------------------------------------------------------
	if(Is_Exception($XML))
		return new gException('WRONG_SERVER_ANSWER',$Response,$XML);
	#-------------------------------------------------------------------------------
	$XML = $XML->ToArray('elem');
	#-------------------------------------------------------------------------------
	$Users = $XML['doc'];
	#-------------------------------------------------------------------------------
	if(IsSet($Users['error']))
		return new gException('GET_USERS_ERROR',$Users['error']);
	#-------------------------------------------------------------------------------
	$Result = Array();
	#-------------------------------------------------------------------------------
	foreach($Users as $User){
		#-------------------------------------------------------------------------------
		if(!IsSet($User['name']))
			continue;
		#-------------------------------------------------------------------------------
		if(!IsSet($User['owner']))
			if($Version != 'Lite')
				continue;
		#-------------------------------------------------------------------------------
		if(!IsSet($User['owner']))
			$User['owner'] = $Settings['Login'];
		#-------------------------------------------------------------------------------
		# в Business, походу вводят какие-то зачатки групп - все админы обозначаются как "owner*admins"
		if($User['owner'] == $Settings['Login'] || $User['owner'] == 'owner*admins')
			$Result[] = $User['name'];
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	#Debug(SPrintF('[IspManager5_Get_Get_Users]: after func=user, Result = %s',print_r($Result,true)));
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	if($Version != 'Lite'){
		#-------------------------------------------------------------------------------
		$Response = HTTP_Send('/ispmgr',$HTTP,Array(),Array('authinfo'=>$authinfo,'out'=>'xml','func'=>'reseller'));
		if(Is_Error($Response))
			return new gException('NOT_CONNECTED_TO_SERVER','Не удалось соедениться с сервером');
		#-------------------------------------------------------------------------------
		$Response = Trim($Response['Body']);
		#-------------------------------------------------------------------------------
		$XML = String_XML_Parse($Response);
		#-------------------------------------------------------------------------------
		if(Is_Exception($XML))
			return new gException('WRONG_SERVER_ANSWER',$Response,$XML);
		#-------------------------------------------------------------------------------
		$XML = $XML->ToArray('elem');
		#-------------------------------------------------------------------------------
		$Users = $XML['doc'];
		#-------------------------------------------------------------------------------
		if(IsSet($Users['error']))
			return new gException('GET_USERS_ERROR',$Users['error']);
		#-------------------------------------------------------------------------------
		if(Is_Array($Users)){
			#-------------------------------------------------------------------------------
			foreach($Users as $User){
				#-------------------------------------------------------------------------------
				if(!IsSet($User['name']))
					continue;
				#-------------------------------------------------------------------------------
				$Result[] = $User['name'];
				#-------------------------------------------------------------------------------
			}
			#-------------------------------------------------------------------------------
		}
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	$Response = HTTP_Send('/ispmgr',$HTTP,Array(),Array('authinfo'=>$authinfo,'out'=>'xml','func'=>'admin'));
	#-------------------------------------------------------------------------------
	if(Is_Error($Response))
		return new gException('NOT_CONNECTED_TO_SERVER','Не удалось соедениться с сервером');
	#-------------------------------------------------------------------------------
	$Response = Trim($Response['Body']);
	#-------------------------------------------------------------------------------
	$XML = String_XML_Parse($Response);
	#-------------------------------------------------------------------------------
	if(Is_Exception($XML))
		return new gException('WRONG_SERVER_ANSWER',$Response,$XML);
	#-------------------------------------------------------------------------------
	$XML = $XML->ToArray('elem');
	#-------------------------------------------------------------------------------
	$Users = $XML['doc'];
	#-------------------------------------------------------------------------------
	if(IsSet($Users['error']))
		return new gException('GET_USERS_ERROR',$Users['error']);
	#-------------------------------------------------------------------------------
	if(Is_Array($Users)){
		#-------------------------------------------------------------------------------
		foreach($Users as $User){
			#-------------------------------------------------------------------------------
			if(!IsSet($User['name']))
				continue;
			#-------------------------------------------------------------------------------
			if($User['name'] != $Settings['Login'])
			#-------------------------------------------------------------------------------
			$Result[] = $User['name'];
			#-------------------------------------------------------------------------------
		}
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	#Debug(SPrintF('[IspManager5_Get_Get_Users]: Result = %s',print_r($Result,true)));
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	return $Result;
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
}

#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
function IspManager5_Create($Settings,$Login,$Password,$Domain,$IP,$HostingScheme,$Email,$PersonID = 'Default',$Person = Array()){
	/******************************************************************************/
	$__args_types = Array('array','string','string','string','string','array','string','string','array');
	#-------------------------------------------------------------------------------
	$__args__ = Func_Get_Args(); Eval(FUNCTION_INIT);
	/******************************************************************************/
	$authinfo = SPrintF('%s:%s',$Settings['Login'],$Settings['Password']);
	#-------------------------------------------------------------------------------
	$HTTP = IspManager5_Build_HTTP($Settings);
	#-------------------------------------------------------------------------------
	$Version = IspManager5_Check_Version($Settings);
	#-------------------------------------------------------------------------------
	$IsReselling = $HostingScheme['IsReselling'];
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	# JBS-543, проверяем наличие такого юзера
	$Request = Array(
			'authinfo'      => $authinfo,
			'func'          => $IsReselling?'reseller.edit':'user.edit',
			'out'           => 'xml',
			'elid'          => $Login
			);
	#-------------------------------------------------------------------------------
	$Response = HTTP_Send('/ispmgr',$HTTP,Array(),$Request);
	if(Is_Error($Response))
		return new gException('NOT_CONNECTED_TO_SERVER','Не удалось соедениться с сервером');
	#-------------------------------------------------------------------------------
	$Response = Trim($Response['Body']);
	#-------------------------------------------------------------------------------
	$XML = String_XML_Parse($Response);
	#-------------------------------------------------------------------------------
	if(Is_Exception($XML))
		return new gException('WRONG_SERVER_ANSWER',$Response,$XML);
	#-------------------------------------------------------------------------------
	$XML = $XML->ToArray();
	#-------------------------------------------------------------------------------
	$Doc = $XML['doc'];
	#-------------------------------------------------------------------------------
	if(!IsSet($Doc['error']))
		if(!IsSet($Doc['tparams']['func']))
			return TRUE;
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	$IDNA = new Net_IDNA();
	#-------------------------------------------------------------------------------
	$Domain = $IDNA->encode($Domain);
	#-------------------------------------------------------------------------------
	$Request = Array(
			'authinfo'			=> $authinfo,
			'out'				=> 'xml',	# Формат вывода
			'func'				=> ($IsReselling)?'reseller.edit':'user.add.finish',			# Целевая функция
			'sok'				=> 'ok',	# Значение параметра должно быть равно "ok"
			'name'				=> $Login,	# Имя пользователя (реселлера)
			'fullname'			=> $Email,	# полное имя
			'passwd'			=> $Password,	# Пароль
			'confirm'			=> $Password,	# Подтверждение
			'ip'				=> $IP,		# IP-адрес
			'email'				=> $Email
			);
	#-------------------------------------------------------------------------------
	// считываем XML и составляем запрос
	$Fields = System_XML(SPrintF('config/Schemes.%s.xml',$HostingScheme['SchemeParams']['SystemID']));
	if(Is_Error($Fields))
		return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------------
	foreach(Array_Keys($Fields) as $Key){
		#-------------------------------------------------------------------------------
		$Field = $Fields[$Key];
		#-------------------------------------------------------------------------------
		$Value = IsSet($HostingScheme['SchemeParams'][$Key])?$HostingScheme['SchemeParams'][$Key]:$Field['Value'];
		#-------------------------------------------------------------------------------
		$Request[$Key] = $Value;
		#-------------------------------------------------------------------------------
		if(IsSet($Field['Min']))
			$Request[$Key] = IntVal($Value);
		#-------------------------------------------------------------------------------
		if(IsSet($Field['Type']) && $Field['Type'] == 'CheckBox')
			$Request[$Key] = ($Request[$Key])?'on':'off';
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	if($HostingScheme['SchemeParams']['limit_webdomains'])
		$Request['domain'] = $Domain; # Домен
	#-------------------------------------------------------------------------------
	// персональный чопик
	$Request['mailrate']			= $HostingScheme['SchemeParams']['limit_mailrate'];
	#-------------------------------------------------------------------------------
	if($IsReselling){
		#-------------------------------------------------------------------------------
		$Request['limit_users']		= $HostingScheme['SchemeParams']['limit_users']; # Пользователи
		# TODO сделать нормальное лимитирование через интерфейс. наверное, не раньше перевода тарифов на xml
		$Request['limit_ipv4addrs']	= 0;				# адреса, v4
		$Request['limit_ipv6addrs']	= 0;				# адреса, v6
		#-------------------------------------------------------------------------------
	}
  	#-------------------------------------------------------------------------------
	$Response = HTTP_Send('/ispmgr',$HTTP,Array(),$Request);
	if(Is_Error($Response))
		return ERROR | @Trigger_Error('[IspManager5_Create]: не удалось соедениться с сервером');
	#-------------------------------------------------------------------------------
	$Response = Trim($Response['Body']);
	#-------------------------------------------------------------------------------
	$XML = String_XML_Parse($Response);
	#-------------------------------------------------------------------------------
	if(Is_Exception($XML))
		return new gException('WRONG_SERVER_ANSWER',$Response,$XML);
	#-------------------------------------------------------------------------------
	$XML = $XML->ToArray();
	#-------------------------------------------------------------------------------
	$Doc = $XML['doc'];
	#-------------------------------------------------------------------------------
	if(IsSet($Doc['error']) || !IsSet($Doc['ok']))
		return new gException('ACCOUNT_CREATE_ERROR','Не удалось создать заказ хостинга');
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	# TODO надо и для Business как-то рестартавать веб-сервер ноды
	if(!$Settings['Params']['NoRestartCreate'] && $Version == 'Lite')
		IspManager5_Service_Restart($Settings,'httpd');
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	return TRUE;
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
}

#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
function IspManager5_Active($Settings,$Login,$IsReseller = FALSE){
	/******************************************************************************/
	$__args_types = Array('array','string','boolean');
	#-------------------------------------------------------------------------------
	$__args__ = Func_Get_Args(); Eval(FUNCTION_INIT);
	/******************************************************************************/
	$authinfo = SPrintF('%s:%s',$Settings['Login'],$Settings['Password']);
	#-------------------------------------------------------------------------------
	$HTTP = IspManager5_Build_HTTP($Settings);
	#-------------------------------------------------------------------------------
	$Version = IspManager5_Check_Version($Settings);
	#-------------------------------------------------------------------------------
	$Response = HTTP_Send('/ispmgr',$HTTP,Array(),Array('authinfo'=>$authinfo,'out'=>'xml','func'=>($IsReseller)?'reseller.resume':'user.resume','elid'=>$Login));
	if(Is_Error($Response))
		return ERROR | @Trigger_Error('[IspManager5_Activate]: не удалось соедениться с сервером');
	#-------------------------------------------------------------------------------
	$Response = Trim($Response['Body']);
	#-------------------------------------------------------------------------------
	$XML = String_XML_Parse($Response);
	#-------------------------------------------------------------------------------
	if(Is_Exception($XML))
		return new gException('WRONG_SERVER_ANSWER',$Response,$XML);
	#-------------------------------------------------------------------------------
	$XML = $XML->ToArray();
	#-------------------------------------------------------------------------------
	$Doc = $XML['doc'];
	#-------------------------------------------------------------------------------
	if(IsSet($Doc['error']))
		return new gException('ACCOUNT_ACTIVATE_ERROR','Не удалось активировать заказ хостинга');
	#-------------------------------------------------------------------------------
	# TODO надо и для Business как-то рестартавать веб-сервер ноды
	if(!$Settings['Params']['NoRestartActive'] && $Version == 'Lite')
		IspManager5_Service_Restart($Settings,'httpd');
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	return TRUE;
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
}

#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
function IspManager5_Suspend($Settings,$Login,$IsReseller = FALSE){
	/******************************************************************************/
	$__args_types = Array('array','string','boolean');
	#-------------------------------------------------------------------------------
	$__args__ = Func_Get_Args(); Eval(FUNCTION_INIT);
	/******************************************************************************/
	$authinfo = SPrintF('%s:%s',$Settings['Login'],$Settings['Password']);
	#-------------------------------------------------------------------------------
	$HTTP = IspManager5_Build_HTTP($Settings);
	#-------------------------------------------------------------------------------
	$Version = IspManager5_Check_Version($Settings);
	#-------------------------------------------------------------------------------
	$Response = HTTP_Send('/ispmgr',$HTTP,Array(),Array('authinfo'=>$authinfo,'out'=>'xml','func'=>($IsReseller)?'reseller.suspend':'user.suspend','elid'=>$Login));
	if(Is_Error($Response))
		return ERROR | @Trigger_Error('[IspManager5_Suspend]: не удалось соедениться с сервером');
	#-------------------------------------------------------------------------------
	$Response = Trim($Response['Body']);
	#-------------------------------------------------------------------------------
	$XML = String_XML_Parse($Response);
	if(Is_Exception($XML))
		return new gException('WRONG_SERVER_ANSWER',$Response,$XML);
	#-------------------------------------------------------------------------------
	$XML = $XML->ToArray();
	#-------------------------------------------------------------------------------
	$Doc = $XML['doc'];
	#-------------------------------------------------------------------------------
	if(IsSet($Doc['error']))
		return new gException('ACCOUNT_SUSPEND_ERROR','Не удалось заблокировать заказ хостинга');
	#-------------------------------------------------------------------------------
	# TODO надо и для Business как-то рестартавать веб-сервер ноды
	if(!$Settings['Params']['NoRestartSuspend'] && $Version == 'Lite')
		IspManager5_Service_Restart($Settings,'httpd');
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	return TRUE;
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
}

#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
function IspManager5_Delete($Settings,$Login,$IsReseller = FALSE){
	/******************************************************************************/
	$__args_types = Array('array','string','boolean');
	#-------------------------------------------------------------------------------
	$__args__ = Func_Get_Args(); Eval(FUNCTION_INIT);
	/******************************************************************************/
	$authinfo = SPrintF('%s:%s',$Settings['Login'],$Settings['Password']);
	#-------------------------------------------------------------------------------
	$HTTP = IspManager5_Build_HTTP($Settings);
	#-------------------------------------------------------------------------------
	$Version = IspManager5_Check_Version($Settings);
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	# JBS-543, проверяем наличие такого юзера
	$Request = Array(
			'authinfo'      => $authinfo,
			'func'          => $IsReseller?'reseller.edit':'user.edit',
			'out'           => 'xml',
			'elid'          => $Login
			);
	#-------------------------------------------------------------------------------
	$Response = HTTP_Send('/ispmgr',$HTTP,Array(),$Request);
	if(Is_Error($Response))
		return new gException('NOT_CONNECTED_TO_SERVER','Не удалось соедениться с сервером');
	#-------------------------------------------------------------------------------
	$Response = Trim($Response['Body']);
	#-------------------------------------------------------------------------------
	$XML = String_XML_Parse($Response);
	#-------------------------------------------------------------------------------
	if(Is_Exception($XML))
		return new gException('WRONG_SERVER_ANSWER',$Response,$XML);
	#-------------------------------------------------------------------------------
	$XML = $XML->ToArray();
	#-------------------------------------------------------------------------------
	$Doc = $XML['doc'];
	#-------------------------------------------------------------------------------
	if(IsSet($Doc['error']))
		return TRUE;
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	# проверка что это реселлер, если так - надо дропать его юзеров
	if($IsReseller){
		#-------------------------------------------------------------------------------
		# достаём список всех юзеров
		$Request = Array(
				'authinfo'      => $authinfo,
				'func'          => 'user',
				'out'           => 'xml',
				'su'            => $Login
				);
		#-----------------------------------------------------------------------------
		$Response = HTTP_Send('/ispmgr',$HTTP,Array(),$Request);
		if(Is_Error($Response))
			return new gException('NOT_CONNECTED_TO_SERVER','Не удалось соедениться с сервером');
		#-----------------------------------------------------------------------------
		$Response = Trim($Response['Body']);
		#-------------------------------------------------------------------------------
		$XML = String_XML_Parse($Response);
		if(Is_Exception($XML))
			return new gException('WRONG_SERVER_ANSWER',$Response,$XML);
		#-----------------------------------------------------------------------------
		$XML = $XML->ToArray('elem');
		#-------------------------------------------------------------------------------
		$Users = $XML['doc'];
		#-------------------------------------------------------------------------------
		if(Is_Array($Users)){
			#-----------------------------------------------------------------------------
			# дропаем юзеров
			foreach($Users as $User){
				#-----------------------------------------------------------------------------
				if(!IsSet($User['name']))
					continue;
				#-----------------------------------------------------------------------------
				$Request = Array(
						'authinfo'      => $authinfo,
						'func'		=> 'user.delete',
						'out'		=> 'xml',
						'su'		=> $Login,
						'elid'		=> $User['name']
						);
				#-----------------------------------------------------------------------------
				$Response = HTTP_Send('/ispmgr',$HTTP,Array(),$Request);
				if(Is_Error($Response))
					return ERROR | @Trigger_Error('[IspManager5_Delete]: не удалось соедениться с сервером');
				# я так думаю, неважно чё он там ответил, если ответил...
				#-----------------------------------------------------------------------------
			}
			#-----------------------------------------------------------------------------
		}
		#-----------------------------------------------------------------------------
 	}
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	$Response = HTTP_Send('/ispmgr',$HTTP,Array(),Array('authinfo'=>$authinfo,'out'=>'xml','func'=>($IsReseller)?'reseller.delete':'user.delete','elid'=>$Login));
	if(Is_Error($Response))
		return ERROR | @Trigger_Error('[IspManager5_Delete]: не удалось соедениться с сервером');
	#-------------------------------------------------------------------------------
	$Response = Trim($Response['Body']);
	#-------------------------------------------------------------------------------
	$XML = String_XML_Parse($Response);
	if(Is_Exception($XML))
		return new gException('WRONG_SERVER_ANSWER',$Response,$XML);
	#-------------------------------------------------------------------------------
	$XML = $XML->ToArray();
	#-------------------------------------------------------------------------------
	$Doc = $XML['doc'];
	#-------------------------------------------------------------------------------
	if(IsSet($Doc['error']) || !IsSet($Doc['ok']))
		return new gException('ACCOUNT_DELETE_ERROR','Не удалось удалить заказ хостинга');
	#-------------------------------------------------------------------------------
	# TODO надо и для Business как-то рестартавать веб-сервер ноды
	if(!$Settings['Params']['NoRestartDelete'] && $Version == 'Lite')
		IspManager5_Service_Restart($Settings,'httpd');
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	return TRUE;
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
function IspManager5_Scheme_Change($Settings,$Login,$HostingScheme){
	/******************************************************************************/
	$__args_types = Array('array','string','array');
	#-------------------------------------------------------------------------------
	$__args__ = Func_Get_Args(); Eval(FUNCTION_INIT);
	/******************************************************************************/
	$authinfo = SPrintF('%s:%s',$Settings['Login'],$Settings['Password']);
	#-------------------------------------------------------------------------------
	$HTTP = IspManager5_Build_HTTP($Settings);
	#-------------------------------------------------------------------------------
	$Version = IspManager5_Check_Version($Settings);
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	$IsReselling = $HostingScheme['IsReselling'];
	#-------------------------------------------------------------------------------
	$Request = Array(
			'authinfo'			=> $authinfo,
			'out'				=> 'xml', # Формат вывода
			'func'				=> ($IsReselling)?'reseller.edit':'user.edit', # Целевая функция
			'elid'				=> $Login, # Уникальный идентификатор
			'sok'				=> 'ok', # Значение параметра должно быть равно "yes"
			'name'				=> $Login, # Имя пользователя (реселлера)
			'ip'				=> $Settings['Params']['IP'], # IP-адрес
			);
	#-------------------------------------------------------------------------------
	$Fields = System_XML(SPrintF('config/Schemes.%s.xml',$HostingScheme['SchemeParams']['SystemID']));
	if(Is_Error($Fields))
		return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------------
	foreach(Array_Keys($Fields) as $Key){
		#-------------------------------------------------------------------------------
		$Field = $Fields[$Key];
		#-------------------------------------------------------------------------------
		if(!$Field['IsSchemeChange'])
			continue;
		#-------------------------------------------------------------------------------
		$Value = IsSet($HostingScheme['SchemeParams'][$Key])?$HostingScheme['SchemeParams'][$Key]:$Field['Value'];
		#-------------------------------------------------------------------------------
		$Request[$Key] = $Value;
		#-------------------------------------------------------------------------------
		if(IsSet($Field['Min']))
			$Request[$Key] = IntVal($Value);
		#-------------------------------------------------------------------------------
		if(IsSet($Field['Type']) && $Field['Type'] == 'CheckBox')
			$Request[$Key] = ($Request[$Key])?'on':'off';
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	$Request['limit_webdomains_enabled']	= ($HostingScheme['SchemeParams']['limit_webdomains']?'on':'off');
	#-------------------------------------------------------------------------------
	// персональный чопик
	$Request['mailrate']			= $HostingScheme['SchemeParams']['limit_mailrate'];
	#-------------------------------------------------------------------------------
	if($IsReselling){
		#-------------------------------------------------------------------------------
		$Request['limit_users']		= $HostingScheme['SchemeParams']['limit_users'];
		$Request['limit_ipv4addrs']	= 0;
		$Request['limit_ipv6addrs']	= 0;
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	$Response = HTTP_Send('/ispmgr',$HTTP,Array(),$Request);
	#-------------------------------------------------------------------------------
	if(Is_Error($Response))
		return ERROR | @Trigger_Error('[IspManager5_Scheme_Change]: не удалось соедениться с сервером');
	#-------------------------------------------------------------------------------
	$Response = Trim($Response['Body']);
	#-------------------------------------------------------------------------------
	$XML = String_XML_Parse($Response);
	#-------------------------------------------------------------------------------
	if(Is_Exception($XML))
		return new gException('WRONG_SERVER_ANSWER',$Response,$XML);
	#-------------------------------------------------------------------------------
	$XML = $XML->ToArray();
	#-------------------------------------------------------------------------------
	$Doc = $XML['doc'];
	#-------------------------------------------------------------------------------
	if(IsSet($Doc['error']))
		//return new gException('SCHEME_CHANGE_ERROR','Не удалось изменить тарифный план для заказа хостинга');
		return new gException('SCHEME_CHANGE_ERROR','Используемые ресурсы превышают лимиты нового тарифного плана');
	#-------------------------------------------------------------------------------
	if(!$Settings['Params']['NoRestartSchemeChange'] && $Version == 'Lite')
		IspManager5_Service_Restart($Settings,'httpd');
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	return TRUE;
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
function IspManager5_Password_Change($Settings,$Login,$Password,$Params){
	/******************************************************************************/
	$__args_types = Array('array','string','string','array');
	#-------------------------------------------------------------------------------
	$__args__ = Func_Get_Args(); Eval(FUNCTION_INIT);
	/******************************************************************************/
	$authinfo = SPrintF('%s:%s',$Settings['Login'],$Settings['Password']);
	#-------------------------------------------------------------------------------
	$HTTP = IspManager5_Build_HTTP($Settings);
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	$Request = Array('authinfo'=>$authinfo,'out'=>'xml','func'=>'usrparam','su'=>$Login,'sok'=>'ok','atype'=>'atany','passwd'=>$Password,'confirm'=>$Password,'email'=>$Params['Email'],'experience'=>'expert','setgeoip'=>'off','secureip'=>'off','vk_status'=>'off','fb_status'=>'off','gl_status'=>'off','disable_totp'=>'on','clicked_button'=>'ok');
	#-------------------------------------------------------------------------------
	$Response = HTTP_Send('/ispmgr',$HTTP,Array(),$Request);
	if(Is_Error($Response))
		return ERROR | @Trigger_Error('[IspManager5_Password_Change]: не удалось соедениться с сервером');
	#-------------------------------------------------------------------------------
	$Response = Trim($Response['Body']);
	#-------------------------------------------------------------------------------
	$XML = String_XML_Parse($Response);
	if(Is_Exception($XML))
		return ERROR | @Trigger_Error('[IspManager5_Password_Change]: неверный ответ от сервера');
	#-------------------------------------------------------------------------------
	$XML = $XML->ToArray();
	#-------------------------------------------------------------------------------
	$Doc = $XML['doc'];
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	// JBS-1453 меняем пасс для ftp юзера /
	$Request = Array('authinfo'=>$authinfo,'out'=>'xml','func'=>'ftp.user.edit','home'=>'/','su'=>$Login,'elid'=>$Login,'sok'=>'ok','passwd'=>$Password,'confirm'=>$Password);
	#-------------------------------------------------------------------------------
	$Response = HTTP_Send('/ispmgr',$HTTP,Array(),$Request);
	if(Is_Error($Response))
		return ERROR | @Trigger_Error('[IspManager5_Password_Change]: не удалось соедениться с сервером');
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	//if(IsSet($Doc['error']))
	//	return new gException('PASSWORD_CHANGE_ERROR','Не удалось изменить пароль для заказа хостинга, возможно, он слишком простой');
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	return TRUE;
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
}

#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
function IspManager5_Get_Email_Boxes($Settings){
	/******************************************************************************/
	$__args_types = Array('array');
	#-------------------------------------------------------------------------------
	$__args__ = Func_Get_Args(); Eval(FUNCTION_INIT);
	/******************************************************************************/
	$authinfo = SPrintF('%s:%s',$Settings['Login'],$Settings['Password']);
	#-------------------------------------------------------------------------------
	$HTTP = IspManager5_Build_HTTP($Settings);
	#-------------------------------------------------------------------------------
	$Response = HTTP_Send('/ispmgr',$HTTP,Array(),Array('authinfo'=>$authinfo,'out'=>'xml','func'=>'emaildomain'));
	if(Is_Error($Response))
		return new gException('NOT_CONNECTED_TO_SERVER','Не удалось соедениться с сервером');
	#-------------------------------------------------------------------------------
	$Response = Trim($Response['Body']);
	#-------------------------------------------------------------------------------
	$XML = String_XML_Parse($Response);
	if(Is_Exception($XML))
		return new gException('WRONG_SERVER_ANSWER',$Response,$XML);
	#-------------------------------------------------------------------------------
	$XML = $XML->ToArray('elem');
	#-------------------------------------------------------------------------------
	$Result = $XML['doc'];
	#-------------------------------------------------------------------------------
	if(!Is_Array($Result))
		return new gException('BOXES_NOT_FOUND','Почтовых доменов не обнаружено');
	#-------------------------------------------------------------------------------
	if(IsSet($Result['error']))
		return ERROR | @Trigger_Error('[IspManager5_Get_Email_Boxes]: не удалось получить список почтовых ящиков');
	#-------------------------------------------------------------------------------
	$Domains = Array();
	#-------------------------------------------------------------------------------
	foreach($Result as $Domain){
		#-------------------------------------------------------------------------------
		if(!Is_Array($Domain))
			continue;
		#-------------------------------------------------------------------------------
		if(!IsSet($Domain['owner']))
			continue;
		#-------------------------------------------------------------------------------
		if($Domain['active'] != 'on')
			continue;
		#-------------------------------------------------------------------------------
		$Owner = $Domain['owner'];
		#-------------------------------------------------------------------------------
		if(!IsSet($Users[$Owner]))
			$Users[$Owner] = Array();
		#-------------------------------------------------------------------------------
		$Domains[$Domain['name']] = Array('Owner'=>$Owner,'Boxes'=>Array());
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	$Response = HTTP_Send('/ispmgr',$HTTP,Array(),Array('authinfo'=>$authinfo,'out'=>'xml','func'=>'email'));
	if(Is_Error($Response))
		return new gException('NOT_CONNECTED_TO_SERVER','Не удалось соедениться с сервером');
	#-------------------------------------------------------------------------------
	$Response = $Response['Body'];
	#-------------------------------------------------------------------------------
	$XML = String_XML_Parse($Response);
	if(Is_Exception($XML))
		return new gException('WRONG_SERVER_ANSWER','Неверный ответ от сервера');
	#-------------------------------------------------------------------------------
	$XML = $XML->ToArray('elem',Array('used','limit'));
	#-------------------------------------------------------------------------------
	$Result = $XML['doc'];
	#-------------------------------------------------------------------------------
	if(!Is_Array($Result))
		return new gException('BOXES_NOT_FOUND','Почтовых ящиков не обнаружено');
	#-------------------------------------------------------------------------------
	if(IsSet($Result['error']))
		return ERROR | @Trigger_Error('[IspManager5_Get_Email_Boxes]: не удалось получить список почтовых ящиков');
	#-------------------------------------------------------------------------------
	foreach($Result as $Box){
		#-------------------------------------------------------------------------------
		if(!Is_Array($Box))
			continue;
		#-------------------------------------------------------------------------------
		if(!IsSet($Box['name']))
			continue;
		#-------------------------------------------------------------------------------
		$Name = Explode('@',$Box['name']);
		#-------------------------------------------------------------------------------
		if(!IsSet($Domains[$Domain = Next($Name)]))
			continue;
		#-------------------------------------------------------------------------------
		$Domains[$Domain]['Boxes'][$Box['name']] = Array($Box['size_used'],$Box['size_total']);
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	$Users = Array();
	#-------------------------------------------------------------------------------
	foreach($Domains as $DomainID=>$Domain){
		#-------------------------------------------------------------------------------
		$Owner = $Domain['Owner'];
		#-------------------------------------------------------------------------------
		if(!IsSet($Users[$Owner]))
			$Users[$Owner] = Array();
		#-------------------------------------------------------------------------------
		foreach($Domain['Boxes'] as $Email=>$Box)
			$Users[$Owner][$Email] = $Box;
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	return $Users;
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
}

#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
# added by lissyara 2015-05-24 in 14:05 MSK
function IspManager5_AddIP($Settings,$Login,$ID,$Domain,$IP,$AddressType){
        /****************************************************************************/
        $__args_types = Array('array','string','string','string','string','string');
        $__args__ = Func_Get_Args(); Eval(FUNCTION_INIT);
        /****************************************************************************/
	$Version = IspManager5_Check_Version($Settings);
	#-------------------------------------------------------------------------------
	Debug(SPrintF('[IspManager5_AddIP]: ISPmanager = %s',$Version));
	#-------------------------------------------------------------------------------
	if($Version == 'Lite')
		return new gException('LITE_NOT_SUPPORT_MANAGE_IP_ADDRESS_LIST','Версия ISPmanager Lite 5 не подерживает управление IP адресами');
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
        $authinfo = SPrintF('%s:%s',$Settings['Login'],$Settings['Password']);
        #-----------------------------------------------------------------------------
        $HTTP = IspManager5_Build_HTTP($Settings);
        #-----------------------------------------------------------------------------
        # TODO у реселлеров надо поменять параметр ответственный за количество IP адресов.
	# по дефолту у них ноль, а значит они не могут юзать выделеный IP адрес

	$Request = Array(
			'authinfo'	=> $authinfo,
			'out'		=> 'xml',
			'func'		=> 'ipaddr.edit',
			'comment'	=> '',
			'iprole'	=> 'assigned',
			'iptype'	=> StrToLower($AddressType),
			'name'		=> '',
			'node'		=> '*',
			'owner'		=> $Login,
			'sok'		=> 'ok',
			# в оригинале, передаётся ещё этот параметр, но у меня и без него работает
			#'subnet'	=> '91.227.16.0/24'
			);
	$Response = HTTP_Send('/ispmgr',$HTTP,Array(),$Request);
	if(Is_Error($Response))
		return new gException('NOT_CONNECTED_TO_SERVER','Не удалось соедениться с сервером');
	#-----------------------------------------------------------------------------
	$Response = Trim($Response['Body']);
	#-----------------------------------------------------------------------------
	$XML = String_XML_Parse($Response);
	if(Is_Exception($XML))
		return new gException('WRONG_SERVER_ANSWER',$Response,$XML);
	#-----------------------------------------------------------------------------
	$XML = $XML->ToArray();
	#-----------------------------------------------------------------------------
	$Doc = $XML['doc'];
	#-----------------------------------------------------------------------------
	if(IsSet($Doc['error']))
		return new gException('IP_ADD_CREATE_ERROR','Не удалось добавить IP адрес');
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	return Array('ID'=>$ID,'IP'=>$Doc['id']);
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
}

# added by lissyara 2051-05-24 in 14:17 MSK
#-------------------------------------------------------------------------------
function IspManager5_DeleteIP($Settings,$ExtraIP){
	/******************************************************************************/
	$__args_types = Array('array','string');
	$__args__ = Func_Get_Args(); Eval(FUNCTION_INIT);
	/******************************************************************************/
	$Version = IspManager5_Check_Version($Settings);
	#-------------------------------------------------------------------------------
	Debug(SPrintF('[IspManager5_AddIP]: ISPmanager = %s',$Version));
	#-------------------------------------------------------------------------------
	if($Version == 'Lite')
		return new gException('LITE_NOT_SUPPORT_MANAGE_IP_ADDRESS_LIST','Версия ISPmanager Lite 5 не подерживает управление IP адресами');
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	$authinfo = SPrintF('%s:%s',$Settings['Login'],$Settings['Password']);
	#-------------------------------------------------------------------------------
	$HTTP = IspManager5_Build_HTTP($Settings);
	#-------------------------------------------------------------------------------
	# 1. освобождаем IP адрес - благо в 5 панели появился инструментарий для этого
	# 2. удаляем IP
	$Request = Array(
			'authinfo'	=> $authinfo,
			'out'		=> 'xml',
			'func'          => 'ipaddr.free',
			'elid'		=> $ExtraIP,
			'sok'		=> 'ok'
			);
	$Response = HTTP_Send('/ispmgr',$HTTP,Array(),$Request);
	if(Is_Error($Response))
		return ERROR | @Trigger_Error('[IspManager5_DeleteIP]: не удалось соедениться с сервером');
	#-------------------------------------------------------------------------------
	$Response = Trim($Response['Body']);
	#-------------------------------------------------------------------------------
	$XML = String_XML_Parse($Response);
	if(Is_Exception($XML))
		return new gException('WRONG_SERVER_ANSWER',$Response,$XML);
	#-------------------------------------------------------------------------------
	$XML = $XML->ToArray();
	#-------------------------------------------------------------------------------
	$Doc = $XML['doc'];
	#-------------------------------------------------------------------------------
	if(IsSet($Doc['error']))
		return new gException('FREE_IP_ERROR','Не удалось освободить IP адрес');
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	$Request = Array(
			'authinfo'	=> $authinfo,
			'func'		=> 'ipaddr.delete',
			'out'		=> 'xml',
			'elid'		=> $ExtraIP,
			'sok'		=> 'ok'
                );
	$Response = HTTP_Send('/ispmgr',$HTTP,Array(),$Request);
	if(Is_Error($Response))
		return new gException('NOT_CONNECTED_TO_SERVER','Не удалось соедениться с сервером');
	#-------------------------------------------------------------------------------
	$XML = String_XML_Parse($Response['Body']);
	if(Is_Exception($XML))
		return new gException('WRONG_SERVER_ANSWER',$Response,$XML);
	#-------------------------------------------------------------------------------
	$XML = $XML->ToArray();
	#-------------------------------------------------------------------------------
	$Doc = $XML['doc'];
	#-------------------------------------------------------------------------------
	if(IsSet($Doc['error']))
		return new gException('DELETE_IP_ERROR','Не удалось удалить IP адрес');
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	return TRUE;
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
}

# added by lissyara 2014-01-16 in 10:46 MSK, for JBS-764
#-----------------------------------------------------------------------------
#-------------------------------------------------------------------------------
function IspManager5_Get_Disk_Usage($Settings){
	/****************************************************************************/
	$__args_types = Array('array');
	#-----------------------------------------------------------------------------
	$__args__ = Func_Get_Args(); Eval(FUNCTION_INIT);
	/****************************************************************************/
	$authinfo = SPrintF('%s:%s',$Settings['Login'],$Settings['Password']);
	#-----------------------------------------------------------------------------
	$HTTP = IspManager5_Build_HTTP($Settings);
	#-----------------------------------------------------------------------------
	$Out = Array();
	#-----------------------------------------------------------------------------
	# перебираем функции
	foreach(Array('user') as $Func){
		#-----------------------------------------------------------------------------
		$Response = HTTP_Send('/ispmgr',$HTTP,Array(),Array('authinfo'=>$authinfo,'out'=>'xml','func'=>$Func));
		if(Is_Error($Response))
			return new gException('NOT_CONNECTED_TO_SERVER','Не удалось соедениться с сервером');
		#-----------------------------------------------------------------------------
		$Response = Trim($Response['Body']);
		#-----------------------------------------------------------------------------
		$XML = String_XML_Parse($Response);
		if(Is_Exception($XML))
			return new gException('WRONG_SERVER_ANSWER',$Response,$XML);
		#-----------------------------------------------------------------------------
		$XML = $XML->ToArray('elem');
		#-----------------------------------------------------------------------------
		$Users = $XML['doc'];
		#-----------------------------------------------------------------------------
		if(IsSet($Users['error']))
			return new gException('GET_USERS_ERROR',$Users['error']);
		#-----------------------------------------------------------------------------
		$Result = Array();
		#-----------------------------------------------------------------------------
		if(IsSet($Users) && Is_Array($Users)){
			#-----------------------------------------------------------------------------
			foreach($Users as $User){
				#---------------------------------------------------------------------------
				if(!IsSet($User['name']))
					continue;
				#-----------------------------------------------------------------------------
				if($User['active'] != 'on')
					continue;
				#-----------------------------------------------------------------------------
				if(!IsSet($User['quota_total']))
					$User['quota_total'] = -1;
				#-------------------------------------------------------------------------------
				if(!IsSet($User['quota_used']))
					$User['quota_used'] = -1;
				#-----------------------------------------------------------------------------
				$Out[$User['name']] = Array('Limit'=>$User['quota_total'],'Used'=>$User['quota_used'],'Disabled'=>(($User['active'] == 'off')?TRUE:FALSE));
				#-----------------------------------------------------------------------------
			}
			#-----------------------------------------------------------------------------
		}
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	#Debug(SPrintF('[IspManager5_Get_Disk_Usage]: %s',print_r($Out,true)));
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	return $Out;
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
}


# added by lissyara 2025-11-21 in 10:58 MSK, for JBS-1747
#-----------------------------------------------------------------------------
#-------------------------------------------------------------------------------
function IspManager5_Get_DB_Usage($Settings){
	/****************************************************************************/
	$__args_types = Array('array');
	#-----------------------------------------------------------------------------
	$__args__ = Func_Get_Args(); Eval(FUNCTION_INIT);
	/****************************************************************************/
	$authinfo = SPrintF('%s:%s',$Settings['Login'],$Settings['Password']);
	#-----------------------------------------------------------------------------
	$HTTP = IspManager5_Build_HTTP($Settings);
	#-----------------------------------------------------------------------------
	$Out = Array();
	#-----------------------------------------------------------------------------
	# перебираем юзеров, составляем список активных с заданным и ненулевым лимитом на размер БД
	$Response = HTTP_Send('/ispmgr',$HTTP,Array(),Array('authinfo'=>$authinfo,'out'=>'xml','func'=>'user'));
	if(Is_Error($Response))
		return new gException('NOT_CONNECTED_TO_SERVER','Не удалось соедениться с сервером');
	#-----------------------------------------------------------------------------
	$Response = Trim($Response['Body']);
	#-----------------------------------------------------------------------------
	$XML = String_XML_Parse($Response);
	if(Is_Exception($XML))
		return new gException('WRONG_SERVER_ANSWER',$Response,$XML);
	#-----------------------------------------------------------------------------
	$XML = $XML->ToArray('elem');
	#-----------------------------------------------------------------------------
	$Users = $XML['doc'];
	#-----------------------------------------------------------------------------
	if(IsSet($Users['error']))
		return new gException('GET_USERS_ERROR',$Users['error']);
	#-----------------------------------------------------------------------------
	if(IsSet($Users) && Is_Array($Users)){
		#-----------------------------------------------------------------------------
		foreach($Users as $User){
			#---------------------------------------------------------------------------
			if(!IsSet($User['name']))
				continue;
			#-----------------------------------------------------------------------------
			if($User['active'] != 'on')
				continue;
			#-----------------------------------------------------------------------------
			if(!IsSet($User['limit_dbsize']))
				continue;
			#-------------------------------------------------------------------------------
			if($User['limit_dbsize'] < 1)
				continue;
			#-----------------------------------------------------------------------------
			$Out[$User['name']] = Array('Limit'=>$User['limit_dbsize'],'Used'=>0,'DBs'=>Array());
			#-----------------------------------------------------------------------------
		}
		#-----------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	#-----------------------------------------------------------------------------
	Debug(SPrintF('[IspManager5_Get_DB_Usage]: Out users = %s',SizeOf($Out)));
	#-----------------------------------------------------------------------------
	// достаём все базы с их размерами
	$Response = HTTP_Send('/ispmgr',$HTTP,Array(),Array('authinfo'=>$authinfo,'out'=>'xml','func'=>'db'));
	if(Is_Error($Response))
		return new gException('NOT_CONNECTED_TO_SERVER','Не удалось соедениться с сервером');
	#-----------------------------------------------------------------------------
	$Response = Trim($Response['Body']);
	#-----------------------------------------------------------------------------
	$XML = String_XML_Parse($Response);
	if(Is_Exception($XML))
		return new gException('WRONG_SERVER_ANSWER',$Response,$XML);
	#-----------------------------------------------------------------------------
	$XML = $XML->ToArray('elem');
	Debug(SPrintF('[IspManager5_Get_DB_Usage]: XML = %s',print_r($XML,true)));
	#-----------------------------------------------------------------------------
	$DBs = $XML['doc'];
	#-----------------------------------------------------------------------------
	if(IsSet($DBs['error']))
		return new gException('GET_USERS_ERROR',$DBs['error']);
	#-----------------------------------------------------------------------------
	if(IsSet($DBs) && Is_Array($DBs)){
		#-----------------------------------------------------------------------------
		foreach($DBs as $DB){
			#-----------------------------------------------------------------------------
			if(!Is_Array($DB))
				continue;
			#-----------------------------------------------------------------------------
			if(!IsSet($Out[$DB['owner']]))
				continue;
			#-----------------------------------------------------------------------------
			#Debug(SPrintF('[IspManager5_Get_DB_Usage]: $DB = %s',print_r($DB,true)));
			#-----------------------------------------------------------------------------
			#Debug(SPrintF('[IspManager5_Get_DB_Usage]: $Out[%s] = %s',$DB['owner'],print_r($Out[$DB['owner']],true)));
			#-----------------------------------------------------------------------------
			// добавляем общий размер в выходной массив
			$Out[$DB['owner']]['Used'] = $Out[$DB['owner']]['Used'] + $DB['size'];
			#-----------------------------------------------------------------------------
			// добавляем саму базу с размером, может будет использоваться
			$Out[$DB['owner']]['DBs'][$DB['name']] = $DB['size'];
			#-----------------------------------------------------------------------------
		}
		#-----------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	#Debug(SPrintF('[IspManager5_Get_DB_Usage]: %s',print_r($Out,true)));
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	return $Out;
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
}

# added by lissyara 2025-12-20 in 22:08 MSK, for JBS-1751
#-----------------------------------------------------------------------------
#-------------------------------------------------------------------------------
function IspManager5_Get_Account_Usage($Settings,$Users){
	/****************************************************************************/
	$__args_types = Array('array','array');
	#-----------------------------------------------------------------------------
	$__args__ = Func_Get_Args(); Eval(FUNCTION_INIT);
	/****************************************************************************/
	$authinfo = SPrintF('%s:%s',$Settings['Login'],$Settings['Password']);
	#-----------------------------------------------------------------------------
	$HTTP = IspManager5_Build_HTTP($Settings);
	#-----------------------------------------------------------------------------
	#-----------------------------------------------------------------------------
	// Массивы на выход и для ключей
	$Out = $Keys = Array();
	#-----------------------------------------------------------------------------
	// перебираем конфиг, создаём массив с полями которые необходимо передать дальше
	$Config = Config();
	$Graphs = $Config['Other']['Graphs'];
	#-----------------------------------------------------------------------------
	foreach(Array_Keys($Graphs) as $Key)
		foreach(Array_Keys($Graphs[$Key]['Keys']) as $ExtKey)
			$Keys[$ExtKey] = $Key;
	#-----------------------------------------------------------------------------
	#-----------------------------------------------------------------------------
	# перебираем юзеров, запрашиваем лимиты и использование
	foreach($Users as $User){
		#-----------------------------------------------------------------------------
		$Response = HTTP_Send('/ispmgr',$HTTP,Array(),Array('authinfo'=>$authinfo,'out'=>'json','func'=>'userstat','lang'=>'ru','su'=>$User));
		if(Is_Error($Response))
			return new gException('NOT_CONNECTED_TO_SERVER','Не удалось соедениться с сервером');
		#-----------------------------------------------------------------------------
		$Response = Trim($Response['Body']);
		#-----------------------------------------------------------------------------
		// там какая-то муть с $ в названиях....
		$Response = Str_Replace('$','value',$Response);
		#-----------------------------------------------------------------------------
		$Json = Json_Decode($Response,TRUE);
		#-----------------------------------------------------------------------------
		if(IsSet($Json['doc']['error']))
			continue;
		#-----------------------------------------------------------------------------
		#-----------------------------------------------------------------------------
		/*
		 * надо перебрать массив, оставить только нужное
		 * */
		$Out[$User]['Last'] = Array();
		#-----------------------------------------------------------------------------
		foreach($Json['doc']['elem'] as $Value){
			#-----------------------------------------------------------------------------
			//$Out[$User]['Last'][$Value['name']['valueorig']] = Array('Name'=>$Value['name']['value'],'Units'=>$Value['units']['value'],'Limit'=>(double)$Value['usages_total']['value'],'Used'=>(double)$Value['usages_used']['value']);
			#-----------------------------------------------------------------------------
			if(Array_Key_Exists($Value['name']['valueorig'],$Keys))
				$Out[$User]['Last'][$Keys[$Value['name']['valueorig']]] = Array(
												'Limit'=>(double)$Value['usages_total']['value'],
												'Used' =>(double)$Value['usages_used']['value']
												);
			#-----------------------------------------------------------------------------
		}
		#-----------------------------------------------------------------------------
		#-----------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	#-----------------------------------------------------------------------------
	//Debug(SPrintF('[IspManager5_Get_Account_Usage]: Out users = %s',SizeOf($Out)));
	#-----------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	return $Out;
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------




#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
# Функции используемые для внутреннего употребления =)
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
function IspManager5_Check_Version($Settings){
	/******************************************************************************/
	$__args_types = Array('array','string');
	$__args__ = Func_Get_Args(); Eval(FUNCTION_INIT);
	/******************************************************************************/
	$HTTP = IspManager5_Build_HTTP($Settings);
	#-------------------------------------------------------------------------------
	$authinfo = SPrintF('%s:%s',$Settings['Login'],$Settings['Password']);
	#-------------------------------------------------------------------------------
	# достаём информацию о лицензии
	$Response = HTTP_Send('/ispmgr',$HTTP,Array(),Array('authinfo'=>$authinfo,'out'=>'xml','func'=>'license.info'));
	if(Is_Error($Response))
		return new gException('NOT_CONNECTED_TO_SERVER','Не удалось соедениться с сервером');
	#-------------------------------------------------------------------------------
	$Response = Trim($Response['Body']);
	#-------------------------------------------------------------------------------
	$XML = String_XML_Parse($Response);
	if(Is_Exception($XML))
		return new gException('WRONG_SERVER_ANSWER',$Response,$XML);
	#-------------------------------------------------------------------------------
	$XML = $XML->ToArray();
	#-------------------------------------------------------------------------------
	$Info = $XML['doc'];
	#-------------------------------------------------------------------------------
	if(IsSet($Info['error']))
		return new gException('GET_LICENSE_INFO_ERROR',$Info['error']);
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	if(IsSet($Info['mgr']))
		return ((Preg_Match('/Business/i',$Info['mgr']))?'Business':'Lite');
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	if(IsSet($Info['panel_name']))
		return ((Preg_Match('/Business/i',$Info['panel_name']))?'Business':'Lite');
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	# не удалось определить версию панели
	return new gException('CANNOT_FIND_LICENSE_VERSION',print_r($Info,true));
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
}

#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
function IspManager5_Service_Restart($Settings,$Service){
	/******************************************************************************/
	$__args_types = Array('array','string');
	$__args__ = Func_Get_Args(); Eval(FUNCTION_INIT);
	/******************************************************************************/
	// что-то сломалось
	return TRUE;
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	$HTTP = IspManager5_Build_HTTP($Settings);
	#-------------------------------------------------------------------------------
	$authinfo = SPrintF('%s:%s',$Settings['Login'],$Settings['Password']);
	#-------------------------------------------------------------------------------
	# достаём список сервисов
	$Response = HTTP_Send('/ispmgr',$HTTP,Array(),Array('authinfo'=>$authinfo,'out'=>'xml','func'=>'services'));
	if(Is_Error($Response))
		return new gException('NOT_CONNECTED_TO_SERVER','Не удалось соедениться с сервером');
	#-------------------------------------------------------------------------------
	$Response = Trim($Response['Body']);
	#-------------------------------------------------------------------------------
	$XML = String_XML_Parse($Response);
	if(Is_Exception($XML))
		return new gException('WRONG_SERVER_ANSWER',$Response,$XML);
	#-------------------------------------------------------------------------------
	$XML = $XML->ToArray('elem');
	#-------------------------------------------------------------------------------
	$Services = $XML['doc'];
	#-------------------------------------------------------------------------------
	if(IsSet($Services['error']))
		return new gException('GET_SERVCES_ERROR',$Services['error']);
	#-------------------------------------------------------------------------------
	#Debug(SPrintF('[IspManager5_Service_Restart]: Services = %s',print_r($Services,true)));
	#-------------------------------------------------------------------------------
	# проверяем наличие такого сервиса
	foreach(Array_Keys($Services) as $ParamID)
		if(IsSet($Services[$ParamID]['name']))
			if($Services[$ParamID]['name'] == $Service)
				$Exist = TRUE;
	#-------------------------------------------------------------------------------
	# рестартуем сервис, при наличии
	if(IsSet($Exist)){
		#-------------------------------------------------------------------------------
		$Request = Array('authinfo'=>$authinfo,'out'=>'xml','func'=>'services.restart','elid'=>$Service);
		#-------------------------------------------------------------------------------
		$Response = HTTP_Send('/ispmgr',$HTTP,Array(),$Request);
		if(Is_Error($Response))
			return ERROR | @Trigger_Error('[IspManager5_Service_Restart]: не удалось соедениться с сервером');
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	return TRUE;
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
}

#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
function IspManager5_Build_HTTP($Settings){
	/******************************************************************************/
	$__args_types = Array('array');
	$__args__ = Func_Get_Args(); Eval(FUNCTION_INIT);
	/******************************************************************************/
	$authinfo = SPrintF('%s:%s',$Settings['Login'],$Settings['Password']);
	#-------------------------------------------------------------------------------
	$HTTP = Array(
			'Address'	=> $Settings['Params']['IP'],
			'Port'		=> $Settings['Port'],
			'Host'		=> $Settings['Address'],
			'Protocol'	=> $Settings['Protocol'],
			'Hidden'	=> $authinfo,
			'IsLogging'	=> $Settings['Params']['IsLogging']
			);
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	return $HTTP;
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
}


?>
