<?php
#-------------------------------------------------------------------------------
/** @author Alex Keda, for www.host-food.ru */
/* VDS functions written by lissyara, for www.host-food.ru */
#-------------------------------------------------------------------------------
if(Is_Error(System_Load('libs/HTTP.php','classes/Net_IDNA.class.php')))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
function VmManager5_KVM_Logon($Settings,$Params){
	/****************************************************************************/
	$__args_types = Array('array','array');
	#-----------------------------------------------------------------------------
	$__args__ = Func_Get_Args(); Eval(FUNCTION_INIT);
	/****************************************************************************/
	return Array('Url'=>$Settings['Params']['Url'],'Args'=>Array('lang'=>$Settings['Params']['Language'],'theme'=>($GLOBALS['IsMobile'])?'z-mobile':$Settings['Params']['Theme'],'checkcookie'=>'no','username'=>$Params['Login'],'password'=>$Params['Password'],'func'=>'auth'));
	#-------------------------------------------------------------------------------
}

#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
function VmManager5_KVM_Get_Domains($Settings){
	/******************************************************************************/
	$__args_types = Array('array','array','string','array');
	#-------------------------------------------------------------------------------
	$__args__ = Func_Get_Args(); Eval(FUNCTION_INIT);
	/******************************************************************************/
	// достаём список виртуалок
	$Request = Array('func'=>'vm');
	#-------------------------------------------------------------------------------
	$XML = VmManager5_KVM_Request($Settings,$Request,'elem');
	#-------------------------------------------------------------------------------
	$Doc = $XML['doc'];
	#-------------------------------------------------------------------------------
	if(IsSet($Doc['error']))
		return new gException('VmManager5_KVM_Get_Domains','Не удалось получить список VM');
	#-------------------------------------------------------------------------------
	$Users = Array();
	#-------------------------------------------------------------------------------
	foreach($Doc as $Vm){
		#-------------------------------------------------------------------------------
		// у виртуалки не задан шаблон
		if(!IsSet($Vm['osname']))
		/* либо тянем домены, либо шаблоны. доменов у ВПС нет, зато шаблоны будут обновляться
		// у виртуалки не задан домен
		if(!IsSet($Vm['domain']))
			continue;
		#-------------------------------------------------------------------------------
		*/
		// у виртуалки не задан владелец
		if(!IsSet($Vm['user']))
			continue;
		#-------------------------------------------------------------------------------
		$Users[$Vm['user']] = Array($Vm['osname']);
		#-------------------------------------------------------------------------------
        }
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	return $Users;
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
}

#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
function VmManager5_KVM_Create($Settings,$VPSOrder,$IP,$VPSScheme){
	/******************************************************************************/
	$__args_types = Array('array','array','string','array');
	#-------------------------------------------------------------------------------
	$__args__ = Func_Get_Args(); Eval(FUNCTION_INIT);
	/******************************************************************************/
	$IDNA = new Net_IDNA();
	#-------------------------------------------------------------------------------
	$Domain = $IDNA->encode($VPSOrder['Domain']);
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	# проверяем наличие такого юзера
	$Request = Array('func'=>'user.edit','elid'=>$VPSOrder['Login']);
	#-------------------------------------------------------------------------------
	$XML = VmManager5_KVM_Request($Settings,$Request);
	#-------------------------------------------------------------------------------
	$Doc = $XML['doc'];
	#-------------------------------------------------------------------------------
	if(!IsSet($Doc['error'])){
		#-------------------------------------------------------------------------------
		Debug(SPrintF('[VmManager5_KVM_Create]: юзер %s найден, проверяем его виртуалки',$VPSOrder['Login']));
		#-------------------------------------------------------------------------------
		# ошибки нет, юзер существует. достаём его идентификатор
		if(!IsSet($Doc['id']))
			return new gException('USER_ID_MISSING','Отсутствует идентификатор созданного пользователя');
		#-------------------------------------------------------------------------------
		$VmUserID = $Doc['id'];
		#-------------------------------------------------------------------------------
		#-------------------------------------------------------------------------------
		# проверяем есть ли у него виртуалки
		$VMs = VmManager5_KVM_GetVm($Settings,$VPSOrder['Login']);
		#-------------------------------------------------------------------------------
		if(SizeOf($VMs) > 0)
			return new gException('VmManager5_KVM_Create','Пользователь уже существует, и у него есть хоть одна виртуальная машина');
		#-------------------------------------------------------------------------------
	}else{
		#-------------------------------------------------------------------------------
		Debug(SPrintF('[VmManager5_KVM_Create]: юзер %s НЕ найден, созадём его',$VPSOrder['Login']));
		#-------------------------------------------------------------------------------
		# предполагаем, что это ошибка проверки, а значит юзер не существует
		# создаём юзера
		$Request = Array(
				'func'			=> 'user.edit',		# Целевая функция
				'sok'			=> 'ok',
				'name'			=> $VPSOrder['Login'],
				'passwd'		=> $VPSOrder['Password'],
				'confirm'		=> $VPSOrder['Password'],
				);
		#-------------------------------------------------------------------------------
		// считываем XML и составляем запрос
		$Fields = System_XML(SPrintF('config/Schemes.%s.xml',$VPSScheme['SchemeParams']['SystemID']));
		if(Is_Error($Fields))
			return ERROR | @Trigger_Error(500);
		#-------------------------------------------------------------------------------
		foreach(Array_Keys($Fields) as $Key){
			#-------------------------------------------------------------------------------
			$Field = $Fields[$Key];
			#-------------------------------------------------------------------------------
			if(!IsSet($Field['IsUser']))
				continue;
			#-------------------------------------------------------------------------------
			$Value = IsSet($VPSScheme['SchemeParams'][$Key])?$VPSScheme['SchemeParams'][$Key]:$Field['Value'];
			#-------------------------------------------------------------------------------
			$Request[$Key] = $Value;
			#-------------------------------------------------------------------------------
			if(IsSet($Field['Min']))
				$Request[$Key] = IntVal($Value);
			#-------------------------------------------------------------------------------
			if(IsSet($Field['Type']) && $Field['Type'] == 'CheckBox')
				$Request[$Key] = ($Request[$Key])?'on':'off';
			#-------------------------------------------------------------------------------
		}
		#-------------------------------------------------------------------------------
		$XML = VmManager5_KVM_Request($Settings,$Request);
		#-------------------------------------------------------------------------------
		$Doc = $XML['doc'];
		#-------------------------------------------------------------------------------
		if(IsSet($Doc['error']))
			return new gException('USER_ACCOUNT_CREATE_ERROR','Не удалось создать пользователя для виртуального сервера');
		#-------------------------------------------------------------------------------
		if(!IsSet($Doc['id']))
			return new gException('USER_ID_MISSING','Отсутствует идентификатор созданного пользователя');
		#-------------------------------------------------------------------------------
		$VmUserID = $Doc['id'];
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	# достаём список шаблонов VM, нам нужен числовой идентфиикатор указанного шаблона
	$Request = Array('func'=>'preset');
	#-------------------------------------------------------------------------------
	$XML = VmManager5_KVM_Request($Settings,$Request,'elem');
	#-------------------------------------------------------------------------------
	$Doc = $XML['doc'];
	if(IsSet($Doc['error']))
		return new gException('VmManager5_KVM_Create','Не удалось получить список шаблонов VM');
	#------------------------------------------------------------------------------
	foreach($Doc as $Preset){
		#------------------------------------------------------------------------------
		if(!IsSet($Preset['id']))
			continue;
		#------------------------------------------------------------------------------
		if($Preset['name'] == $VPSScheme['SchemeParams']['preset'])
			$VmPresetID = $Preset['id'];
		#------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	if(!IsSet($VmPresetID))
		Debug(SPrintF('[VmManager5_KVM_Create]: шаблон "%s" не найден в шаблонах на KVMmgr, виртуалка будет создана без шаблона',$VPSScheme['preset']));
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	# создаём виртуалку
	$Request = Array(
			'func'			=> 'vm.edit',					# Целевая функция
			'sok'			=> 'ok',
			'hostnode'		=> $VPSScheme['Node'],				// нода кластера
			'password'		=> $VPSOrder['Password'],
			'confirm'		=> $VPSOrder['Password'],
			'domain'		=> $VPSOrder['Domain'],				# для обратной зоны
			'family'		=> 'ipv4',					# пока IPv6 всё ещё теория
			'name'			=> $VPSOrder['Login'],
			'user'			=> $VmUserID,
			'vmi'			=> SPrintF('ISPsystem__%s',Trim($VPSOrder['DiskTemplate'])),
			);
	#-------------------------------------------------------------------------------
	// считываем XML и составляем запрос
	$Fields = System_XML(SPrintF('config/Schemes.%s.xml',$VPSScheme['SchemeParams']['SystemID']));
	if(Is_Error($Fields))
		return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------------
	foreach(Array_Keys($Fields) as $Key){
		#-------------------------------------------------------------------------------
		$Field = $Fields[$Key];
		#-------------------------------------------------------------------------------
		$Value = IsSet($VPSScheme['SchemeParams'][$Key])?$VPSScheme['SchemeParams'][$Key]:$Field['Value'];
		#-------------------------------------------------------------------------------
		$Request[$Key] = $Value;
		#-------------------------------------------------------------------------------
		if(IsSet($Field['Min']))
			$Request[$Key] = IntVal($Value);
		#-------------------------------------------------------------------------------
		if(IsSet($Field['Type']) && $Field['Type'] == 'CheckBox')
			$Request[$Key] = ($Request[$Key])?'on':'off';
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	if(IsSet($VmPresetID))
		$Request['preset'] = $VmPresetID;
	#-------------------------------------------------------------------------------
	$XML = VmManager5_KVM_Request($Settings,$Request);
	#-------------------------------------------------------------------------------
	$Doc = $XML['doc'];
	#-------------------------------------------------------------------------------
	if(IsSet($Doc['error']))
		return new gException('ACCOUNT_CREATE_ERROR','Не удалось создать виртуальный сервер');
	#-------------------------------------------------------------------------------
        if(!IsSet($Doc['id']))
		return new gException('VM_ID_MISSING','Отсутствует идентификатор созданной виртуальной машины');
	#-------------------------------------------------------------------------------
	$VmID = $Doc['id'];
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	$Request = Array(
			'func'			=> 'vm.edit',		# Целевая функция
			'elid'			=> $VmID,
			);
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	$XML = VmManager5_KVM_Request($Settings,$Request);
	#-------------------------------------------------------------------------------
	$Doc = $XML['doc'];
	#-------------------------------------------------------------------------------
	if(IsSet($Doc['error']))
		return new gException('GET_VM_INFO_ERROR','Не удалось получить информацию о виртуальном сервере');
	#-------------------------------------------------------------------------------
        if(!IsSet($Doc['ip']))
		return new gException('VM_IP_MISSING','Отсутствует IP созданной виртуальной машины');
	#-------------------------------------------------------------------------------
	Debug(SPrintF('[system/libs/VmManager5_KVM]: VPS order created with IP = %s',$Doc['ip']));
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	return Array('ID'=>$VPSOrder['ID'],'IP'=>$Doc['ip']);
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
}

#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
function VmManager5_KVM_Active($Settings,$Login){
	/******************************************************************************/
	$__args_types = Array('array','string');
	#-------------------------------------------------------------------------------
	$__args__ = Func_Get_Args(); Eval(FUNCTION_INIT);
	/******************************************************************************/
	$VMs = VmManager5_KVM_GetVm($Settings,$Login);
	#-------------------------------------------------------------------------------
	if(SizeOf($VMs) < 1)
		return new gException('VmManager5_KVM_Active','Не удалось получить список виртуальных машин пользователя');
	#-------------------------------------------------------------------------------
	foreach($VMs as $VM){
		#-------------------------------------------------------------------------------
		#Debug(SPrintF('[system/libs/VmManager5_KVM]: VM = %s',print_r($VM,true)));
		if(!IsSet($VM['id']))
			continue;
		#-------------------------------------------------------------------------------
		$Request = Array('func'=>'vm.start','elid'=>$VM['id']);
		#-------------------------------------------------------------------------------
		$XML = VmManager5_KVM_Request($Settings,$Request);
		#-------------------------------------------------------------------------------
		$Doc = $XML['doc'];
		#-----------------------------------------------------------------------------
		if(IsSet($Doc['error']))
			return new gException('VM_ACTIVATE_ERROR','Не удалось включить виртуальный сервер');
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	return TRUE;
	#-------------------------------------------------------------------------------
}

#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
function VmManager5_KVM_Suspend($Settings,$Login,$VPSScheme){
	/******************************************************************************/
	$__args_types = Array('array','string','array');
	#-------------------------------------------------------------------------------
	$__args__ = Func_Get_Args(); Eval(FUNCTION_INIT);
	/******************************************************************************/
	#------------------------------------------------------------------------------
	$VMs = VmManager5_KVM_GetVm($Settings,$Login);
	#-------------------------------------------------------------------------------
	if(SizeOf($VMs) < 1)
		return new gException('VmManager5_KVM_Suspend','Не удалось получить список виртуальных машин пользователя');
	#-------------------------------------------------------------------------------
	foreach($VMs as $VM){
		#-------------------------------------------------------------------------------
		#Debug(SPrintF('[system/libs/VmManager5_KVM]: VM = %s',print_r($VM,true)));
		if(!IsSet($VM['id']))
			continue;
		#-------------------------------------------------------------------------------
		$Request = Array('func'=>'vm.stop','elid'=>$VM['id']);
		#-------------------------------------------------------------------------------
		$XML = VmManager5_KVM_Request($Settings,$Request);
		#-------------------------------------------------------------------------------
		$Doc = $XML['doc'];
		#-----------------------------------------------------------------------------
		if(IsSet($Doc['error']))
			return new gException('VM_SUSPEND_ERROR','Не удалось выключить виртуальный сервер');
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	return TRUE;
	#-------------------------------------------------------------------------------
}

#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
function VmManager5_KVM_Delete($Settings,$Login){
	/******************************************************************************/
	$__args_types = Array('array','string','array');
	#-------------------------------------------------------------------------------
	$__args__ = Func_Get_Args(); Eval(FUNCTION_INIT);
	/******************************************************************************/
	# проверяем, возможно такого уже и нету
	$Request = Array('func'=>'user');
	#-------------------------------------------------------------------------------
	$XML = VmManager5_KVM_Request($Settings,$Request,'elem');
	#-------------------------------------------------------------------------------
	$Doc = $XML['doc'];
	if(IsSet($Doc['error']))
		return new gException('VmManager5_KVM_Delete','Не удалось получить список пользователей');
	#------------------------------------------------------------------------------
	foreach($Doc as $User){
		#------------------------------------------------------------------------------
		if(!IsSet($User['id']))
			continue;
		#------------------------------------------------------------------------------
		if($User['name'] == $Login)
			$VmUserID = $User['id'];
		#------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	if(!IsSet($VmUserID)){
		#-------------------------------------------------------------------------------
		Debug(SPrintF('[VmManager5_KVM_Delete]: пользователь %s уже удалён ',$Login));
		#-------------------------------------------------------------------------------
		return TRUE;
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	$VMs = VmManager5_KVM_GetVm($Settings,$Login);
	#-------------------------------------------------------------------------------
	// TODO а может их уже удалили, был сбой просто?
	//if(SizeOf($VMs) < 1)
	//	return new gException('VmManager5_KVM_Delete','Не удалось получить список виртуальных машин пользователя');
	#-------------------------------------------------------------------------------
	foreach($VMs as $VM){
		#-------------------------------------------------------------------------------
		#Debug(SPrintF('[VmManager5_KVM_Delete]: VM = %s',print_r($VM,true)));
		if(!IsSet($VM['id']))
			continue;
		#-------------------------------------------------------------------------------
		$Request = Array('func'=>'vm.delete','elid'=>$VM['id']);
		#-------------------------------------------------------------------------------
		$XML = VmManager5_KVM_Request($Settings,$Request);
		#-------------------------------------------------------------------------------
		$Doc = $XML['doc'];
		#-----------------------------------------------------------------------------
		if(IsSet($Doc['error']))
			return new gException('VM_DELETE_ERROR','Не удалось удалить виртуальный сервер');
		#-------------------------------------------------------------------------------
	}
	#------------------------------------------------------------------------------
	#------------------------------------------------------------------------------
	# грохаем харды
	$Request = Array('func'=>'volume','su'=>$Login);
	#-------------------------------------------------------------------------------
	$XML = VmManager5_KVM_Request($Settings,$Request,'elem');
	#-------------------------------------------------------------------------------
	$Doc = $XML['doc'];
	if(IsSet($Doc['error']))
		return new gException('VmManager5_KVM_Delete','Не удалось получить список дисков пользователя');
	#-------------------------------------------------------------------------------
	foreach($Doc as $HDD){
		#-------------------------------------------------------------------------------
		if(!IsSet($HDD['id']))
			continue;
		#-------------------------------------------------------------------------------
		$Request = Array('func'=>'volume.extdelete','elid'=>$HDD['id'],'sok'=>'ok');
		#-------------------------------------------------------------------------------
		$XML = VmManager5_KVM_Request($Settings,$Request);
		#-------------------------------------------------------------------------------
		$Doc = $XML['doc'];
		#-----------------------------------------------------------------------------
		if(IsSet($Doc['error']))
			return new gException('VM_DELETE_ERROR','Не удалось удалить HDD');
		#-------------------------------------------------------------------------------
	}
	#------------------------------------------------------------------------------
	#------------------------------------------------------------------------------
	# грохаем ISO
	$Request = Array('func'=>'iso','su'=>$Login);
	#-------------------------------------------------------------------------------
	$XML = VmManager5_KVM_Request($Settings,$Request,'elem');
	#-------------------------------------------------------------------------------
	$Doc = $XML['doc'];
	if(IsSet($Doc['error']))
		return new gException('VmManager5_KVM_Delete','Не удалось получить список ISO образов пользователя');
	#-------------------------------------------------------------------------------
	foreach($Doc as $ISO){
		#-------------------------------------------------------------------------------
		if(!IsSet($ISO['id']))
			continue;
		#-------------------------------------------------------------------------------
		if($ISO['owner'] != 'on')
			continue;
		#-------------------------------------------------------------------------------
		#-------------------------------------------------------------------------------
		$Request = Array('func'=>'iso.delete','elid'=>$ISO['id']);
		#-------------------------------------------------------------------------------
		$XML = VmManager5_KVM_Request($Settings,$Request);
		#-------------------------------------------------------------------------------
		$Doc = $XML['doc'];
		#-----------------------------------------------------------------------------
		if(IsSet($Doc['error']))
			return new gException('VM_DELETE_ERROR','Не удалось удалить ISO');
		#-------------------------------------------------------------------------------
	}
	#------------------------------------------------------------------------------
	#------------------------------------------------------------------------------
	# грохаем самого юзера
	$Request = Array('func'=>'user.delete','elid'=>$VmUserID);
	#-------------------------------------------------------------------------------
	$XML = VmManager5_KVM_Request($Settings,$Request);
	#-------------------------------------------------------------------------------
	$Doc = $XML['doc'];
	#-----------------------------------------------------------------------------
	if(IsSet($Doc['error']))
		return new gException('USER_DELETE_ERROR','Не удалось удалить пользователя виртуального сервера');
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	return TRUE;
	#-------------------------------------------------------------------------------
	#------------------------------------------------------------------------------
}

#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
function VmManager5_KVM_Scheme_Change($Settings,$VPSOrder,$VPSScheme){
	/******************************************************************************/
	$__args_types = Array('array','array','array');
	#-------------------------------------------------------------------------------
	$__args__ = Func_Get_Args(); Eval(FUNCTION_INIT);
	/******************************************************************************/
	# достаём всех пользователей, перебираем и ищем нужного
	$Request = Array('func'=>'user');
	#-------------------------------------------------------------------------------
	$XML = VmManager5_KVM_Request($Settings,$Request,'elem');
	#-------------------------------------------------------------------------------
	$Doc = $XML['doc'];
	if(IsSet($Doc['error']))
		return new gException('VmManager5_KVM_Scheme_Change','Не удалось получить список пользователей');
	#-------------------------------------------------------------------------------
	foreach($Doc as $User){
		#-------------------------------------------------------------------------------
		if(!IsSet($User['id']))
			continue;
		#-------------------------------------------------------------------------------
		if(!IsSet($User['name']))
			continue;
		#-------------------------------------------------------------------------------
		if($User['name'] == $VPSOrder['Login'])
			$UserID = $User['id'];
		#-------------------------------------------------------------------------------

	}
	#-------------------------------------------------------------------------------
	if(!IsSet($UserID))
		return new gException('VmManager5_KVM_Scheme_Change',SPrintF('Не удалось найти полльзователя "%s"',$VPSOrder['Login']));
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	# меняем параметры пользователя
	$Request = Array(
			'func'			=> 'user.edit',		# Целевая функция
			'sok'			=> 'ok',
			'disable_totp'		=> 'on',		# гуглоавторизацию - отключаем
			'name'			=> $VPSOrder['Login'],
			'passwd'		=> $VPSOrder['Password'],
			'confirm'		=> $VPSOrder['Password'],
			'elid'			=> $UserID
			);
	#-------------------------------------------------------------------------------
	// считываем XML и составляем запрос
	$Fields = System_XML(SPrintF('config/Schemes.%s.xml',$VPSScheme['SchemeParams']['SystemID']));
	if(Is_Error($Fields))
		return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------------
	foreach(Array_Keys($Fields) as $Key){
		#-------------------------------------------------------------------------------
		$Field = $Fields[$Key];
		#-------------------------------------------------------------------------------
		if(!IsSet($Field['IsUser']))
			continue;
		#-------------------------------------------------------------------------------
		$Value = IsSet($VPSScheme['SchemeParams'][$Key])?$VPSScheme['SchemeParams'][$Key]:$Field['Value'];
		#-------------------------------------------------------------------------------
		$Request[$Key] = $Value;
		#-------------------------------------------------------------------------------
		if(IsSet($Field['Min']))
			$Request[$Key] = IntVal($Value);
		#-------------------------------------------------------------------------------
		if(IsSet($Field['Type']) && $Field['Type'] == 'CheckBox')
			$Request[$Key] = ($Request[$Key])?'on':'off';
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	$XML = VmManager5_KVM_Request($Settings,$Request);
	#-------------------------------------------------------------------------------
	$Doc = $XML['doc'];
	#-------------------------------------------------------------------------------
	if(IsSet($Doc['error']))
		return new gException('USER_CHANGE_ERROR','Не удалось изменить пользователя');
	#-------------------------------------------------------------------------------
	// ещё раз, ибо кривая панель - гуглоавторизацию не отклчюает
	$Request = Array(
			'func'		=> 'usrparam',
	                'name'		=> $VPSOrder['Login'],
			'passwd'	=> $VPSOrder['Password'],
			'confirm'	=> $VPSOrder['Password'],
			'atype'		=> 'atany',
			'sok'		=> 'ok',
			'su'		=> $VPSOrder['Login'],
			'setgeoip'	=> 'off',
			'secureip'	=> 'off',
			'vk_status'	=> 'off',
			'fb_status'	=> 'off',
			'gl_status'	=> 'off',
			'disable_totp'	=> 'on',
	);
	#-------------------------------------------------------------------------------
	$XML = VmManager5_KVM_Request($Settings,$Request);
	#-------------------------------------------------------------------------------
	$Doc = $XML['doc'];
	#-------------------------------------------------------------------------------
	if(IsSet($Doc['error']))
		return new gException('PASSWORD_CHANGE_ERROR','Не удалось изменить пароль для пользователя виртуального сервера');
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	$VMs = VmManager5_KVM_GetVm($Settings,$VPSOrder['Login']);
	#-------------------------------------------------------------------------------
	if(SizeOf($VMs) < 1)
		return new gException('VmManager5_KVM_Scheme_Change','Не удалось получить список виртуальных машин пользователя');
	#-------------------------------------------------------------------------------
	foreach($VMs as $VM){
		#-------------------------------------------------------------------------------
		#Debug(SPrintF('[system/libs/VmManager5_KVM]: VM = %s',print_r($VM,true)));
		if(!IsSet($VM['id']))
			continue;
		#-------------------------------------------------------------------------------
		#-------------------------------------------------------------------------------
		$Request = Array(
				'func'			=> 'vm.edit',		# Целевая функция
				'sok'			=> 'ok',
				'name'			=> $VPSOrder['Login'],
				'elid'			=> $VM['id'],
				);
		#-------------------------------------------------------------------------------
		// считываем XML и составляем запрос
		$Fields = System_XML(SPrintF('config/Schemes.%s.xml',$VPSScheme['SchemeParams']['SystemID']));
		if(Is_Error($Fields))
			return ERROR | @Trigger_Error(500);
		#-------------------------------------------------------------------------------
		foreach(Array_Keys($Fields) as $Key){
			#-------------------------------------------------------------------------------
			$Field = $Fields[$Key];
			#-------------------------------------------------------------------------------
			$Value = IsSet($VPSScheme['SchemeParams'][$Key])?$VPSScheme['SchemeParams'][$Key]:$Field['Value'];
			#-------------------------------------------------------------------------------
			$Request[$Key] = $Value;
			#-------------------------------------------------------------------------------
			if(IsSet($Field['Min']))
				$Request[$Key] = IntVal($Value);
			#-------------------------------------------------------------------------------
			if(IsSet($Field['Type']) && $Field['Type'] == 'CheckBox')
				$Request[$Key] = ($Request[$Key])?'on':'off';
			#-------------------------------------------------------------------------------
		}
		#-------------------------------------------------------------------------------
		$XML = VmManager5_KVM_Request($Settings,$Request);
		#-------------------------------------------------------------------------------
		$Doc = $XML['doc'];
		#-------------------------------------------------------------------------------
		if(IsSet($Doc['error']))
			return new gException('SCHEME_CHANGE_ERROR','Не удалось изменить тарифный план для заказа VPS');
		#-------------------------------------------------------------------------------
		#-------------------------------------------------------------------------------
		// получаем список снимков
		$Request = Array('func'=>'vm.snapshot','elid'=>$VM['id'],'sok'=>'ok');
		#-------------------------------------------------------------------------------
		$XML = VmManager5_KVM_Request($Settings,$Request,'elem');
		#-------------------------------------------------------------------------------
		$Doc = $XML['doc'];
		#-------------------------------------------------------------------------------
		if(IsSet($Doc['error']))
			return new gException('VM_Get_SnapShot_Error','Не удалось получить список снимков витруальной машины');
		#-------------------------------------------------------------------------------
		// перебираем снимки, удаляем
		foreach($Doc as $SnapShot){
			#-------------------------------------------------------------------------------
			if(!IsSet($SnapShot['id']))
				continue;
			#-------------------------------------------------------------------------------
			$Request = Array('func'=>'vm.snapshot.delete','elid'=>$SnapShot['id'],'plid'=>$VM['id'],'sok'=>'ok');
			#-------------------------------------------------------------------------------
			$XML = VmManager5_KVM_Request($Settings,$Request);
			#-------------------------------------------------------------------------------
			$Doc = $XML['doc'];
			#-------------------------------------------------------------------------------
			if(IsSet($Doc['error']))
				return new gException('VM_Delete_SnapShot_Error','Не удалось получить список снимков витруальной машины');
			#-------------------------------------------------------------------------------
		}
		#-------------------------------------------------------------------------------
		#-------------------------------------------------------------------------------
		# меняем размер диска, достаём список дисков у машины
		$Request = Array('func'=>'vm.volume','elid'=>$VM['id']);
		#-------------------------------------------------------------------------------
		$XML = VmManager5_KVM_Request($Settings,$Request,'elem');
		#-------------------------------------------------------------------------------
		$Doc = $XML['doc'];
		if(IsSet($Doc['error']))
			return new gException('VmManager5_KVM_Scheme_Change','Не удалось получить список дисков виртуальных машин');
		#-------------------------------------------------------------------------------
		foreach($Doc as $Volume){
			#-------------------------------------------------------------------------------
			if(!IsSet($Volume['id']))
				continue;
			#-------------------------------------------------------------------------------
			if(!IsSet($Volume['type']) || $Volume['type'] != 'vdisk')
				continue;
			#-------------------------------------------------------------------------------
			#-------------------------------------------------------------------------------
			// проверяем размер дисков. если они одинаковые - перезагружать и трогать их не надо
			if($Volume['size'] == $VPSScheme['SchemeParams']['vsize'])
				continue;
			#-------------------------------------------------------------------------------
			// ещё вариант - диск оказался больше чем необходимо. с этим тоже ничего не сделаешь.
			// KVM не позволяет уменьшать диск - либо пропустить, либо в ошибку падать. лучше пропустить, наверное...
			if($Volume['size'] > $VPSScheme['SchemeParams']['vsize']){
				#-------------------------------------------------------------------------------
				Debug(SPrintF('[VmManager5_KVM_Scheme_Change]: Невозможно изменить размер диска в меньшую сторону (%s->%s) пропускаем',$VPSScheme['SchemeParams']['vsize'],$Volume['size']));
				#-------------------------------------------------------------------------------
				continue;
				#-------------------------------------------------------------------------------
			}
			#-------------------------------------------------------------------------------
			#-------------------------------------------------------------------------------
			// Сохраняем статус машины, чтобы не запустить остановленную по каким-то причинам (админ прям с сервера залочил)
			$Power = ($VM['vmpowered'] == 'on')?TRUE:FALSE;
			#-------------------------------------------------------------------------------
			# останавливаем машину
			if($Power){
				#-------------------------------------------------------------------------------
				$Request = Array('func'=>'vm.stop','elid'=>$VM['id'],'sok'=>'ok');
				#-------------------------------------------------------------------------------
				$XML = VmManager5_KVM_Request($Settings,$Request);
				#-------------------------------------------------------------------------------
				$Doc = $XML['doc'];
				#-------------------------------------------------------------------------------
				if(IsSet($Doc['error']))
					return new gException('VM_STOP_ERROR','Не удалось остановить виртуальную машину, для изменения размера диска');
				#-------------------------------------------------------------------------------
			}
			#-------------------------------------------------------------------------------
			# меняем размер диска
			$Request = Array('func'=>'vm.volume.edit','size'=>$VPSScheme['SchemeParams']['vsize'],'elid'=>$Volume['id'],'plid'=>$VM['id'],'sok'=>'ok');
			#-------------------------------------------------------------------------------
			$XML = VmManager5_KVM_Request($Settings,$Request);
			#-------------------------------------------------------------------------------
			$Doc = $XML['doc'];
			#-------------------------------------------------------------------------------
			if(IsSet($Doc['error']))
				return new gException('DISK_SIZE_CHANGE_ERROR','Не удалось изменить размер диска для заказа VPS');
			#-------------------------------------------------------------------------------
			#-------------------------------------------------------------------------------
			if($Power){
				#-------------------------------------------------------------------------------
				# были проблемы при попытке старта. думаю, стоит подождать с минуту.
				Sleep(60);	// TODO может стоит время вынести в конфиг?
				#-------------------------------------------------------------------------------
				#-------------------------------------------------------------------------------
				# запускаем машину
				$Request = Array('func'=>'vm.start','elid'=>$VM['id'],'sok'=>'ok');
				#-------------------------------------------------------------------------------
				$XML = VmManager5_KVM_Request($Settings,$Request);
				#-------------------------------------------------------------------------------
				$Doc = $XML['doc'];
				#-------------------------------------------------------------------------------
				if(IsSet($Doc['error']))
					return new gException('DISK_SIZE_CHANGE_ERROR','Не удалось изменить размер диска для заказа VPS');
				#-------------------------------------------------------------------------------
			}
			#-------------------------------------------------------------------------------
			// TODO надо дёрнуть данные машинки, и проверить флаг needreboot, если он есть - перезагрузить
		}
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	return TRUE;
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
}

#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
function VmManager5_KVM_Password_Change($Settings,$Login,$Password,$Params){
	/******************************************************************************/
	$__args_types = Array('array','string','string','array');
	#-------------------------------------------------------------------------------
	$__args__ = Func_Get_Args(); Eval(FUNCTION_INIT);
	/******************************************************************************/
	#-------------------------------------------------------------------------------
	$Request = Array(
			'func'		=> 'usrparam',
	                'name'		=> $Login,
			'passwd'	=> $Password,
			'confirm'	=> $Password,
			'atype'		=> 'atany',
			'sok'		=> 'ok',
			'su'		=> $Login,
			'setgeoip'	=> 'off',
			'secureip'	=> 'off',
			'vk_status'	=> 'off',
			'fb_status'	=> 'off',
			'gl_status'	=> 'off',
			'disable_totp'	=> 'on',
	);
	#-------------------------------------------------------------------------------
	$XML = VmManager5_KVM_Request($Settings,$Request);
	#-------------------------------------------------------------------------------
	$Doc = $XML['doc'];
	#-------------------------------------------------------------------------------
	if(IsSet($Doc['error']))
		return new gException('PASSWORD_CHANGE_ERROR','Не удалось изменить пароль для пользователя виртуального сервера');
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	$VMs = VmManager5_KVM_GetVm($Settings,$Login);
	#-------------------------------------------------------------------------------
	if(SizeOf($VMs) < 1)
		return new gException('VmManager5_KVM_Password_Change','Не удалось получить список виртуальных машин пользователя');
	#-------------------------------------------------------------------------------
	foreach($VMs as $VM){
		#-------------------------------------------------------------------------------
		#Debug(SPrintF('[VmManager5_KVM_Password_Change]: VM = %s',print_r($VM,true)));
		if(!IsSet($VM['id']))
			continue;
		#-------------------------------------------------------------------------------
		# http://forum.ispsystem.com/ru/showthread.php?t=27057
		if(!IsSet($VM['chpass']))
			continue;
		#-------------------------------------------------------------------------------
		if($VM['chpass'] != 'on')
			continue;
		#-------------------------------------------------------------------------------
		$Request = Array(
				'func'			=> 'vm.chpasswd',	# Целевая функция
				'sok'			=> 'ok',
				'elid'			=> $VM['id'],
				'password'		=> $Password,
				'confirm'		=> $Password,
				);
		#-------------------------------------------------------------------------------
		$XML = VmManager5_KVM_Request($Settings,$Request);
		#-------------------------------------------------------------------------------
		$Doc = $XML['doc'];
		#-------------------------------------------------------------------------------
		# не для все виртуалок можно так менять пасс
		if(IsSet($Doc['error']))
			Debug(SPrintF('[system/libs/VmManager5_KVM.php]: не удалось изменить пароль, возможно функция не поддерживается'));
		#	return new gException('PASSWORD_CHANGE_ERROR','Не удалось изменить пароль для заказа VPS');
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	return TRUE;
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
}

#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
# added by lissyara 2011-08-09 in 09:55 MSK
function VmManager5_KVM_AddIP($Settings,$Login,$ID,$Domain,$IP,$AddressType){
	/****************************************************************************/
        $__args_types = Array('array','string','string','string','string','string');
        $__args__ = Func_Get_Args(); Eval(FUNCTION_INIT);
        #Debug("ExtraIP order ID = " . $ID);
	/****************************************************************************/
	# достаём список виртуалок
	$VMs = VmManager5_KVM_GetVm($Settings,$Login);
	#-------------------------------------------------------------------------------
	if(SizeOf($VMs) < 1)
		return new gException('VmManager5_KVM_AddIP','Не удалось получить список виртуальных машин пользователя');
	#-------------------------------------------------------------------------------
	if(SizeOf($VMs) > 1)
		return new gException('VmManager5_KVM_AddIP','У пользователя более одной виртуальной машины, невозможно добавить IP адрес');
	#-------------------------------------------------------------------------------
	foreach($VMs as $VM){
		#-------------------------------------------------------------------------------
		#Debug(SPrintF('[system/libs/VmManager5_KVM]: VM = %s',print_r($VM,true)));
		if(!IsSet($VM['id']))
			continue;
		#-----------------------------------------------------------------------------
        	$Request = Array(
				'func'			=> 'iplist.edit',
				'domain'		=> $Domain,
				'family'		=> 'ipv4',
				#'ip'			=> '',
				'iptype'		=> 'public',
				'plid'			=> $VM['id'],
				'sok'			=> 'ok',
				#'elid'			=> '',
        	);
        	#Debug(var_export($Settings, true));
		#-------------------------------------------------------------------------------
		$XML = VmManager5_KVM_Request($Settings,$Request);
        	#-----------------------------------------------------------------------------
        	$Doc = $XML['doc'];
        	#-----------------------------------------------------------------------------
		if(IsSet($Doc['error']))
			return new gException('AddIP_ERROR','Не удалось добавить IP для виртуального сервера');
		#-----------------------------------------------------------------------------
		Debug("[system/libs/VmManager5_KVM]: to VPS added IP = " . $Doc['ip']);
	        #-----------------------------------------------------------------------------
	}
	#-----------------------------------------------------------------------------
	#-----------------------------------------------------------------------------
	return Array('ID'=>$ID,'IP'=>$Doc['ip']);
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
}

# added by lissyara 2011-08-09 in 13:03 MSK
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
function VmManager5_KVM_DeleteIP($Settings,$ExtraIP){
	/******************************************************************************/
        $__args_types = Array('array','string');
	#-------------------------------------------------------------------------------
        $__args__ = Func_Get_Args(); Eval(FUNCTION_INIT);
        #Debug("ExtraIP order ID = " . $ID);
	/******************************************************************************/
	# достаём список виртуалок
	$VMs = VmManager5_KVM_GetVm($Settings);
	#-------------------------------------------------------------------------------
	if(SizeOf($VMs) < 1)
		return new gException('VmManager5_KVM_DeleteIP','Не удалось получить список виртуальных машин');
	#-------------------------------------------------------------------------------
	foreach($VMs as $VM){
		#-------------------------------------------------------------------------------
		#Debug(SPrintF('[system/libs/VmManager5_KVM]: VM = %s',print_r($VM,true)));
		if(!IsSet($VM['id']))
			continue;
		#-------------------------------------------------------------------------------
		# достаём список адресов машинки
		$Request = Array('func'=>'iplist','elid'=>$VM['id']);
		#-------------------------------------------------------------------------------
		$XML = VmManager5_KVM_Request($Settings,$Request,'elem');
		#-------------------------------------------------------------------------------
		$Doc = $XML['doc'];
		if(IsSet($Doc['error']))
			return new gException('VmManager5_KVM_DeleteIP','Не удалось получить список IP адресов машины');
		#-------------------------------------------------------------------------------
		foreach($Doc as $IP){
			#-------------------------------------------------------------------------------
			if(!IsSet($IP['id']))
				continue;
			#-------------------------------------------------------------------------------
			Debug(SPrintF('[system/libs/VmManager5_KVM]: VM[id] = %s; IP[id] = %s; IP[ip] = %s',$VM['id'],$IP['id'],$IP['ip']));
			#-------------------------------------------------------------------------------
			if($IP['ip'] != $ExtraIP)
				continue;
			#-------------------------------------------------------------------------------
			# удаляем
			$Request = Array('func'=>'iplist.delete','plid'=>$VM['id'],'elid'=>$IP['id']);
			#-------------------------------------------------------------------------------
			$XML = VmManager5_KVM_Request($Settings,$Request,'elem');
			#-------------------------------------------------------------------------------
			if(IsSet($XML['doc']['error']))
				return new gException('VmManager5_KVM_DeleteIP','Не удалось получить список виртуальных машин');
			#-------------------------------------------------------------------------------
			return TRUE;
			#-------------------------------------------------------------------------------
		}
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	Debug(SPrintF('[system/libs/VmManager5_KVM]: IP адрес (%s) не обнаружен ни на одной виртуальной машине',$ExtraIP));
        #------------------------------------------------------------------------------
	#------------------------------------------------------------------------------
	return TRUE;
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
}

# added by lissyara 2011-10-07 in 10:28 MSK
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
function VmManager5_KVM_MainUsage($Settings){
	/******************************************************************************/
        $__args_types = Array('array');
        $__args__ = Func_Get_Args(); Eval(FUNCTION_INIT);
	/******************************************************************************/
	# TODO: надо сделать
	return rand(1,10);
	#-------------------------------------------------------------------------------
        $Request = Array(
                'func'          => 'mainusage',
                'sok'           => 'ok'
        );
        #Debug(var_export($Settings, true));
	#-----------------------------------------------------------------------------
	$XML = VmManager5_KVM_Request($Settings,$Request);
        #-----------------------------------------------------------------------------
        $Doc = $XML['doc'];
        if(IsSet($Doc['error']))
                return new gException('VmManager5_KVM_MainUsage','Не удалось получить нагрузку сервера');
        #---------------------------------------------------------------------------
        # перебираем, складываем
        $Out = Array(
                        'cpuu'  => 0,
                        'memu'  => 0,
                        'swapu' => 0,
                        'disk0' => 0
                );
        $NumStrings = SizeOf($Doc);
        foreach($Doc as $Usage){
                $Out['cpuu'] = $Out['cpuu'] + $Usage['cpuu'];
                $Out['memu'] = $Out['memu'] + $Usage['memu'];
                $Out['swapu'] = $Out['swapu'] + $Usage['swapu'];
                $Out['disk0'] = $Out['disk0'] + $Usage['disk0'];
        }
        # считаем средние значнеия
        $Out['cpuu'] = $Out['cpuu'] / SizeOf($Doc);
        $Out['memu'] = $Out['memu'] / SizeOf($Doc);
        $Out['swapu'] = $Out['swapu'] / SizeOf($Doc);
        $Out['disk0'] = $Out['disk0'] / SizeOf($Doc);
        
        Debug("[system/libs/VmManager5_KVM.php]: usage for " . $Settings['Address'] . " is " . $Out['cpuu'] ."/". $Out['memu'] ."/". $Out['swapu'] ."/". $Out['disk0']);
        return ($Out['cpuu'] + $Out['memu'] + $Out['swapu'] + $Out['disk0']);
	#-----------------------------------------------------------------------------
}

# added by lissyara, 2012-02-02 in 21:53 MSK
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
function VmManager5_KVM_CheckIsActive($Settings,$Login){
	/******************************************************************************/
	$__args_types = Array('array','string');
	#-------------------------------------------------------------------------------
	$__args__ = Func_Get_Args(); Eval(FUNCTION_INIT);
	/******************************************************************************/
	$VMs = VmManager5_KVM_GetVm($Settings);
	#-------------------------------------------------------------------------------
	if(SizeOf($VMs) < 1)
		return new gException('VmManager5_KVM_CheckIsActive','Не удалось получить список виртуальных машин');
	#-------------------------------------------------------------------------------
	foreach($VMs as $VM)
		if(IsSet($VM['id']))
			if($VM['name'] == $Login)
				if(IsSet($VM['vmpowered']) && $VM['vmpowered'] == 'off')
					if(IsSet($VM['vmstatus']) && $VM['vmstatus'] == 'admdown')
						return FALSE;
	#-----------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	// машина(-ы?) активна
	#Debug(SPrintF("[system/libs/VmManager5_KVM]: %s is enabled, disabled not by administrator, or not found",$Login));
	return TRUE;
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
}

# added by lissyara, 2012-02-03 in 09:59 MSK
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
function VmManager5_KVM_Reboot($Settings,$Login){
	/******************************************************************************/
	$__args_types = Array('array','string');
	#-------------------------------------------------------------------------------
	$__args__ = Func_Get_Args(); Eval(FUNCTION_INIT);
	/******************************************************************************/
	# проверяем - активна ли машина, а то если задизабленную ребутнуть - она включается
	if(!VmManager5_KVM_CheckIsActive($Settings,$Login)){
		#-------------------------------------------------------------------------------
		return new gException('ACCOUNT_REBOOT_ERROR_IsDisabled','Не удалось перезагрузить виртуальный сервер - он выключен администратором');
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	$VMs = VmManager5_KVM_GetVm($Settings,$Login);
	#-------------------------------------------------------------------------------
	if(SizeOf($VMs) < 1)
		return new gException('VmManager5_KVM_Reboot','Не удалось получить список виртуальных машин пользователя');
	#-------------------------------------------------------------------------------
	foreach($VMs as $VM){
		#-------------------------------------------------------------------------------
		#Debug(SPrintF('[system/libs/VmManager5_KVM]: VM = %s',print_r($VM,true)));
		if(!IsSet($VM['id']))
			continue;
		#-------------------------------------------------------------------------------
		#-------------------------------------------------------------------------------
		$Request = Array('func'=>'vm.restart','elid'=>$VM['id']);
		#-------------------------------------------------------------------------------
		$XML = VmManager5_KVM_Request($Settings,$Request);
		#-------------------------------------------------------------------------------
		$Doc = $XML['doc'];
		#-------------------------------------------------------------------------------
		if(IsSet($Doc['error']))
			return new gException('ACCOUNT_REBOOT_ERROR','Не удалось перезагрузить виртуальный сервер');
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	return TRUE;
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
}

# added by lissyara, 2013-05-17 in 09:53 MSK, for JBS-280
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
function VmManager5_KVM_Get_Users($Settings){
	/****************************************************************************/
	$__args_types = Array('array');
	#-----------------------------------------------------------------------------
	$__args__ = Func_Get_Args(); Eval(FUNCTION_INIT);
	/****************************************************************************/
	$Request = Array('func'=>'user');
	#-------------------------------------------------------------------------------
	$XML = VmManager5_KVM_Request($Settings,$Request,'elem');
	#-----------------------------------------------------------------------------
	$Users = $XML['doc'];
	#-----------------------------------------------------------------------------
	if(IsSet($Users['error']))
		return new gException('GET_USERS_ERROR',$Users['error']);
	#-----------------------------------------------------------------------------
	$Result = Array();
	#-----------------------------------------------------------------------------
	foreach($Users as $User){
		#---------------------------------------------------------------------------
		if(!IsSet($User['id']))
			continue;
		#---------------------------------------------------------------------------
		if(!IsSet($User['name']))
			continue;
		#---------------------------------------------------------------------------
		if($User['name'] != $Settings['Login'])
			$Result[] = $User['name'];
		#-----------------------------------------------------------------------------
	}
	#-----------------------------------------------------------------------------
	#-----------------------------------------------------------------------------
	return $Result;
	#-----------------------------------------------------------------------------
}

#-----------------------------------------------------------------------------
#-----------------------------------------------------------------------------
function VmManager5_KVM_Get_DiskTemplates($Settings){
	/****************************************************************************/
	$__args_types = Array('array');
	#-----------------------------------------------------------------------------
	$__args__ = Func_Get_Args(); Eval(FUNCTION_INIT);
	/****************************************************************************/
	$Request = Array('func'=>'osmgr');
	#-------------------------------------------------------------------------------
	$XML = VmManager5_KVM_Request($Settings,$Request,'elem');
	#-----------------------------------------------------------------------------
	$Templates = $XML['doc'];
	#-----------------------------------------------------------------------------
	if(IsSet($Templates['error']))
		return new gException('GET_TEMPLATES_ERROR',$Templates['error']);
	#-----------------------------------------------------------------------------
	$Result = Array();
	#-----------------------------------------------------------------------------
	// может не быть соединения
	if(!$Templates)
		return $Result;
	#-----------------------------------------------------------------------------
	foreach($Templates as $Template){
		#-----------------------------------------------------------------------------
		if(!IsSet($Template['id']))
			continue;
		#-----------------------------------------------------------------------------
		if(!IsSet($Template['name']))
			continue;
		#-----------------------------------------------------------------------------
		if(!IsSet($Template['installed']) || $Template['installed'] != 'on')
			continue;
		#-----------------------------------------------------------------------------
		if($Template['restrict'] != 'off')
			continue;
		#-----------------------------------------------------------------------------
		$Result[] = $Template['name'];
		#-----------------------------------------------------------------------------
	}
	#-----------------------------------------------------------------------------
	#-----------------------------------------------------------------------------
	return $Result;
	#-----------------------------------------------------------------------------
	#-----------------------------------------------------------------------------
}

#-----------------------------------------------------------------------------
#-----------------------------------------------------------------------------
function VmManager5_KVM_Get_NodeList($Settings){
	/****************************************************************************/
	$__args_types = Array('array');
	#-----------------------------------------------------------------------------
	$__args__ = Func_Get_Args(); Eval(FUNCTION_INIT);
	/****************************************************************************/
	$Request = Array('func'=>'vmhostnode');
	#-------------------------------------------------------------------------------
	$XML = VmManager5_KVM_Request($Settings,$Request,'elem');
	#-----------------------------------------------------------------------------
	$Nodes = $XML['doc'];
	#-----------------------------------------------------------------------------
	if(IsSet($Nodes['error']))
		return new gException('GET_LIST_NODES_ERROR',$Templates['error']);
	#-----------------------------------------------------------------------------
	$Result = Array();
	#-----------------------------------------------------------------------------
	foreach($Nodes as $Node){
		#-----------------------------------------------------------------------------
		if(!IsSet($Node['id']))
			continue;
		#-----------------------------------------------------------------------------
		if(!IsSet($Node['name']))
			continue;
		#-----------------------------------------------------------------------------
		if(!IsSet($Node['online']) || $Node['online'] != 'on')
			continue;
		#-----------------------------------------------------------------------------
		// если на ноде проблемы, и создание виртуалок невозможно - пропускаем её
		if(IsSet($Node['problem'])){
			#-----------------------------------------------------------------------------
			Debug(SPrintF('[VmManager5_KVM_Get_NodeList]: нода %s пропущена, на ней проблемы',$Node['name']));
			#-----------------------------------------------------------------------------
			continue;
			#-----------------------------------------------------------------------------
		}
		// рассчитываем использование. тупо %память + %диск
		$Node['DiskMemUsage'] = IntVal($Node['meminfo']) + IntVal($Node['storageinfo']);
		#-----------------------------------------------------------------------------
		$Result[$Node['name']] = $Node;
		#-----------------------------------------------------------------------------
	}
	#-----------------------------------------------------------------------------
	#-----------------------------------------------------------------------------
	// функция сортировки
	if(!Function_Exists('CMP')){
		#-----------------------------------------------------------------------------
		function CMP($a, $b){
			#-----------------------------------------------------------------------------
			//return ($a['DiskMemUsage'] > $b['DiskMemUsage']);
			return ($a['DiskMemUsage'] > $b['DiskMemUsage'])?$b['DiskMemUsage']:$a['DiskMemUsage'];
			#-----------------------------------------------------------------------------
		}
		#-----------------------------------------------------------------------------
	}
	#-----------------------------------------------------------------------------
	#-----------------------------------------------------------------------------
	// сортируем ноды по использованю, чем меньше - там первее.
	// удобно - при поиске ноды просто берём первую - и это самая незагруженная
	UASort($Result,'CMP');
	#-----------------------------------------------------------------------------
	#-----------------------------------------------------------------------------
	return $Result;
	#-----------------------------------------------------------------------------
	#-----------------------------------------------------------------------------
}

#-----------------------------------------------------------------------------
#-----------------------------------------------------------------------------
// added by lissyara, 2019-10-21 in 08:56 MSK
// для реализации процесса миграции между нодами, да и много где используется этот код
function VmManager5_KVM_GetVm($Settings,$Login = FALSE){
	/******************************************************************************/
	$__args_types = Array('array','string');
	#-------------------------------------------------------------------------------
	$__args__ = Func_Get_Args(); Eval(FUNCTION_INIT);
	/******************************************************************************/
	// массив параметров
	$Request = Array('func'=>'vm');
	#-------------------------------------------------------------------------------
	// если логин задан - машинка(-и?) конкретного юзера, если не задан - список всех машин
	if($Login)
		$Request['su'] = $Login;
	#-------------------------------------------------------------------------------
	$XML = VmManager5_KVM_Request($Settings,$Request,'elem');
	#-------------------------------------------------------------------------------
	$Doc = $XML['doc'];
	if(IsSet($Doc['error']))
		return new gException('VmManager5_KVM_GetVm','Не удалось получить список виртуальных машин');
	#-------------------------------------------------------------------------------
	// выхлопной массив
	$Out = Array();
	#-------------------------------------------------------------------------------
	foreach($Doc as $VM){
		#-------------------------------------------------------------------------------
		#Debug(SPrintF('[system/libs/VmManager5_KVM]: VM = %s',print_r($VM,true)));
		if(!IsSet($VM['id']))
			continue;
		#-------------------------------------------------------------------------------
		$Out[$VM['id']] = $VM;
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	return $Out;
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
}

#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
// added by lissyara, 2019-10-22 in 13:41 MSK
// миграция между нодами
function VmManager5_KVM_VmMigrate($Settings,$ID,$Node){
	/******************************************************************************/
	$__args_types = Array('array','integer','integer');
	#-------------------------------------------------------------------------------
	$__args__ = Func_Get_Args(); Eval(FUNCTION_INIT);
	/******************************************************************************/
	$Request = Array('func'=>'vm.migrate','elid'=>$ID,'destination'=>$Node,'live'=>'on','sok'=>'ok');
	#-------------------------------------------------------------------------------
	$XML = VmManager5_KVM_Request($Settings,$Request,'elem');
	#-------------------------------------------------------------------------------
	$Doc = $XML['doc'];
	if(IsSet($Doc['error']))
		return new gException('VmManager5_KVM_VmMigrate','Не удалось запустить миграцию витруальной машины');
	#-------------------------------------------------------------------------------
	#Debug(SPrintF('[system/libs/VmManager5_KVM]: XML = %s',print_r($XML,true)));
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	return TRUE;
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
}




#-----------------------------------------------------------------------------
#-----------------------------------------------------------------------------
# внутренняя функция
function VmManager5_KVM_Request($Settings,$Request,$Name = FALSE){
	/******************************************************************************/
	$__args_types = Array('array','array','boolean,string');
	#-----------------------------------------------------------------------------
	$__args__ = Func_Get_Args(); Eval(FUNCTION_INIT);
	/******************************************************************************/
	$authinfo = SPrintF('%s:%s',$Settings['Login'],$Settings['Password']);
	#-------------------------------------------------------------------------------
	$HTTP = Array(
			'Address'	=> $Settings['Params']['IP'],
			'Port'		=> $Settings['Port'],
			'Host'		=> $Settings['Address'],
			'Protocol'	=> $Settings['Protocol'],
			'Hidden'	=> $authinfo,
			'IsLogging'	=> $Settings['Params']['IsLogging']
			);
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	$Request['out']		= 'xml';
	$Request['authinfo']	= $authinfo;
	#-------------------------------------------------------------------------------
	$Response = HTTP_Send('/vmmgr',$HTTP,Array(),$Request);
	if(Is_Error($Response))
		return ERROR | @Trigger_Error('[VmManager5_KVM_Request]: не удалось соедениться с сервером');
	#-------------------------------------------------------------------------------
	$Response = Trim($Response['Body']);
	#-------------------------------------------------------------------------------
	$XML = String_XML_Parse($Response);
	if(Is_Exception($XML))
		return new gException('WRONG_SERVER_ANSWER',$Response,$XML);
	#-------------------------------------------------------------------------------
	if($Name){
		#-------------------------------------------------------------------------------
		$XML = $XML->ToArray($Name);
		#-------------------------------------------------------------------------------
	}else{
		#-------------------------------------------------------------------------------
		$XML = $XML->ToArray();
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	return $XML;
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
}













?>
