<?php
#-------------------------------------------------------------------------------
/** @author Alex Keda, for www.host-food.ru */
/* VDS functions written by lissyara, for www.host-food.ru */
#-------------------------------------------------------------------------------
if(Is_Error(System_Load('libs/HTTP.php','classes/Net_IDNA.class.php')))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
function VmManager6_Hosting_Logon($Settings,$Params){
	/****************************************************************************/
	$__args_types = Array('array','array');
	#-----------------------------------------------------------------------------
	$__args__ = Func_Get_Args(); Eval(FUNCTION_INIT);
	/****************************************************************************/
	// авторизуемся в панели управления
	$HTTP = Array(
			'Address'	=> $Settings['Params']['IP'],
			'Port'		=> $Settings['Port'],
			'Host'		=> $Settings['Address'],
			'Protocol'	=> $Settings['Protocol'],
			'IsLogging'	=> $Settings['Params']['IsLogging']
			);
	#-------------------------------------------------------------------------------
	$Auth = Array(
			'email'		=> SPrintF('%s@%s',$Params['Login'],$Settings['Params']['Domain']),
			'password'	=> $Params['Password']
			);
	#-------------------------------------------------------------------------------
	# https://docs.ispsystem.ru/vmmanager-admin/razrabotchiku/rabota-s-api
	# Сквозная авторизация по ключу
	$Response = HTTP_Send('/api/auth/v4/public/token',$HTTP,Array(),Json_Encode(Array('email'=>$Settings['Login'],'password'=>$Settings['Password'])));
	if(Is_Error($Response))
		return ERROR | @Trigger_Error('[VmManager6_Hosting_Logon]: не удалось соедениться с сервером, #1');
	#-------------------------------------------------------------------------------
	$Response = Trim($Response['Body']);
	#-------------------------------------------------------------------------------
	if(!$JSON = Json_Decode($Response,TRUE))
		return new gException('WRONG_SERVER_AUTH_ANSWER','не удалось соедениться с сервером, #1');
	#-------------------------------------------------------------------------------
	// бывает с ошибкой логинится, спим и пробуем ещё раз
	if(IsSet($JSON['error'])){
		#-------------------------------------------------------------------------------
		Sleep(1);
		#-------------------------------------------------------------------------------
		$Response = HTTP_Send('/api/auth/v4/public/token',$HTTP,Array(),Json_Encode(Array('email'=>$Settings['Login'],'password'=>$Settings['Password'])));
		if(Is_Error($Response))
			return ERROR | @Trigger_Error('[VmManager6_Hosting_Logon]: не удалось соедениться с сервером, #2');
		#-------------------------------------------------------------------------------
		$Response = Trim($Response['Body']);
		#-------------------------------------------------------------------------------
		if(!$JSON = Json_Decode($Response,TRUE))
			return new gException('WRONG_SERVER_AUTH_ANSWER_2','не удалось соедениться с сервером, #2');
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	// залогинились или нет?
	if(!IsSet($JSON['id']))
		return new gException('CANNOT_SERVER_AUTH','не удалось авторизоваться');
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	// получаем ключ юзера
	$Headers = Array(SPrintF('x-xsrf-token: %s',$JSON['token']),'isp-box-instance: true');
	#-------------------------------------------------------------------------------
	$Response = HTTP_Send(SPrintF('/api/auth/v4/user/%s@%s/key',$Params['Login'],$Settings['Params']['Domain']),$HTTP,Array(),'{}',$Headers);
	if(Is_Error($Response))
		return ERROR | @Trigger_Error('[VmManager6_Hosting_Logon]: не удалось получить ключ');
	#-------------------------------------------------------------------------------
	$Response = Trim($Response['Body']);
	#-------------------------------------------------------------------------------
	if(!$JSON = Json_Decode($Response,TRUE))
		return new gException('WRONG_SERVER_AUTH_ANSWER_2','не удалось получить ключ');
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	// не смог врезать в JS выставление куки, поэтому ставим на главный домен
        list($d1,$d2) = Array_Reverse(Explode('.',$Settings['Address']));
	#-------------------------------------------------------------------------------
	// куку втыкаем про язык
	SetCookie('lang6',$Settings['Params']['Language'],Time() + 24*3600,'/',SPrintF('%s.%s',$d2,$d1));
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	return Array('Url'=>SPrintF('%s/auth/key/%s',$Settings['Params']['Url'],$JSON['key']),'Args'=>Array(),'Method'=>'GET');
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
}

#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
function VmManager6_Hosting_Get_Domains($Settings){
	/******************************************************************************/
	$__args_types = Array('array','array','string','array');
	#-------------------------------------------------------------------------------
	$__args__ = Func_Get_Args(); Eval(FUNCTION_INIT);
	/******************************************************************************/
	// достаём список виртуалок
	$Settings['function']	= 'host';
	#-------------------------------------------------------------------------------
	$Doc = VmManager6_Hosting_Request($Settings);
	#-------------------------------------------------------------------------------
	if(!Is_Exception($Doc) && IsSet($Doc['error']))
		return new gException('VmManager6_Hosting_Get_Domains','Не удалось получить список VM');
	#-------------------------------------------------------------------------------
	$Users = Array();
	#-------------------------------------------------------------------------------
	//Debug(SPrintF('[VmManager6_Hosting_Get_Domains]: Doc = %s',print_r($Doc,true)));
	foreach($Doc['list'] as $Vm){
		#-------------------------------------------------------------------------------
		// у виртуалки не задан шаблон
		if(!IsSet($Vm['os_name']))
			continue;
		#-------------------------------------------------------------------------------
		// у виртуалки не задан владелец
		if(!IsSet($Vm['account']['email']))
			continue;
		#-------------------------------------------------------------------------------
		// не задан домен (обратная зона первого адреса)
		if(!IsSet($Vm['domain']))
			continue;
		#-------------------------------------------------------------------------------
		list($User,$Domain) = Explode('@',$Vm['account']['email']);
		#-------------------------------------------------------------------------------
		$Users[$User] = Array($Vm['os_name'],$Vm['domain']);
		#-------------------------------------------------------------------------------
        }
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	return $Users;
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
}

#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
function VmManager6_Hosting_Create($Settings,$VPSOrder,$IP,$VPSScheme){
	/******************************************************************************/
	$__args_types = Array('array','array','string','array');
	#-------------------------------------------------------------------------------
	$__args__ = Func_Get_Args(); Eval(FUNCTION_INIT);
	/******************************************************************************/
	$IDNA = new Net_IDNA();
	#-------------------------------------------------------------------------------
	$Domain = $IDNA->encode($VPSOrder['Domain']);
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	$Login = SPrintF('%s@%s',$VPSOrder['Login'],$Settings['Params']['Domain']);
	#-------------------------------------------------------------------------------
	Debug(SPrintF('[VmManager6_Hosting_Create]: VPSScheme[Node] = ',$VPSScheme['Node']));
	# проверяем наличие такого юзера
	if($User = VmManager6_Hosting_Get_Users($Settings,$VPSOrder['Login'])){
		#-------------------------------------------------------------------------------
		Debug(SPrintF('[VmManager6_Hosting_Create]: юзер %s найден, проверяем его виртуалки',$VPSOrder['Login']));
		#-------------------------------------------------------------------------------
		$VmUserID = $User['id'];
		#-------------------------------------------------------------------------------
		#-------------------------------------------------------------------------------
		# проверяем есть ли у него виртуалки
		$VMs = VmManager6_Hosting_GetVm($Settings,$VPSOrder['Login']);
		#-------------------------------------------------------------------------------
		if(SizeOf($VMs) > 0)
			return new gException('VmManager6_Hosting_Create','Пользователь уже существует, и у него есть хоть одна виртуальная машина');
		#-------------------------------------------------------------------------------
	}else{
		#-------------------------------------------------------------------------------
		Debug(SPrintF('[VmManager6_Hosting_Create]: юзер %s НЕ найден, созадём его',$Login));
		#-------------------------------------------------------------------------------
		$Settings['function']	= 'account';
		#-------------------------------------------------------------------------------
		# создаём юзера
		$Request = Array(
				'email'			=> $Login,
				'password'		=> $VPSOrder['Password'],
				'role'			=> '@user'
				);
		#-------------------------------------------------------------------------------
		$Doc = VmManager6_Hosting_Request($Settings,$Request);
		#-------------------------------------------------------------------------------
		#-------------------------------------------------------------------------------
		if(IsSet($Doc['error']))
			return new gException('USER_ACCOUNT_CREATE_ERROR','Не удалось создать пользователя для виртуального сервера');
		#-------------------------------------------------------------------------------
		if(!IsSet($Doc['id']))
			return new gException('USER_ID_MISSING','Отсутствует идентификатор созданного пользователя');
		#-------------------------------------------------------------------------------
		$VmUserID = $Doc['id'];
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	# достаём список шаблонов VM, нам нужен числовой идентфиикатор указанного шаблона
	$Settings['function']	= 'preset';
	#-------------------------------------------------------------------------------
	$Doc = VmManager6_Hosting_Request($Settings);
	#-------------------------------------------------------------------------------
	foreach($Doc['list'] as $Preset){
		#------------------------------------------------------------------------------
		if(!IsSet($Preset['id']))
			continue;
		#------------------------------------------------------------------------------
		if($Preset['name'] == $VPSScheme['SchemeParams']['preset'])
			$VmPresetID = $Preset['id'];
		#------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	if(!IsSet($VmPresetID))
		Debug(SPrintF('[VmManager6_Hosting_Create]: шаблон "%s" не найден в шаблонах на KVMmgr, виртуалка будет создана без шаблона',$VPSScheme['SchemeParams']['preset']));
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	// достаём необходимый кластер
	$ClusterID = VmManager6_Hosting_Get_Clusters($Settings,$VPSScheme['SchemeParams']['cluster']);
	#-------------------------------------------------------------------------------
	// достаём ноду
	$NodeID = VmManager6_Hosting_Get_Node($Settings,$VPSScheme['Node']);
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	// шаблон
	$DiskTemplate = VmManager6_Hosting_Get_DiskTemplates($Settings,Trim($VPSOrder['DiskTemplate']));
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	$Storage = VmManager6_Hosting_Get_Storage($Settings,$VPSScheme['SchemeParams']['storage']);
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	$Request = Array();
	#-------------------------------------------------------------------------------
	// считываем XML и составляем запрос
	$Fields = System_XML(SPrintF('config/Schemes.%s.xml',$VPSScheme['SchemeParams']['SystemID']));
	if(Is_Error($Fields))
		return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------------
	foreach(Array_Keys($Fields) as $Key){
		#-------------------------------------------------------------------------------
		$Field = $Fields[$Key];
		#-------------------------------------------------------------------------------
		$Value = IsSet($VPSScheme['SchemeParams'][$Key])?$VPSScheme['SchemeParams'][$Key]:$Field['Value'];
		#-------------------------------------------------------------------------------
		$Request[$Key] = $Value;
		#-------------------------------------------------------------------------------
		if(IsSet($Field['Min']))
			$Request[$Key] = IntVal($Value);
		#-------------------------------------------------------------------------------
		if(IsSet($Field['Type']) && $Field['Type'] == 'CheckBox')
			$Request[$Key] = ($Request[$Key])?TRUE:FALSE;
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	$Request['name']	= $VPSOrder['Login'];
	$Request['account']	= $VmUserID;
	$Request['domain']	= $VPSOrder['Domain'];
	$Request['os']		= $DiskTemplate;
	$Request['password']	= $VPSOrder['Password'];
	$Request['cluster']	= $ClusterID;
	$Request['node']	= $NodeID;
	$Request['storage']	= $Storage;
	#-------------------------------------------------------------------------------
	// шаблон
	if(IsSet($VmPresetID)){
		#-------------------------------------------------------------------------------
		$Request['preset'] = $VmPresetID;
		#-------------------------------------------------------------------------------
	}else{
		#-------------------------------------------------------------------------------
		UnSet($Request['preset']);
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	# создаём виртуалку
	$Settings['function']	= 'host';
	#-------------------------------------------------------------------------------
	$Doc = VmManager6_Hosting_Request($Settings,$Request);
	#-------------------------------------------------------------------------------
	if(IsSet($Doc['error']))
		return new gException('ACCOUNT_CREATE_ERROR','Не удалось создать виртуальный сервер');
	#-------------------------------------------------------------------------------
        if(!IsSet($Doc['id']))
		return new gException('VM_ID_MISSING','Отсутствует идентификатор созданной виртуальной машины');
	#-------------------------------------------------------------------------------
	$VmID = $Doc['id'];
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	$Settings['AddOn']	= SPrintF('%s/iface',$VmID);
	#-------------------------------------------------------------------------------
	$Doc = VmManager6_Hosting_Request($Settings);
	#-------------------------------------------------------------------------------
        if(!IsSet($Doc['list'][0]['ip'][0]))
		return new gException('VM_IP_MISSING','Отсутствует IP созданной виртуальной машины');
	#-------------------------------------------------------------------------------
	Debug(SPrintF('[system/libs/VmManager6_Hosting]: VPS order created with IP = %s',$Doc['list'][0]['ip'][0]));
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	return Array('ID'=>$VPSOrder['ID'],'IP'=>$Doc['list'][0]['ip'][0]);
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
}

#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
function VmManager6_Hosting_Active($Settings,$Login){
	/******************************************************************************/
	$__args_types = Array('array','string');
	#-------------------------------------------------------------------------------
	$__args__ = Func_Get_Args(); Eval(FUNCTION_INIT);
	/******************************************************************************/
	# достаём данные виртуалки
	$VMs = VmManager6_Hosting_GetVm($Settings,$Login);
	#-------------------------------------------------------------------------------
	if(SizeOf($VMs) < 1)
		return new gException('VmManager6_Hosting_Active','Не удалось получить список виртуальных машин пользователя');
	#-------------------------------------------------------------------------------
	foreach($VMs as $VM){
		#-------------------------------------------------------------------------------
		$Settings['function']	= 'host';
		$Settings['AddOn']	= SPrintF('%s/start',$VM['id']);
		$Settings['Method']	= 'POST';
		#-------------------------------------------------------------------------------
		$Doc = VmManager6_Hosting_Request($Settings);
		#-------------------------------------------------------------------------------
		if(!IsSet($Doc['id']))
			return new gException('VM_START_ERROR','Не удалось включить виртуальный сервер');
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	// включаем самого юзера
	UnSet($Settings['function']);UnSet($Settings['AddOn']);UnSet($Settings['Method']);
	#-------------------------------------------------------------------------------
	# достаём пользователя
	if(!$User = VmManager6_Hosting_Get_Users($Settings,$Login))
		return new gException('VmManager6_Hosting_Active',SPrintF('Не удалось найти полльзователя "%s"',$Login));
	#-------------------------------------------------------------------------------
	$Settings['function']	= 'user';
	$Settings['AddOn']	= SPrintF('%s/resume',$User['id']);
	$Settings['Method']	= 'POST';
	#-------------------------------------------------------------------------------
	$Doc = VmManager6_Hosting_Request($Settings);
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	return TRUE;
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
}

#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
function VmManager6_Hosting_Suspend($Settings,$Login,$VPSScheme){
	/******************************************************************************/
	$__args_types = Array('array','string','array');
	#-------------------------------------------------------------------------------
	$__args__ = Func_Get_Args(); Eval(FUNCTION_INIT);
	/******************************************************************************/
	# достаём данные виртуалки
	$VMs = VmManager6_Hosting_GetVm($Settings,$Login);
	#-------------------------------------------------------------------------------
	if(SizeOf($VMs) < 1)
		return new gException('VmManager6_Hosting_Suspend','Не удалось получить список виртуальных машин пользователя');
	#-------------------------------------------------------------------------------
	foreach($VMs as $VM){
		#-------------------------------------------------------------------------------
		$Settings['function']	= 'host';
		$Settings['AddOn']	= SPrintF('%s/stop',$VM['id']);
		$Settings['Method']	= 'POST';
		#-------------------------------------------------------------------------------
		$Doc = VmManager6_Hosting_Request($Settings);
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	// выключаем самого юзера чтоб не шарились по панели
	UnSet($Settings['function']);UnSet($Settings['AddOn']);UnSet($Settings['Method']);
	#-------------------------------------------------------------------------------
	if(!$User = VmManager6_Hosting_Get_Users($Settings,$Login))
		return new gException('VmManager6_Hosting_Suspend',SPrintF('Не удалось найти полльзователя "%s"',$Login));
	#-------------------------------------------------------------------------------
	$Settings['function']	= 'user';
	$Settings['AddOn']	= SPrintF('%s/suspend',$User['id']);
	$Settings['Method']	= 'POST';
	#-------------------------------------------------------------------------------
	$Doc = VmManager6_Hosting_Request($Settings);
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	return TRUE;
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
}

#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
function VmManager6_Hosting_Delete($Settings,$Login){
	/******************************************************************************/
	$__args_types = Array('array','string','array');
	#-------------------------------------------------------------------------------
	$__args__ = Func_Get_Args(); Eval(FUNCTION_INIT);
	/******************************************************************************/
	# проверяем, возможно такого уже и нету
	if($User = VmManager6_Hosting_Get_Users($Settings,$Login)){
		#-------------------------------------------------------------------------------
		$VmUserID = $User['id'];
		#-------------------------------------------------------------------------------
		Debug(SPrintF('[VmManager6_Hosting_Delete]: найден пользователь Login = %s; User = %s ',$Login,print_r($User,TRUE)));
		#-------------------------------------------------------------------------------
	}else{
		#-------------------------------------------------------------------------------
		//Debug(SPrintF('[VmManager6_Hosting_Delete]: пользователь %s уже удалён ',$Login));
		#-------------------------------------------------------------------------------
		return TRUE;
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	// ввиду явных проблем, пробегаемся по виртуалкам дважды
	for ($i = 1; $i <= 2; $i++){
		#-------------------------------------------------------------------------------
		$VMs = VmManager6_Hosting_GetVm($Settings,$Login);
		#-------------------------------------------------------------------------------
		//Debug(SPrintF('[VmManager6_Hosting_Delete]: VMs = %s',print_r($VMs,true)));
		foreach($VMs as $VM){
			#-------------------------------------------------------------------------------
			//Debug(SPrintF('[VmManager6_Hosting_Delete]: VM = %s',print_r($VM,true)));
			if(!IsSet($VM['id']))
				continue;
			#-------------------------------------------------------------------------------
			$Settings['function']	= 'host';
			$Settings['AddOn']	= $VM['id'];
			$Settings['Method']	= 'DELETE';
			#-------------------------------------------------------------------------------
			$Doc = VmManager6_Hosting_Request($Settings);
			#-------------------------------------------------------------------------------
			// реально диск удалить не успевает и последующее удаление юзера падает в ошибку
			Sleep(30);
			#-------------------------------------------------------------------------------
		}
		#-------------------------------------------------------------------------------
		Sleep(30);
		#-------------------------------------------------------------------------------
	}
	#------------------------------------------------------------------------------
	#------------------------------------------------------------------------------
	# грохаем самого юзера
	$Settings['function']	= 'user';
	$Settings['AddOn']	= $VmUserID;
	$Settings['Method']	= 'DELETE';
	#-------------------------------------------------------------------------------
	$Doc = VmManager6_Hosting_Request($Settings);
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	return TRUE;
	#-------------------------------------------------------------------------------
	#------------------------------------------------------------------------------
}

#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
function VmManager6_Hosting_Scheme_Change($Settings,$VPSOrder,$VPSScheme){
	/******************************************************************************/
	$__args_types = Array('array','array','array');
	#-------------------------------------------------------------------------------
	$__args__ = Func_Get_Args(); Eval(FUNCTION_INIT);
	/******************************************************************************/
	// запрос, массив параметров
	$Request = $Request1 = Array();
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	# достаём пользователя
	if(!$User = VmManager6_Hosting_Get_Users($Settings,$VPSOrder['Login']))
		return new gException('VmManager6_Hosting_Scheme_Change',SPrintF('Не удалось найти полльзователя "%s"',$VPSOrder['Login']));
	#-------------------------------------------------------------------------------
	$UserID = $User['id'];
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	$VMs = VmManager6_Hosting_GetVm($Settings,$VPSOrder['Login']);
	#-------------------------------------------------------------------------------
	if(SizeOf($VMs) < 1)
		return new gException('VmManager6_Hosting_Scheme_Change','Не удалось получить список виртуальных машин пользователя');
	#-------------------------------------------------------------------------------
	foreach($VMs as $VM){
		#-------------------------------------------------------------------------------
		//Debug(SPrintF('[system/libs/VmManager6_Hosting]: VM = %s',print_r($VM,true)));
		#-------------------------------------------------------------------------------
		$Fields = System_XML(SPrintF('config/Schemes.%s.xml',$VPSScheme['SchemeParams']['SystemID']));
		if(Is_Error($Fields))
			return ERROR | @Trigger_Error(500);
		#-------------------------------------------------------------------------------
		foreach(Array_Keys($Fields) as $Key){
			#-------------------------------------------------------------------------------
			$Field = $Fields[$Key];
			#-------------------------------------------------------------------------------
			if(!$Field['IsSchemeChange'])
				continue;
			#-------------------------------------------------------------------------------
			#-------------------------------------------------------------------------------
			$Value = IsSet($VPSScheme['SchemeParams'][$Key])?$VPSScheme['SchemeParams'][$Key]:$Field['Value'];
			#-------------------------------------------------------------------------------
			// затычка для снимков, они в другом АПИ меняются
			$VarName = Preg_Match('/snapshot/',$Key)?'Request1':'Request';
			$$VarName[$Key] = $Value;
			#-------------------------------------------------------------------------------
			if(IsSet($Field['Min']))
				$$VarName[$Key] = IntVal($Value);
			#-------------------------------------------------------------------------------
			if(IsSet($Field['Type']) && $Field['Type'] == 'CheckBox')
				$$VarName[$Key] = ($$VarName[$Key])?TRUE:FALSE;
			#-------------------------------------------------------------------------------
		}
		#-------------------------------------------------------------------------------
		#-------------------------------------------------------------------------------
		// /host/{host_id}
		$Settings['function']	= 'host';
		$Settings['AddOn']	= $VM['id'];
		#-------------------------------------------------------------------------------
		$Doc = VmManager6_Hosting_Request($Settings,$Request1);
		#-------------------------------------------------------------------------------
		// на всякий случай....
		Sleep(10);
		#-------------------------------------------------------------------------------
		#-------------------------------------------------------------------------------
		// /host/{host_id}/resource
		$Settings['function']	= 'host';
		$Settings['AddOn']	= SPrintF('%s/resource',$VM['id']);
		#-------------------------------------------------------------------------------
		$Doc = VmManager6_Hosting_Request($Settings,$Request);
		#-------------------------------------------------------------------------------
		#-------------------------------------------------------------------------------
		// на всякий случай....
		Sleep(120);
		#-------------------------------------------------------------------------------
		// запоминаем статус машины (чтобы не запустить остановленную по каким-то причинам, например, админ прям с сервера залочил)
		$Power = ($VM['state'] == 'active')?TRUE:FALSE;
		#-------------------------------------------------------------------------------
		# меняем размер диска
		#-------------------------------------------------------------------------------
		if(!IsSet($VM['disk']['id']))
			continue;
		#-------------------------------------------------------------------------------
		// проверяем размер дисков. если они одинаковые - перезагружать и трогать их не надо
		if($VM['disk']['disk_mib'] == $VPSScheme['SchemeParams']['hdd_mib'])
			continue;
		#-------------------------------------------------------------------------------
		// ещё вариант - диск оказался больше чем необходимо. с этим тоже ничего не сделаешь.
		// KVM не позволяет уменьшать диск - либо пропустить, либо в ошибку падать. лучше пропустить, наверное...
		if($VM['disk']['disk_mib'] > $VPSScheme['SchemeParams']['hdd_mib']){
			#-------------------------------------------------------------------------------
			Debug(SPrintF('[VmManager6_Hosting_Scheme_Change]: Невозможно изменить размер диска в меньшую сторону (%s->%s) пропускаем',$VPSScheme['SchemeParams']['hdd_mib'],$VM['disk']['disk_mib']));
			#-------------------------------------------------------------------------------
			continue;
			#-------------------------------------------------------------------------------
		}
		#-------------------------------------------------------------------------------
		$Settings['function']	= 'disk';
		$Settings['AddOn']	= $VM['disk']['id'];
		#-------------------------------------------------------------------------------
		$Doc = VmManager6_Hosting_Request($Settings,Array('size_mib'=>Ceil($VPSScheme['SchemeParams']['hdd_mib'])));
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	return TRUE;
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
}

#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
function VmManager6_Hosting_Password_Change($Settings,$Login,$Password,$Params){
	/******************************************************************************/
	$__args_types = Array('array','string','string','array');
	#-------------------------------------------------------------------------------
	$__args__ = Func_Get_Args(); Eval(FUNCTION_INIT);
	/******************************************************************************/
	// сохраняем оригинал настроек
	$SettingsOrig = $Settings;
	#-------------------------------------------------------------------------------
	# достаём пользователя
	if(!$User = VmManager6_Hosting_Get_Users($SettingsOrig,$Login))
		return new gException('VmManager6_Hosting_Password_Change',SPrintF('Не удалось найти полльзователя "%s"',$Login));
	#-------------------------------------------------------------------------------
	$Settings['function']	= 'user';
	$Settings['AddOn']	= SPrintF('%s/password',$User['id']);
	#-------------------------------------------------------------------------------
	$Doc = VmManager6_Hosting_Request($Settings,Array('password'=>$Password));
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	// достаём виртуалки
	$VMs = VmManager6_Hosting_GetVm($SettingsOrig,$Login);
	#-------------------------------------------------------------------------------
	//Debug(SPrintF('[VmManager6_Hosting_Password_Change]: VMs = %s',print_r($VMs,true)));
	if(SizeOf($VMs) < 1)
		return new gException('VmManager6_Hosting_Password_Change','Не удалось получить список виртуальных машин пользователя');
	#-------------------------------------------------------------------------------
	foreach($VMs as $VM){
		#-------------------------------------------------------------------------------
		//Debug(SPrintF('[VmManager6_Hosting_Password_Change]: VM = %s',print_r($VM,true)));
		if(!IsSet($VM['id']))
			continue;
		#-------------------------------------------------------------------------------
		Sleep(1);
		#-------------------------------------------------------------------------------
		$Settings = $SettingsOrig;
		#-------------------------------------------------------------------------------
		#-------------------------------------------------------------------------------
		$Settings['function']	= 'host';
		$Settings['AddOn']	= SPrintF('%s/password',$VM['id']);
		#-------------------------------------------------------------------------------
		$Doc = VmManager6_Hosting_Request($Settings,Array('password'=>$Password));
		#-------------------------------------------------------------------------------
		//Debug('after pass change Doc = ' . print_r($Doc,true));
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	#{"id":300,"task":12109}
	# {"error":{"code":5992,"msg":"Qemu guest agent is not available on host"}}
	//Debug('VmManager6_Hosting_Password_Change, Doc = ' . print_r($Doc,true));
	switch(ValueOf($Doc)){
	case 'error':
		return new gException('PASSWORD_CHANGE_ERROR',$Doc->String);
	case 'exception':
		return new gException('PASSWORD_CHANGE_EXCEPTIONS',$Doc->String);
	case 'true':
		return TRUE;
	case 'array':
		return TRUE;
	default:
		return ERROR | @Trigger_Error(101);
	}
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
}

#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
# added by lissyara 2011-08-09 in 09:55 MSK
function VmManager6_Hosting_AddIP($Settings,$Login,$ID,$Domain,$IP,$AddressType){
	/****************************************************************************/
        $__args_types = Array('array','string','string','string','string','string');
	#-------------------------------------------------------------------------------
        $__args__ = Func_Get_Args(); Eval(FUNCTION_INIT);
	/****************************************************************************/
	# достаём список виртуалок
	$VMs = VmManager6_Hosting_GetVm($Settings,$Login);
	#-------------------------------------------------------------------------------
	if(SizeOf($VMs) < 1)
		return new gException('VmManager6_Hosting_AddIP','Не удалось получить список виртуальных машин пользователя');
	#-------------------------------------------------------------------------------
	if(SizeOf($VMs) > 1)
		return new gException('VmManager6_Hosting_AddIP','У пользователя более одной виртуальной машины, невозможно добавить IP адрес');
	#-------------------------------------------------------------------------------
	foreach($VMs as $VM){
		#-------------------------------------------------------------------------------
		#Debug(SPrintF('[system/libs/VmManager6_Hosting]: VM = %s',print_r($VM,true)));
		if(!IsSet($VM['id']))
			continue;
		#-----------------------------------------------------------------------------
		$Settings['function']	= 'host';
		$Settings['AddOn']	= SPrintF('%s/ip',$VM['id']);
		#-------------------------------------------------------------------------------
		$Doc = VmManager6_Hosting_Request($Settings,Array('ipv4_number'=>1));
		#-------------------------------------------------------------------------------
		// ждём и проверяем
		sleep(10);
		#-------------------------------------------------------------------------------
		// проверяем кривенько, через историю
		$Settings['function']	= 'host';
		$Settings['AddOn']	= SPrintF('%s/history',$VM['id']);
		#-------------------------------------------------------------------------------
		$Doc = VmManager6_Hosting_Request($Settings);
		#-------------------------------------------------------------------------------
		foreach($Doc['list'] as $History)
			if(IsSet($History['name']) && $History['name'] == 'ip_allocate')
				$NewIP = $History;
		#-------------------------------------------------------------------------------
		if(!IsSet($NewIP))
			return new gException('VmManager6_Hosting_AddIP','Ошибка добавления IP адреса, нет записи в истории');
		#-------------------------------------------------------------------------------
		#-------------------------------------------------------------------------------
		if(!IsSet($NewIP['params']['ip'][0]))
			return new gException('VmManager6_Hosting_AddIP','Ошибка добавления IP адреса, адрес не найден');
		#-------------------------------------------------------------------------------
		Debug(SPrintF('[VmManager6_Hosting_AddIP]: to VPS added IP = %s',$NewIP['params']['ip'][0]));
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	return Array('ID'=>$ID,'IP'=>$NewIP['params']['ip'][0]);
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
}

# added by lissyara 2011-08-09 in 13:03 MSK
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
function VmManager6_Hosting_DeleteIP($Settings,$ExtraIP){
	/******************************************************************************/
        $__args_types = Array('array','string');
	#-------------------------------------------------------------------------------
        $__args__ = Func_Get_Args(); Eval(FUNCTION_INIT);
	/******************************************************************************/
	# достаём список IP адресов
	$Settings['function']	= 'ip';
	#-------------------------------------------------------------------------------
	$Doc = VmManager6_Hosting_Request($Settings);
	#-------------------------------------------------------------------------------
	foreach($Doc['list'] as $IP){
		#-------------------------------------------------------------------------------
		if(!IsSet($IP['id']))
			continue;
		#-------------------------------------------------------------------------------
		if(!IsSet($IP['state']))
			continue;
		#-------------------------------------------------------------------------------
		if($IP['ip_addr'] == $ExtraIP){
			#-------------------------------------------------------------------------------
			// удаляем
			$Settings['function']	= 'ip';
			$Settings['AddOn']	= $IP['id'];
			$Settings['Method']	= 'DELETE';
			#-------------------------------------------------------------------------------
			$Doc = VmManager6_Hosting_Request($Settings);
			#-------------------------------------------------------------------------------
			Debug(SPrintF('[system/libs/VmManager6_Hosting]: IP адрес (%s) удалён с виртуальной машины (%s)',$ExtraIP,$IP['host']['name']));
			#-------------------------------------------------------------------------------
			#-------------------------------------------------------------------------------
			return TRUE;
			#-------------------------------------------------------------------------------
			#-------------------------------------------------------------------------------
		}
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	Debug(SPrintF('[system/libs/VmManager6_Hosting]: IP адрес (%s) не обнаружен ни на одной виртуальной машине',$ExtraIP));
        #------------------------------------------------------------------------------
	#------------------------------------------------------------------------------
	return TRUE;
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
}

# added by lissyara 2011-10-07 in 10:28 MSK
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
function VmManager6_Hosting_MainUsage($Settings){
	/******************************************************************************/
        $__args_types = Array('array');
        $__args__ = Func_Get_Args(); Eval(FUNCTION_INIT);
	/******************************************************************************/
	# TODO: надо сделать
	return rand(1,10);
	#-------------------------------------------------------------------------------
        $Request = Array(
                'func'          => 'mainusage',
                'sok'           => 'ok'
        );
        #Debug(var_export($Settings, true));
	#-----------------------------------------------------------------------------
	$XML = VmManager6_Hosting_Request($Settings,$Request);
        #-----------------------------------------------------------------------------
        $Doc = $XML['doc'];
        if(IsSet($Doc['error']))
                return new gException('VmManager6_Hosting_MainUsage','Не удалось получить нагрузку сервера');
        #---------------------------------------------------------------------------
        # перебираем, складываем
        $Out = Array(
                        'cpuu'  => 0,
                        'memu'  => 0,
                        'swapu' => 0,
                        'disk0' => 0
                );
        $NumStrings = SizeOf($Doc);
        foreach($Doc as $Usage){
                $Out['cpuu'] = $Out['cpuu'] + $Usage['cpuu'];
                $Out['memu'] = $Out['memu'] + $Usage['memu'];
                $Out['swapu'] = $Out['swapu'] + $Usage['swapu'];
                $Out['disk0'] = $Out['disk0'] + $Usage['disk0'];
        }
        # считаем средние значнеия
        $Out['cpuu'] = $Out['cpuu'] / SizeOf($Doc);
        $Out['memu'] = $Out['memu'] / SizeOf($Doc);
        $Out['swapu'] = $Out['swapu'] / SizeOf($Doc);
        $Out['disk0'] = $Out['disk0'] / SizeOf($Doc);
        
        Debug("[system/libs/VmManager6_Hosting.php]: usage for " . $Settings['Address'] . " is " . $Out['cpuu'] ."/". $Out['memu'] ."/". $Out['swapu'] ."/". $Out['disk0']);
        return ($Out['cpuu'] + $Out['memu'] + $Out['swapu'] + $Out['disk0']);
	#-----------------------------------------------------------------------------
}

# added by lissyara, 2012-02-02 in 21:53 MSK
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
function VmManager6_Hosting_CheckIsActive($Settings,$Login){
	/******************************************************************************/
	$__args_types = Array('array','string');
	#-------------------------------------------------------------------------------
	$__args__ = Func_Get_Args(); Eval(FUNCTION_INIT);
	/******************************************************************************/
	$VMs = VmManager6_Hosting_GetVm($Settings,$Login);
	#-------------------------------------------------------------------------------
	if(SizeOf($VMs) < 1)
		return new gException('VmManager6_Hosting_CheckIsActive','Не удалось получить список виртуальных машин');
	#-------------------------------------------------------------------------------
	foreach($VMs as $VM)
		if($VM['state'] == 'stopped')
			if($VM['disabled'])	// тока если админом выключена
				return FALSE;
	#-----------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	// машина(-ы?) активна
	#Debug(SPrintF("[system/libs/VmManager6_Hosting]: %s is enabled, disabled not by administrator, or not found",$Login));
	return TRUE;
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
}

# added by lissyara, 2012-02-03 in 09:59 MSK
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
function VmManager6_Hosting_Reboot($Settings,$Login){
	/******************************************************************************/
	$__args_types = Array('array','string');
	#-------------------------------------------------------------------------------
	$__args__ = Func_Get_Args(); Eval(FUNCTION_INIT);
	/******************************************************************************/
	# проверяем - активна ли машина, а то если задизабленную ребутнуть - она включается
	if(!VmManager6_Hosting_CheckIsActive($Settings,$Login)){
		#-------------------------------------------------------------------------------
		return new gException('ACCOUNT_REBOOT_ERROR_IsDisabled','Не удалось перезагрузить виртуальный сервер - он выключен администратором');
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	$VMs = VmManager6_Hosting_GetVm($Settings,$Login);
	#-------------------------------------------------------------------------------
	if(SizeOf($VMs) < 1)
		return new gException('VmManager6_Hosting_Reboot','Не удалось получить список виртуальных машин пользователя');
	#-------------------------------------------------------------------------------
	foreach($VMs as $VM){
		#-------------------------------------------------------------------------------
		$Settings['function']	= 'host';
		$Settings['AddOn']	= SPrintF('%s/restart',$VM['id']);
		$Settings['Method']	= 'POST';
		#-------------------------------------------------------------------------------
		$Doc = VmManager6_Hosting_Request($Settings);
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	return TRUE;
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
}

#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
// поиск определённого пользователя (внутреннее использование) или всех (для проверки биллингом)
function VmManager6_Hosting_Get_Users($Settings,$Login = FALSE){
	/****************************************************************************/
	$__args_types = Array('array','boolean,string');
	#-----------------------------------------------------------------------------
	$__args__ = Func_Get_Args(); Eval(FUNCTION_INIT);
	/****************************************************************************/
	// достаём список юзеров
	$Settings['function']	= 'account';
	#-------------------------------------------------------------------------------
	$Users = VmManager6_Hosting_Request($Settings);
	#-------------------------------------------------------------------------------
	$Result = Array();
	#-------------------------------------------------------------------------------
	foreach($Users['list'] as $iUser){
		#---------------------------------------------------------------------------
		if(!IsSet($iUser['id']))
			continue;
		#---------------------------------------------------------------------------
		if(!IsSet($iUser['email']))
			continue;
		#---------------------------------------------------------------------------
		// самого себя пропускаем, + ISPsystem завели внутренних юзеров internal и support
		if(In_Array($iUser['email'],Array($Settings['Login'],'support@example.com','internal@example.com')))
			continue;
		#---------------------------------------------------------------------------
		#---------------------------------------------------------------------------
		list($User,$Domain) = Explode('@',$iUser['email']);
		#---------------------------------------------------------------------------
		$Result[] = $User;
		#---------------------------------------------------------------------------
		#---------------------------------------------------------------------------
		// если задан вполне определённый юзер, то надо его запомнить
		if($Login)
			if($Login == $User)
				$Login = $iUser;
		#---------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	// если искался вполне определённый логин
	if($Login){
		#-------------------------------------------------------------------------------
		if(Is_Array($Login)){
			#-------------------------------------------------------------------------------
			return $Login;
			#-------------------------------------------------------------------------------
		}else{
			#-------------------------------------------------------------------------------
			// ищется логин, но при этом он не найден в списке пользователей
			return FALSE;
			#-------------------------------------------------------------------------------
		}
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	return $Result;
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
}

#-----------------------------------------------------------------------------
#-----------------------------------------------------------------------------
function VmManager6_Hosting_Get_DiskTemplates($Settings,$Template = FALSE){
	/****************************************************************************/
	$__args_types = Array('array','boolean,string');
	#-----------------------------------------------------------------------------
	$__args__ = Func_Get_Args(); Eval(FUNCTION_INIT);
	/****************************************************************************/
	if($Template)
		Debug(SPrintF('[VmManager6_Hosting_Get_DiskTemplates]: поиск шаблона (%s)',$Template));
	#-----------------------------------------------------------------------------
	$Settings['function']	= 'os';
	#-------------------------------------------------------------------------------
	$Doc = VmManager6_Hosting_Request($Settings);
	#-----------------------------------------------------------------------------
	$Templates = $Doc['list'];
	#-----------------------------------------------------------------------------
	$Result = Array();
	#-----------------------------------------------------------------------------
	// может не быть соединения
	//if(!$Templates)
	//	return $Result;
	#-----------------------------------------------------------------------------
	foreach($Templates as $iTemplate){
		#-----------------------------------------------------------------------------
		//Debug(SPrintF('[VmManager6_Hosting_Get_DiskTemplates]: шаблон = %s',print_r($iTemplate,true)));
		if(!IsSet($iTemplate['id']))
			continue;
		#-----------------------------------------------------------------------------
		if(!IsSet($iTemplate['name']))
			continue;
		#-----------------------------------------------------------------------------
		if($iTemplate['state'] != 'active')
			continue;
		#-----------------------------------------------------------------------------
		if($iTemplate['adminonly'])
			continue;
		#-----------------------------------------------------------------------------
		if($iTemplate['is_lxd_image'])
			continue;
		#-----------------------------------------------------------------------------
		// вариант что не назначно в кластер
		if(!SizeOf($iTemplate['clusters']))
			continue;
		#-----------------------------------------------------------------------------
		$Result[] = SPrintF('%s:%s',$iTemplate['name'],$iTemplate['hdd_mib_required']);
		#-----------------------------------------------------------------------------
		// если передано имя темплейта то надо вернуть идентфикатор
		if($Template && $iTemplate['name'] == $Template){
			#-----------------------------------------------------------------------------
			Debug(SPrintF('[VmManager6_Hosting_Get_DiskTemplates]: найден шаблон (%s)',$Template));
			#-----------------------------------------------------------------------------
			return $iTemplate['id'];
			#-----------------------------------------------------------------------------
		}
		#-----------------------------------------------------------------------------
	}
	#-----------------------------------------------------------------------------
	// если не нашлось имени темплейта, отадём последний из списка
	if($Template){
		#-----------------------------------------------------------------------------
		Debug(SPrintF('[VmManager6_Hosting_Get_DiskTemplates]: НЕ найден шаблон (%s); возвращаем (%s)',$Template,$iTemplate['name']));
		#-----------------------------------------------------------------------------
		return $iTemplate['id'];
		#-----------------------------------------------------------------------------
	}
	#-----------------------------------------------------------------------------
	#-----------------------------------------------------------------------------
	return $Result;
	#-----------------------------------------------------------------------------
	#-----------------------------------------------------------------------------
}

#-----------------------------------------------------------------------------
#-----------------------------------------------------------------------------
function VmManager6_Hosting_Get_Clusters($Settings,$ClusterName = FALSE){
	/****************************************************************************/
	$__args_types = Array('array','boolean,string');
	#-----------------------------------------------------------------------------
	$__args__ = Func_Get_Args(); Eval(FUNCTION_INIT);
	/****************************************************************************/
	$Settings['function']	= 'cluster';
	#-------------------------------------------------------------------------------
	$Doc = VmManager6_Hosting_Request($Settings);
	#-----------------------------------------------------------------------------
	$Clusters = $Doc['list'];
	#-----------------------------------------------------------------------------
	$Result = Array();
	#-----------------------------------------------------------------------------
	foreach($Clusters as $Cluster){
		#-----------------------------------------------------------------------------
		//Debug(SPrintF('[VmManager6_Hosting_Get_Clusters]: Cluster = %s',print_r($Cluster,true)));
		if(!IsSet($Cluster['id']))
			continue;
		#-----------------------------------------------------------------------------
		if(!IsSet($Cluster['name']))
			continue;
		#-----------------------------------------------------------------------------
		#-----------------------------------------------------------------------------
		// если передано имя кластера то надо вернуть идентфикатор
		if($ClusterName && $Cluster['name'] == $ClusterName)
			return $Cluster['id'];
		#-----------------------------------------------------------------------------
	}
	#-----------------------------------------------------------------------------
	// если не нашлось имени кластера, отадём последний из списка
	if($ClusterName)
		return $Cluster['id'];
	#-----------------------------------------------------------------------------
	#-----------------------------------------------------------------------------
	return $Result;
	#-----------------------------------------------------------------------------
	#-----------------------------------------------------------------------------
}

#-----------------------------------------------------------------------------
#-----------------------------------------------------------------------------
function VmManager6_Hosting_Get_Node($Settings,$NodeName = FALSE){
	/****************************************************************************/
	$__args_types = Array('array','boolean,string');
	#-----------------------------------------------------------------------------
	$__args__ = Func_Get_Args(); Eval(FUNCTION_INIT);
	/****************************************************************************/
	$Settings['function']	= 'node';
	#-------------------------------------------------------------------------------
	$Doc = VmManager6_Hosting_Request($Settings);
	#-----------------------------------------------------------------------------
	$Nodes = $Doc['list'];
	#-----------------------------------------------------------------------------
	$Result = Array();
	#-----------------------------------------------------------------------------
	// функция сортировки
	if(!Function_Exists('CMP1')){
		#-----------------------------------------------------------------------------
		function CMP1($a, $b){
			#-----------------------------------------------------------------------------
			return ($a['host_count'] < $b['host_count'])?$a['host_count']:$b['host_count'];
			#-----------------------------------------------------------------------------
		}
		#-----------------------------------------------------------------------------
	}
	#-----------------------------------------------------------------------------
	UASort($Nodes,'CMP1');
	#-----------------------------------------------------------------------------
	foreach($Nodes as $Node){
		#-----------------------------------------------------------------------------
		//Debug(SPrintF('[VmManager6_Hosting_Get_Node]: Node = %s',print_r($Node,true)));
		if(!IsSet($Node['id']))
			continue;
		#-----------------------------------------------------------------------------
		if(!IsSet($Node['name']))
			continue;
		#-----------------------------------------------------------------------------
		// может быть задисаблено создание виртуалок
		if(!IsSet($Node['host_creation_blocked']) && $NodeName)
			continue;
		#-----------------------------------------------------------------------------
		// если передано имя ноды то надо вернуть идентфикатор
		if($NodeName && $Node['name'] == $NodeName)
			return $Node['id'];
		#-----------------------------------------------------------------------------
		#-----------------------------------------------------------------------------
		//Debug(SPrintF('[VmManager6_Hosting_Get_Node]: NodeID = %s',$Node['id']));
		// может быть задисаблено создание виртуалок
		if(IsSet($Node['host_creation_blocked']) && $Node['host_creation_blocked'])
			continue;
		#-----------------------------------------------------------------------------
		// запоминаем последнюю ноду
		$LastNodeID = $Node['id'];
		#-----------------------------------------------------------------------------
	}
	#-----------------------------------------------------------------------------
	// если не нашлось имени ноды, отадём последнюю из списка
	if($NodeName && IsSet($LastNodeID))
		return $LastNodeID;
	#-----------------------------------------------------------------------------
	#-----------------------------------------------------------------------------
	return $Result;
	#-----------------------------------------------------------------------------
	#-----------------------------------------------------------------------------
}

#-----------------------------------------------------------------------------
#-----------------------------------------------------------------------------
function VmManager6_Hosting_Get_Storage($Settings,$Name = FALSE){
	/****************************************************************************/
	$__args_types = Array('array','boolean,string');
	#-----------------------------------------------------------------------------
	$__args__ = Func_Get_Args(); Eval(FUNCTION_INIT);
	/****************************************************************************/
	$Settings['function']	= 'storage';
	#-------------------------------------------------------------------------------
	$Doc = VmManager6_Hosting_Request($Settings);
	#-----------------------------------------------------------------------------
	$Storages = $Doc['list'];
	#-----------------------------------------------------------------------------
	$Result = Array();
	#-----------------------------------------------------------------------------
	foreach($Storages as $Storage){
		#-----------------------------------------------------------------------------
		//Debug(SPrintF('[VmManager6_Hosting_Get_Storage]: Storage = %s',print_r($Storage,true)));
		if(!IsSet($Storage['id']))
			continue;
		#-----------------------------------------------------------------------------
		if(!IsSet($Storage['name']))
			continue;
		#-----------------------------------------------------------------------------
		if($Storage['state'] != 'active')
			continue;
		#-----------------------------------------------------------------------------
		#-----------------------------------------------------------------------------
		// если передано имя стораджа то надо вернуть идентфикатор
		if($Name && $Storage['name'] == $Name)
			return $Storage['id'];
		#-----------------------------------------------------------------------------
	}
	#-----------------------------------------------------------------------------
	// если не нашлось имени стораджа, отадём последний из списка
	if($Name)
		return $Storage['id'];
	#-----------------------------------------------------------------------------
	#-----------------------------------------------------------------------------
	return $Result;
	#-----------------------------------------------------------------------------
	#-----------------------------------------------------------------------------
}

#-----------------------------------------------------------------------------
#-----------------------------------------------------------------------------
function VmManager6_Hosting_Get_NodeList($Settings){
	/****************************************************************************/
	$__args_types = Array('array');
	#-----------------------------------------------------------------------------
	$__args__ = Func_Get_Args(); Eval(FUNCTION_INIT);
	/****************************************************************************/
	// массив параметров
	$Settings['function']	= 'node';
	#-------------------------------------------------------------------------------
	$Doc = VmManager6_Hosting_Request($Settings);
	#-----------------------------------------------------------------------------
	$Result = Array();
	#-----------------------------------------------------------------------------
	foreach($Doc['list'] as $Node){
		#-----------------------------------------------------------------------------
		if(!IsSet($Node['id']))
			continue;
		#-----------------------------------------------------------------------------
		if(!IsSet($Node['name']))
			continue;
		#-----------------------------------------------------------------------------
		if(!IsSet($Node['state']) || $Node['state'] != 'active')
			continue;
		#-----------------------------------------------------------------------------
		$Result[$Node['name']] = $Node;
		#-----------------------------------------------------------------------------
	}
	#-----------------------------------------------------------------------------
	#-----------------------------------------------------------------------------
	// функция сортировки
	if(!Function_Exists('CMP')){
		#-----------------------------------------------------------------------------
		function CMP($a, $b){
			#-----------------------------------------------------------------------------
        		return ($a['host_count'] < $b['host_count'])?$a['host_count']:$b['host_count'];
			#-----------------------------------------------------------------------------
		}
		#-----------------------------------------------------------------------------
	}
	#-----------------------------------------------------------------------------
	#-----------------------------------------------------------------------------
	// сортируем ноды по использованю, чем БОЛЬШЕ - там первее.
	// удобно - при поиске ноды просто берём первую - и это самая незагруженная
	//Debug(SPrintF('[VmManager6_Hosting_Get_NodeList]: Node = %s',print_r($Result,true)));
	UASort($Result,'CMP');
	//Debug(SPrintF('[VmManager6_Hosting_Get_NodeList]: Node = %s',print_r($Result,true)));
	#-----------------------------------------------------------------------------
	#-----------------------------------------------------------------------------
	return $Result;
	#-----------------------------------------------------------------------------
	#-----------------------------------------------------------------------------
}

#-----------------------------------------------------------------------------
#-----------------------------------------------------------------------------
// added by lissyara, 2019-10-21 in 08:56 MSK
// для реализации процесса миграции между нодами, да и много где используется этот код
function VmManager6_Hosting_GetVm($Settings,$Login = FALSE,$Cache = FALSE){
	/******************************************************************************/
	$__args_types = Array('array','string','boolean');
	#-------------------------------------------------------------------------------
	$__args__ = Func_Get_Args(); Eval(FUNCTION_INIT);
	/******************************************************************************/
	Debug(SPrintF('[VmManager6_Hosting_GetVm]: Login = %s',$Login));
	#-------------------------------------------------------------------------------
	// при запросе статситики будет много обращений. над кэшировать
	$CacheID = 'VmManager6_Hosting_GetVm';
	#-------------------------------------------------------------------------------
	$Doc = CacheManager::get($CacheID);
	#-------------------------------------------------------------------------------
	if(!$Doc){
		#-------------------------------------------------------------------------------
		// массив параметров
		$Settings['function']	= 'host';
		#-------------------------------------------------------------------------------
		$Doc = VmManager6_Hosting_Request($Settings);
		#-------------------------------------------------------------------------------
		#-------------------------------------------------------------------------------
		if(!IsSet($Doc['list']))
			return new gException('VmManager6_Hosting_GetVm','Не удалось получить список виртуальных машин');
		#-------------------------------------------------------------------------------
		CacheManager::add($CacheID,$Doc,5);
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	// выхлопной массив
	$Out = Array();
	#-------------------------------------------------------------------------------
	if($Login){
		#-------------------------------------------------------------------------------
		// перебираем виртуалки, в выходной массив добавляем только нужные
		foreach($Doc['list'] as $VM){
			#-------------------------------------------------------------------------------
			//Debug(SPrintF('[VmManager6_Hosting_GetVm]: VM = %s',print_r($VM,true)));
			#-----------------------------------------------------------------------------
			if(!IsSet($VM['id']))
				continue;
			#-------------------------------------------------------------------------------
			if($VM['account']['email'] == SPrintF('%s@%s',$Login,$Settings['Params']['Domain']))
				$Out[$VM['id']] = $VM;
			#-------------------------------------------------------------------------------
		}
		#-----------------------------------------------------------------------------
	}else{
		#-----------------------------------------------------------------------------
		$Out = $Doc['list'];
		#-----------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	return $Out;
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
}

#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
// added by lissyara, 2019-10-22 in 13:41 MSK
// миграция между нодами
function VmManager6_Hosting_VmMigrate($Settings,$ID,$Node){
	/******************************************************************************/
	$__args_types = Array('array','integer','integer');
	#-------------------------------------------------------------------------------
	$__args__ = Func_Get_Args(); Eval(FUNCTION_INIT);
	/******************************************************************************/
	$Request = Array('func'=>'vm.migrate','elid'=>$ID,'destination'=>$Node,'live'=>'on','sok'=>'ok');
	#-------------------------------------------------------------------------------
	$XML = VmManager6_Hosting_Request($Settings,$Request,'elem');
	#-------------------------------------------------------------------------------
	$Doc = $XML['doc'];
	if(IsSet($Doc['error']))
		return new gException('VmManager6_Hosting_VmMigrate','Не удалось запустить миграцию витруальной машины');
	#-------------------------------------------------------------------------------
	#Debug(SPrintF('[system/libs/VmManager6_Hosting]: XML = %s',print_r($XML,true)));
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	return TRUE;
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
}

#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
# added by lissyara 2025-12-23 in 09:50 MSK, for JBS-1751
function VmManager6_Hosting_Get_Account_Usage($Settings,$Users){
	/******************************************************************************/
	$__args_types = Array('array','array');
	#-------------------------------------------------------------------------------
	$__args__ = Func_Get_Args(); Eval(FUNCTION_INIT);
	/******************************************************************************/
	// Массивы на выход и для ключей
	$Out = $Keys = Array();
	#-----------------------------------------------------------------------------
	// перебираем конфиг, создаём массив с полями которые необходимо передать дальше
	$Config = Config();
	$Graphs = $Config['Other']['Graphs'];
	#-----------------------------------------------------------------------------
	foreach(Array_Keys($Graphs) as $Key)
		foreach(Array_Keys($Graphs[$Key]['Keys']) as $ExtKey)
			$Keys[$ExtKey] = $Key;
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	# перебираем юзеров, запрашиваем лимиты и использование
	foreach($Users as $User){
		#-------------------------------------------------------------------------------
		# достаём данные виртуалки
		UnSet($Settings['AddOn']);
		$VMs = VmManager6_Hosting_GetVm($Settings,$User);
		#-------------------------------------------------------------------------------
		if(SizeOf($VMs) < 1){
			#-------------------------------------------------------------------------------
			Debug(SPrintF('[VmManager6_Get_Account_Usage]: пропущен пользователь без виртуалок: %u',$User));
			#-------------------------------------------------------------------------------
			continue;
			#-------------------------------------------------------------------------------
		}
		#-------------------------------------------------------------------------------
		if(SizeOf($VMs) > 1)
			Debug(SPrintF('[VmManager6_Get_Account_Usage]: у пользователя %u более 1 виртуальной машины',$User));
		#-------------------------------------------------------------------------------
		// ввиду ограничений интерфейса, используем одну виртуалку из возможных нескольких
		$VM = Current($VMs);
		#-------------------------------------------------------------------------------
		#-------------------------------------------------------------------------------
		// перебираем статистику, запрашиваем
		$Targets = Array(
				'cpu_load'		=> Array('Limit'=>100),
				'df.root.used'		=> Array('Limit'=>$VM['total_disks_size_mib'],'multiplier'=>0.00000095367),	/* данные по диску в байтах отдаёются */
				'mem_usage'		=> Array('Limit'=>$VM['ram_mib'],'multiplier'=>0.00000095367),			/* память в мегабайтах */
				'mem_usage_percent'	=> Array('Limit'=>100),
				'iops'			=> Array('Limit'=>$VM['io_read_iops']),
				'net_tx_summary'	=> Array('Limit'=>$VM['net_bandwidth_mbitps'],'multiplier'=>0.00000095367),	/* сеть в мегабитах*/
				'net_rx_summary'	=> Array('Limit'=>$VM['net_bandwidth_mbitps'],'multiplier'=>0.00000095367),
				);
		#-------------------------------------------------------------------------------
		foreach(Array_Keys($Targets) as $Key){
			#-------------------------------------------------------------------------------
			// если ключа нет - то не надо этот график
			if(!Array_Key_Exists($Key,$Keys))
				continue;
			#-------------------------------------------------------------------------------
			#-------------------------------------------------------------------------------
			$Settings['function']	= 'host';
			$Settings['AddOn']	= SPrintF('%s/metrics?target=%s',$VM['id'],$Key);
			//$Settings['Method']	= 'POST';
			#-------------------------------------------------------------------------------
			$Doc = VmManager6_Hosting_Request($Settings);
			#-------------------------------------------------------------------------------
			if(IsSet($Doc['error']))
				continue;
			#-------------------------------------------------------------------------------
			if(!IsSet($Doc[0]['datapoints']))
				continue;
			#-------------------------------------------------------------------------------
			#-------------------------------------------------------------------------------
			// пересобираем массив как время=>значение
			$Data = Array();
			#-------------------------------------------------------------------------------
			foreach($Doc[0]['datapoints'] as $iData)
				$Data[$iData[1]] = $iData[0];
			#-------------------------------------------------------------------------------
			#-------------------------------------------------------------------------------
			// бывает 1-2 последних значения по нулям. тогда их надо исключить из массива
			for($i = 1; $i <= 5; $i++){
				#-------------------------------------------------------------------------------
				//Debug(SPrintF('[VmManager6_Get_Account_Usage]: Key = %s, i = %s',$Key,$i));
				// последнее значение false/ноль
				if(!End($Data)){
					#-------------------------------------------------------------------------------
					// удаляем последний элемент массива
					Array_Pop($Data);
					#-------------------------------------------------------------------------------
				}else{
					#-------------------------------------------------------------------------------
					break;
					#-------------------------------------------------------------------------------
				}
				#-------------------------------------------------------------------------------
			}
			#-------------------------------------------------------------------------------
			#-------------------------------------------------------------------------------
			// подгоняем значения на графиках
			if(IsSet($Targets[$Key]['multiplier']))
				foreach(Array_Keys($Data) as $Key2)
					$Data[$Key2] = $Data[$Key2]*$Targets[$Key]['multiplier'];
			#-------------------------------------------------------------------------------
			UnSet($Targets[$Key]['multiplier']);
			#-------------------------------------------------------------------------------
			#-------------------------------------------------------------------------------
			// добавляем шаблон массива с графиками
			$Out[$User]['Graphs'][$Keys[$Key]] = $Targets[$Key];
			#-------------------------------------------------------------------------------
			// добавляем графики
			$Out[$User]['Graphs'][$Keys[$Key]]['Data'] = $Data;
			#-------------------------------------------------------------------------------
		}
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	return $Out;
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
}



#-----------------------------------------------------------------------------
#-----------------------------------------------------------------------------
# внутренняя функция
function VmManager6_Hosting_Request($Settings,$Request = Array(),$Name = FALSE){
	/******************************************************************************/
	$__args_types = Array('array','array','boolean,string');
	#-----------------------------------------------------------------------------
	$__args__ = Func_Get_Args(); Eval(FUNCTION_INIT);
	/******************************************************************************/
	// авторизуемся в панели управления
	$HTTP = Array(
			'Address'	=> $Settings['Params']['IP'],
			'Port'		=> $Settings['Port'],
			'Host'		=> $Settings['Address'],
			'Protocol'	=> $Settings['Protocol'],
			'IsLogging'	=> $Settings['Params']['IsLogging']
			);
	#-------------------------------------------------------------------------------
	$Auth = Array(
			'email'		=> $Settings['Login'],
			'password'	=> $Settings['Password']
			);
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	// проверяем наличие кэшированного токена
	$CacheID = Md5(SPrintF('VmManager6_Hosting_Request-%s',$Settings['Login']));
	#-------------------------------------------------------------------------------
	$Token = CacheManager::get($CacheID);
	#-------------------------------------------------------------------------------
	if(!$Token){
		#-------------------------------------------------------------------------------
		//$Response = HTTP_Send('/auth/v3/auth',$HTTP,Array(),Json_Encode($Auth));
		$Response = HTTP_Send('/api/auth/v4/public/token',$HTTP,Array(),Json_Encode($Auth));
		if(Is_Error($Response))
			return ERROR | @Trigger_Error('[VmManager6_Hosting_Request]: не удалось соедениться с сервером, #1');
		#-------------------------------------------------------------------------------
		$Response = Trim($Response['Body']);
		#-------------------------------------------------------------------------------
		if(!$JSON = Json_Decode($Response,TRUE))
			return new gException('WRONG_SERVER_AUTH_ANSWER',$Response,$JSON);
		#-------------------------------------------------------------------------------
		// бывает с ошибкой логинится, спим и пробуем ещё раз
		if(IsSet($JSON['error'])){
			#-------------------------------------------------------------------------------
			Sleep(10);
			#-------------------------------------------------------------------------------
			//$Response = HTTP_Send('/auth/v3/auth',$HTTP,Array(),Json_Encode($Auth));
			$Response = HTTP_Send('/api/auth/v4/public/token',$HTTP,Array(),Json_Encode($Auth));
			if(Is_Error($Response))
				return ERROR | @Trigger_Error('[VmManager6_Hosting_Request]: не удалось соединиться с сервером, #2');
			#-------------------------------------------------------------------------------
			$Response = Trim($Response['Body']);
			#-------------------------------------------------------------------------------
			if(!$JSON = Json_Decode($Response,TRUE))
				return new gException('WRONG_SERVER_AUTH_ANSWER_2',$Response,$JSON);
			#-------------------------------------------------------------------------------
		}
		#-------------------------------------------------------------------------------
		// залогинились или нет?
		if(!IsSet($JSON['id']))
			return new gException('CANNOT_SERVER_AUTH',$Response,$JSON);
		#-------------------------------------------------------------------------------
		$Token = $JSON['token'];
		#-------------------------------------------------------------------------------
		// кэшируем токен
		CacheManager::add($CacheID,$Token,2700);
		#-------------------------------------------------------------------------------
		Debug(SPrintF('[VmManager6_Hosting_Request]: закэширован новый токен'));
		#-------------------------------------------------------------------------------
	}else{
		#-------------------------------------------------------------------------------
		Debug(SPrintF('[VmManager6_Hosting_Request]: используется ранее кэшированный токен'));
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	// сервис всегда один и тот же...
	if(!IsSet($Settings['service']))
		$Settings['service'] = 'vm';
	#-------------------------------------------------------------------------------
	// иногда метод явно задан, т.к. используется кроме POST/GET ещё и DELETE
	if(IsSet($Settings['Method']))
		$HTTP['Method'] = $Settings['Method'];
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	$Url = SPrintF('/%s/v3/%s%s',$Settings['service'],$Settings['function'],IsSet($Settings['AddOn'])?SPrintF('/%s',$Settings['AddOn']):'');
	#-------------------------------------------------------------------------------
	$Post= SizeOf($Request)?Json_Encode($Request):Array();
	#-------------------------------------------------------------------------------
	// выполняем запрошенную команду
	$Response = HTTP_Send($Url,$HTTP,Array(),$Post,Array(SPrintF('x-xsrf-token: %s',$Token)));
	if(Is_Error($Response))
		return ERROR | @Trigger_Error('[VmManager6_Hosting_Request]: не удалось соедениться с сервером');
	#-------------------------------------------------------------------------------
	$Response = Trim($Response['Body']);
	#-------------------------------------------------------------------------------
	// ответом может быть пустой массив
	$Doc = Json_Decode($Response,TRUE);
	#if(!$Doc = Json_Decode($Response,TRUE))
	#	return new gException('WRONG_SERVER_ANSWER',$Response,$Doc);
	#-------------------------------------------------------------------------------
	// если ошибка - падаем. может потом отключить придётся, посмотрим
	//Debug(var_export($Settings, true));
	//Debug('BEFORE ERROR_IN_SERVER_ANSWER');
	if(IsSet($Doc['error']))
		return new gException('ERROR_IN_SERVER_ANSWER',$Doc['error']['msg']);
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	return $Doc;
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
}













?>
