<?php

#-------------------------------------------------------------------------------
/** @author Alex Keda, for www.host-food.ru */
/******************************************************************************/
/******************************************************************************/
$__args_list = Array('Order');
/******************************************************************************/
Eval(COMP_INIT);
/******************************************************************************/
/******************************************************************************/
$ModeID = $Order['ModeID'];
#-------------------------------------------------------------------------------
Debug(SPrintF('[comp/Triggers/GLOBAL]: ModeID = %s; StatusID = %s; Order = %s',$ModeID,$Order['StatusID'],print_r($Order['Row'],true)));
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
//Debug(SPrintF('[comp/Triggers/GLOBAL]: Order = %s',print_r($Order,true)));
#-------------------------------------------------------------------------------
// докидываем номер заказа, далее используется не в одном месте, для обычных услуг OrderID, для кастомных - ID
if(IsSet($Order['Row']['DependOrderID']))
	$Order['OrderID'] = IsSet($Order['Row']['OrderID'])?$Order['Row']['OrderID']:$Order['Row']['ID'];
#-------------------------------------------------------------------------------
// JBS-1684, отключение автопродления зависиымх услуг, при удалении основной услуги
if($Order['StatusID'] == 'Deleted' && IsSet($Order['Row']['DependOrderID'])){
	#-------------------------------------------------------------------------------
	$Where = SPrintF('`DependOrderID` = %u',$Order['OrderID']);
	#-------------------------------------------------------------------------------
	$IsUpdate = DB_Update('Orders',Array('IsAutoProlong'=>FALSE),Array('Where'=>$Where));
	if(Is_Error($IsUpdate))
		return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
// счета
if($ModeID == 'Invoices')
	if(!SORM_add('payment',$GLOBALS['__USER']['service_aaa'],Array('InvoiceID'=>$Order['Row']['ID'],'ActionTypeId'=>$Order['StatusID'],'Timestamp'=>Date("Y-m-d\TH:i:s"))))
		return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
// учётки на серверах
if(Preg_Match('/Orders$/',$ModeID) && IsSet($Order['Row']['Login']))
	if(!SORM_add('service_user',$GLOBALS['__USER']['service_aaa'],Array('Timestamp'=>Date("Y-m-d\TH:i:s"),'UserId'=>$Order['Row']['UserID'],'CustomerId'=>$Order['Row']['ContractID'],'ServiceId'=>$Order['Row']['ServiceID'],'ActionTypeId'=>$Order['StatusID'],'Login'=>$Order['Row']['Login'])))
		return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
// заказы на услуги
if(Preg_Match('/Orders$/',$ModeID)){
	#-------------------------------------------------------------------------------
	$Login = IsSet($Order['Row']['Login'])?$Order['Row']['Login']:'';
	#-------------------------------------------------------------------------------
	if(!SORM_add('service_order_resource',$GLOBALS['__USER']['service_aaa'],Array('Timestamp'=>Date("Y-m-d\TH:i:s"),'OrderID'=>$Order['Row']['OrderID'],'ActionTypeId'=>$Order['StatusID'],'Login'=>$Login)))
		return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------





if(!IsSet($Order['Row']['ServerID'])){
	#-------------------------------------------------------------------------------
	Debug(SPrintF('[comp/Triggers/GLOBAL]: Для (%s->%s) не задан сервер',$ModeID,$Order['StatusID']));
	#-------------------------------------------------------------------------------
	return TRUE;
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
if(Is_Null($Order['Row']['ServerID'])){
	#-------------------------------------------------------------------------------
	Debug(SPrintF('[comp/Triggers/GLOBAL]: Для (%s->%s) сервер = NULL',$ModeID,$Order['StatusID']));
	#-------------------------------------------------------------------------------
	return TRUE;
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
if($Order['Row']['ServerID'] < 1){
	#-------------------------------------------------------------------------------
	Debug(SPrintF('[comp/Triggers/GLOBAL]: Для (%s->%s) ServerID = 0',$ModeID,$Order['StatusID']));
	#-------------------------------------------------------------------------------
	return TRUE;
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
# JBS-1092: исключения
$Array = Array('ExtraIPOrders');
#-------------------------------------------------------------------------------
if(In_Array($ModeID,$Array)){
	#-------------------------------------------------------------------------------
	Debug(SPrintF('[comp/Triggers/GLOBAL]: Для (%s->%s) найдено исключение, глобальный триггер не обрабатывается',$ModeID,$Order['StatusID']));
	#-------------------------------------------------------------------------------
	return TRUE;
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
# создание тикетов при установке статуса услуги

# достаём данные сервиса
if(IsSet($Order['Row']['ServiceID'])){
	#-------------------------------------------------------------------------------
	Debug(SPrintF('[comp/Triggers/GLOBAL]: Для (%s->%s) необходима обработка создания тикета',$ModeID,$Order['StatusID']));
	#-------------------------------------------------------------------------------
	$Service = DB_Select('Services','*',Array('UNIQ','ID'=>$Order['Row']['ServiceID']));
	#-------------------------------------------------------------------------------
	switch(ValueOf($Service)){
	case 'error':
		return ERROR | @Trigger_Error(500);
	case 'exception':
		return ERROR | @Trigger_Error(400);
	case 'array':
		break;
	default:
		return ERROR | @Trigger_Error(101);
	}
	#-------------------------------------------------------------------------------
	# проверяем, надо ли создавать тикет для данного статуса
	$Params = @$Service['Params']['Statuses'][$Order['StatusID']];
	#-------------------------------------------------------------------------------
	$OrderID = (IsSet($Order['Row']['OrderID'])?$Order['Row']['OrderID']:$Order['Row']['ID']);
	#-------------------------------------------------------------------------------
	if(IsSet($Params['ClauseID']) && $Params['ClauseID']){
		#-------------------------------------------------------------------------------
		Debug(SPrintF('[comp/Triggers/GLOBAL]: Для (%s->%s) задан идентфикатор статьи ClauseID = %u',$ModeID,$Order['StatusID'],$Params['ClauseID']));
		#-------------------------------------------------------------------------------
		# если стоит что тикет не дублируется, проверяем наличие такого тикета
		$NeedCreate = TRUE;
		#-------------------------------------------------------------------------------
		if(IsSet($Params['IsNoDuplicate']) && $Params['IsNoDuplicate']){
			#-------------------------------------------------------------------------------
			# проверяем, не создан ли уже тикет по этому поводу
			$Count = DB_Count('Edesks',Array('Where'=>SPrintF("`Theme` LIKE '%%[OrderID/%u]%%'",$OrderID)));
			#-------------------------------------------------------------------------------
			if(Is_Error($Count))
				return ERROR | @Trigger_Error(500);
			#-------------------------------------------------------------------------------
			if($Count)
				$NeedCreate = FALSE;
			#-------------------------------------------------------------------------------
		}
		#-------------------------------------------------------------------------------
		if($NeedCreate){
			#-------------------------------------------------------------------------------
			Debug(SPrintF('[comp/Triggers/GLOBAL]: Необходимо создать тикет из статьи ClauseID = %u',$Params['ClauseID']));
			#-------------------------------------------------------------------------------
			# достаём статью
			$Clause = DB_Select('Clauses','*',Array('UNIQ','ID'=>$Params['ClauseID']));
			#-------------------------------------------------------------------------------
			switch(ValueOf($Clause)){
			case 'error':
				return ERROR | @Trigger_Error(500);
			case 'exception':
				#-------------------------------------------------------------------------------
				Debug(SPrintF('[comp/Triggers/GLOBAL]: Не найдена статья ClauseID = %u, не удалось создать тикет',$Params['ClauseID']));
				#-------------------------------------------------------------------------------
				break;
				#-------------------------------------------------------------------------------
			case 'array':
				break;

			default:
				return ERROR | @Trigger_Error(101);
			}
			#-------------------------------------------------------------------------------
			$CompParams = Array(
						'Theme'		=> SPrintF('[OrderID/%u] %s',$OrderID,$Clause['Title']),
						'TargetGroupID' => 3100000,
						'TargetUserID'  => 100,
						'Message'       => Trim(Strip_Tags($Clause['Text'])),
						'UserID'        => $Order['Row']['UserID'],
						'Flags'         => @$Params['Flag']
						);
			#-------------------------------------------------------------------------------
			# создаём тикет, от админа
			$GLOBALS['__USER']['ID']        = 100;
			$GLOBALS['__USER']['IsAdmin']   = TRUE;
			#-------------------------------------------------------------------------------
			$IsAdd = Comp_Load('www/API/TicketEdit',$CompParams);
			if(Is_Error($IsAdd))
				return ERROR | @Trigger_Error(500);
			#-------------------------------------------------------------------------------
			# возвращаем юзера
			$GLOBALS['__USER']['ID']	= $Order['Row']['UserID'];
			$GLOBALS['__USER']['IsAdmin']   = FALSE;
			#-------------------------------------------------------------------------------
		}
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
# достаём данные группы серверов, к которым относится услуга
$ServersGroup = DB_Select('ServersGroups','*',Array('UNIQ','Where'=>SPrintF('`ID` = (SELECT `ServersGroupID` FROM `Servers` WHERE `ID` = %u)',$Order['Row']['ServerID'])));
#-------------------------------------------------------------------------------
switch(ValueOf($ServersGroup)){
case 'error':
	return ERROR | @Trigger_Error(500);
case 'exception':
	return ERROR | @Trigger_Error(400);
case 'array':
	break;
default:
	return ERROR | @Trigger_Error(101);
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
#Debug(SPrintF('[comp/Triggers/GLOBAL]: Params = %s',print_r($ServersGroup['Params'],true)));
#-------------------------------------------------------------------------------
if(!$ServersGroup['Params']['Count']){
	#-------------------------------------------------------------------------------
	Debug(SPrintF('[comp/Triggers/GLOBAL]: Для (%s->%s) не задано дополнительных сервисов, Count = 0 или не задан',$ModeID,$Order['StatusID']));
	#-------------------------------------------------------------------------------
	return TRUE;
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
Debug(SPrintF('[comp/Triggers/GLOBAL]: Для (%s->%s) необходимо активировать дополнительных услуг: %u',$ModeID,$Order['StatusID'],$ServersGroup['Params']['Count']));
#-------------------------------------------------------------------------------
for($i = 1; $i <= $ServersGroup['Params']['Count']; $i++){
	#-------------------------------------------------------------------------------
	UnSet($ExistsOrderID);
	#-------------------------------------------------------------------------------
	$ServiceID		= (integer) @$ServersGroup['Params'][(SPrintF('Service%u',$i))];
	$SchemeID		= (integer) @$ServersGroup['Params'][(SPrintF('Scheme%u',$i))];
	$StatusID		=  (string) @$ServersGroup['Params'][(SPrintF('Status%u',$i))];
	$AdditionalParams	=  (string) @$ServersGroup['Params'][(SPrintF('AdditionalParams%u',$i))];
	$IsZeroPriceOrder	= (boolean) @$ServersGroup['Params'][(SPrintF('IsZeroPriceOrder%u',$i))];
	$IsZeroPricePay		= (boolean) @$ServersGroup['Params'][(SPrintF('IsZeroPricePay%u',$i))];
	$IsNoDuplicate		= (boolean) @$ServersGroup['Params'][(SPrintF('IsNoDuplicate%u',$i))];
	#-------------------------------------------------------------------------------
	if($StatusID != $Order['StatusID']){
		#-------------------------------------------------------------------------------
		Debug(SPrintF('[comp/Triggers/GLOBAL]: Услуга (%u) пропущена, не соответствует статус %s != %s',$ServiceID,$StatusID,$Order['StatusID']));
		#-------------------------------------------------------------------------------
		continue;
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	Debug(SPrintF('[comp/Triggers/GLOBAL]: Создание заказа на услугу #%u; сервис = %u; тариф = %u; дополнительные параметры = (%s); нулевая цена заказ = %s; нулевая цена оплата = %s; не дублировать = %s',$i,$ServiceID,$SchemeID,$AdditionalParams,(($IsZeroPriceOrder)?'TRUE':'FALSE'),(($IsZeroPricePay)?'TRUE':'FALSE'),(($IsNoDuplicate)?'TRUE':'FALSE')));
	#-------------------------------------------------------------------------------
	$Service = DB_Select('Services',Array('*'),Array('UNIQ','ID'=>$ServiceID));
	#-------------------------------------------------------------------------------
	switch(ValueOf($ServersGroup)){
	case 'error':
		return ERROR | @Trigger_Error(500);
	case 'exception':
		#-------------------------------------------------------------------------------
		# такого сервиса нет. видимо, его уже удалили...
		Debug(SPrintF('[comp/Triggers/GLOBAL]: не найден сервис ServiceID = %u',$ServiceID));
		#-------------------------------------------------------------------------------
		continue 2;
		#-------------------------------------------------------------------------------
	case 'array':
		break;
	default:
		return ERROR | @Trigger_Error(101);
	}
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	if($Service['Code'] == 'Default'){
		#-------------------------------------------------------------------------------
		# TODO: надо сделать реализацию для услуг настраиваемых вручную....
		continue;
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	# проверяем наличие такого тарифа для такой услуги, и его активность
	$Scheme = DB_Select(SPrintF('%sSchemes',$Service['Code']),'*',Array('UNIQ','ID'=>$SchemeID));
	#-------------------------------------------------------------------------------
	switch(ValueOf($Scheme)){
	case 'error':
		return ERROR | @Trigger_Error(500);
	case 'exception':
		#-------------------------------------------------------------------------------
		# нет такого тарифа, видимо, удалён
		Debug(SPrintF('[comp/Triggers/GLOBAL]: у сервиса ServiceID = %u не найден тариф SchemeID = %u',$ServiceID,$SchemeID));
		#-------------------------------------------------------------------------------
		continue 2;
		#-------------------------------------------------------------------------------
	case 'array':
		#-------------------------------------------------------------------------------
		if(!$Scheme['IsActive']){
			#-------------------------------------------------------------------------------
			Debug(SPrintF('[comp/Triggers/GLOBAL]: у сервиса ServiceID = %u тариф SchemeID = %u неактивен, нельзя заказать',$ServiceID,$SchemeID));
			#-------------------------------------------------------------------------------
			continue 2;
			#-------------------------------------------------------------------------------
		}
		#-------------------------------------------------------------------------------
		break;
		#-------------------------------------------------------------------------------
	default:
		return ERROR | @Trigger_Error(101);
	}
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	# реализация JBS-937
	$Array = Array();
	#-------------------------------------------------------------------------------
	if($AdditionalParams){
		#-------------------------------------------------------------------------------
		foreach(Explode(",",$AdditionalParams) as $AdditionalParam){
			#-------------------------------------------------------------------------------
			List($Name,$Value) = Explode("=",Trim($AdditionalParam));
			#-------------------------------------------------------------------------------
			Debug(SPrintF('[comp/Triggers/GLOBAL]: Additional set: %s => %s',$Name,$Value));
			#-------------------------------------------------------------------------------
			# закидываем имя/значение в массив параметров
			$Array[$Name] = $Value;
			#-------------------------------------------------------------------------------
			# проверить динамическое значение параметра, или статическое
			if(Preg_Match('/^%\w+%$/',$Value)){
				#-------------------------------------------------------------------------------
				$Column = Str_Replace('%','',$Value);
				#-------------------------------------------------------------------------------
				Debug(SPrintF('[comp/Triggers/GLOBAL]: Additional need change: Column = %s',$Column));
				#-------------------------------------------------------------------------------
				if(IsSet($Order['Row'][$Column])){
					#-------------------------------------------------------------------------------
					Debug(SPrintF('[comp/Triggers/GLOBAL]: Additional changed: %s => %s',$Name,$Order['Row'][$Column]));
					#-------------------------------------------------------------------------------
					$Array[$Name] = $Order['Row'][$Column];
					#-------------------------------------------------------------------------------
				}else{
					#-------------------------------------------------------------------------------
					Debug(SPrintF('[comp/Triggers/GLOBAL]: $Order->Row->$Column not set, $Order[Row] = %s',print_r($Order['Row'],true)));
					#-------------------------------------------------------------------------------
				}
				#-------------------------------------------------------------------------------
			}else{
				#-------------------------------------------------------------------------------
				Debug(SPrintF('[comp/Triggers/GLOBAL]: Additional not match with regulars'));
				#-------------------------------------------------------------------------------
			}
			#-------------------------------------------------------------------------------
		}
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	$AdditionalParams = $Array;
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	# проверяем наличие такой услуги у юзера
	$Where = Array(
			SprintF('`UserID` = %u',$Order['Row']['UserID']),
			SPrintF('`SchemeID` = %u',$SchemeID),
			SPrintF('`DependOrderID` = %u',$Order['OrderID']),	// зависимая от этой услуга
			'`StatusID` IN ("Active","Waiting","Suspended")'
			);
	#-------------------------------------------------------------------------------
	# добавляем к условию дополнительные параметры
	if(Is_Array($AdditionalParams) && SizeOf($AdditionalParams) > 0)
		foreach(Array_Keys($AdditionalParams) as $Key)
			$Where[] = SPrintF('`%s` = "%s"',$Key,$AdditionalParams[$Key]);
	#-------------------------------------------------------------------------------
	$ExistsOrder = DB_Select(SPrintF('%sOrdersOwners',$Service['Code']),'*',Array('UNIQ','Where'=>$Where,'Limits'=>Array(0,1)));
	switch(ValueOf($ExistsOrder)){
	case 'error':
		return ERROR | @Trigger_Error(500);
	case 'exception':
		break;
	case 'array':
		#-------------------------------------------------------------------------------
		if($IsNoDuplicate && $ExistsOrder['StatusID'] == 'Active'){
			#-------------------------------------------------------------------------------
			Debug(SPrintF('[comp/Triggers/GLOBAL]: у клиента уже есть заказ на ServiceID = %u, SchemeID = %u',$ServiceID,$SchemeID));
			#-------------------------------------------------------------------------------
			continue 2;
			#-------------------------------------------------------------------------------
		}
		#-------------------------------------------------------------------------------
		# заказ существует, он неактивен
		$ExistsOrderID = $ExistsOrder['ID'];
		#-------------------------------------------------------------------------------
		break;
		#-------------------------------------------------------------------------------
	default:
		return ERROR | @Trigger_Error(101);
	}
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	# реализация JBS-940
	if(Is_Error(DB_Transaction($TransactionID = UniqID('CostPay'))))
		return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------------
	$Comp = Comp_Load('Services/Bonuses',$Scheme['MinDaysPay'],$ServiceID,$SchemeID,$Order['Row']['UserID'],'0.00',$Scheme['CostDay'],FALSE);
	if(Is_Error($Comp))
		return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------------
	if(Is_Error(DB_Roll($TransactionID)))
		return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------------
	$CostPay = Round($Comp['CostPay'],2);
	#-------------------------------------------------------------------------------
	if($CostPay > 0 && $IsZeroPriceOrder){
		#-------------------------------------------------------------------------------
		Debug(SPrintF('[comp/Triggers/GLOBAL]: цена на услугу больше нуля (%s), заказ не производится',$CostPay));
		#-------------------------------------------------------------------------------
		continue;
		#-------------------------------------------------------------------------------
	}else{
		#-------------------------------------------------------------------------------
		Debug(SPrintF('[comp/Triggers/GLOBAL]: цена на услугу ноль (%s) или IsZeroPriceOrder = FALSE',$CostPay));
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	$Array = Array(
			'ContractID'				=> $Order['Row']['ContractID'],
			SPrintF('%sSchemeID',$Service['Code'])	=> $SchemeID,
			'Comment'				=> SPrintF('Автоматическое создание услуги, группа серверов #%u, "%s"',$ServersGroup['ID'],$ServersGroup['Name']),
			'DependOrderID'				=> $Order['Row']['OrderID']
			);
	#-------------------------------------------------------------------------------
	# реализация JBS-937
	if(Is_Array($AdditionalParams))
		Array_Union($Array,$AdditionalParams);
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	$OrderID = SPrintF('%sOrderID',$Service['Code']);
	#-------------------------------------------------------------------------------
	# заказываем/продлеваем услугу
	if(!IsSet($ExistsOrderID)){
		#-------------------------------------------------------------------------------
		$Path = SPrintF('www/API/%sOrder',$Service['Code']);
		#-------------------------------------------------------------------------------
		if(Is_Error(System_Element(SPrintF('comp/%s.comp.php',$Path)))){
			#-------------------------------------------------------------------------------
			Debug(SPrintF('[comp/Triggers/GLOBAL]: API для заказа сервиса не найдено: %s',$Path));
			#-------------------------------------------------------------------------------
			continue;
			#-------------------------------------------------------------------------------
		}
		#-------------------------------------------------------------------------------
		#-------------------------------------------------------------------------------
		#Debug(SPrintF('[comp/Triggers/GLOBAL]: %s params = %s',$Path,print_r($Array,true)));
		#-------------------------------------------------------------------------------
		$AddOrder = Comp_Load($Path,$Array);
		#-------------------------------------------------------------------------------
		switch(ValueOf($AddOrder)){
		case 'error':
			return ERROR | @Trigger_Error(500);
		case 'exception':
			# No more...
			continue 2;
		case 'array':
			#-------------------------------------------------------------------------------
			$ExistsOrderID = $AddOrder[$OrderID];
			#-------------------------------------------------------------------------------
			break;
			#-------------------------------------------------------------------------------
		default:
			return ERROR | @Trigger_Error(101);
		}
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	# реализация JBS-940
	if($CostPay > 0 && $IsZeroPricePay){
		#-------------------------------------------------------------------------------
		Debug(SPrintF('[comp/Triggers/GLOBAL]: цена на услугу больше нуля (%s), оплата не производится',$CostPay));
		#-------------------------------------------------------------------------------
		continue;
		#-------------------------------------------------------------------------------
	}else{
		#-------------------------------------------------------------------------------
		Debug(SPrintF('[comp/Triggers/GLOBAL]: цена на услугу ноль (%s) или IsZeroPricePay = FALSE',$CostPay));
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	# оплачиваем услугу на минимальное число дней (или юзать параметры? или юзать срок оплаты основной услуги?)
	$Array = Array(
			$OrderID	=> $ExistsOrderID,
			'DaysPay'	=> $Scheme['MinDaysPay'],
			'IsNoBasket'	=> TRUE,
			'PayMessage'	=> SPrintF('Автоматическая оплата зависимой услуги, группа серверов #%u, "%s"',$ServersGroup['ID'],$ServersGroup['Name'])
			);
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	$Path = SPrintF('www/API/%sOrderPay',$Service['Code']);
	#-------------------------------------------------------------------------------
	if(Is_Error(System_Element(SPrintF('comp/%s.comp.php',$Path)))){
		#-------------------------------------------------------------------------------
		Debug(SPrintF('[comp/Triggers/GLOBAL]: API для заказа сервиса не найдено: %s',$Path));
		#-------------------------------------------------------------------------------
		continue;
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	$OrderPay = Comp_Load($Path,$Array);
	#-------------------------------------------------------------------------------
	switch(ValueOf($OrderPay)){
	case 'error':
		return ERROR | @Trigger_Error(500);
	case 'exception':
		# No more...
		continue 2;
	case 'array':
		break;
	default:
		return ERROR | @Trigger_Error(101);
	}
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
return TRUE;
#-------------------------------------------------------------------------------

?>
