<?php
#-------------------------------------------------------------------------------
/** @author Alex Keda, for www.host-food.ru */
/******************************************************************************/
/******************************************************************************/
$__args_list = Array('Args');
/******************************************************************************/
Eval(COMP_INIT);
/******************************************************************************/
/******************************************************************************/
$Args = IsSet($Args)?$Args:Args();
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
#if(Is_Error(System_Load('modules/Authorisation.mod')))
#	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
#$CacheID = Md5($__FILE__ . !IsSet($GLOBALS['__USER'])?$_SERVER['REMOTE_ADDR']:$GLOBALS['__USER']['ID']);
if(IsSet($GLOBALS['__USER'])){
	#-------------------------------------------------------------------------------
	Debug("[www/API/v2/Config]: User set");
	#-------------------------------------------------------------------------------
	$CacheID = Md5($__FILE__ . $GLOBALS['__USER']['ID']);
	#-------------------------------------------------------------------------------
}else{
	#-------------------------------------------------------------------------------
	$CacheID = Md5($__FILE__ . $_SERVER['REMOTE_ADDR']);
	#-------------------------------------------------------------------------------
	Debug("[www/API/v2/Config]: User NOT set");
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
$Result = CacheManager::get($CacheID);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
if($Result){
	#-------------------------------------------------------------------------------
	$Out = $Result;
	#-------------------------------------------------------------------------------
	// дата сервера
	$Out['MicroTime'] = MicroTime(TRUE);
	$Out['Date'] = Date('d/m/Y');
	$Out['Time'] = Time();
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	return $Out;
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
}else{
	#-------------------------------------------------------------------------------
	$Out = Array();
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Config = Config();
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
// профили
$Profiles = Array('Templates'=>Array());
#-------------------------------------------------------------------------------
foreach(Array_Keys($Config['Profiles']['Templates']) as $Key){
	#-------------------------------------------------------------------------------
	$Template = System_XML(SPrintF('profiles/%s.xml',$Key));
	if(Is_Error($Template))
		return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------------
	$Profiles['Templates'][$Key] = $Config['Profiles']['Templates'][$Key];
	#-------------------------------------------------------------------------------
	$Profiles['Templates'][$Key]['Template'] = $Template;
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
$Out['Profiles'] = $Profiles;
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
// договора
$Out['Contracts'] = $Config['Contracts'];
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
// счета на оплату, платёжные системы
$PaymentSystems = Array();
#-------------------------------------------------------------------------------
foreach(Array_Keys($Config['Invoices']['PaymentSystems']) as $Key){
	#-------------------------------------------------------------------------------
	$PaymentSystem = $Config['Invoices']['PaymentSystems'][$Key];
	#-------------------------------------------------------------------------------
	// а в старых платежах может быть...
	//if(!$PaymentSystem['IsActive'])
	//	continue;
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	$Collations = Array();
	#-------------------------------------------------------------------------------
	// достаём сопоставление
	$iCollations = DB_Select('PaymentSystemsCollation',Array('*'),Array('Where'=>Array('`IsActive` = "yes"',SPrintF('`Source` = "%s"',$Key)),'SortOn'=>'SortID'));
	#-------------------------------------------------------------------------------
	switch(ValueOf($iCollations)){
	case 'error':
		return ERROR | @Trigger_Error(500);
	case 'exception':
		break;
	case 'array':
		#-------------------------------------------------------------------------------
		foreach($iCollations as $Collation){
			#-------------------------------------------------------------------------------
			$SRC = SPrintF('Images/PaymentSystems/%s',($Collation['Image'])?$Collation['Image']:'Blank.png');
			#-------------------------------------------------------------------------------
			$Collation['Image'] = Styles_Url($SRC);
			#-------------------------------------------------------------------------------
			UnSet($Collation['AdminNotice']);
			#-------------------------------------------------------------------------------
			$Collations[] = $Collation;
			#-------------------------------------------------------------------------------
		}
		#-------------------------------------------------------------------------------
		break;
		#-------------------------------------------------------------------------------
	default:
		return ERROR | @Trigger_Error(101);
	}
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	$Out['PaymentSystems'][$Key] = Array(
						'Name'			=> $PaymentSystem['Name'],
						'SystemDescription'	=> $PaymentSystem['SystemDescription'],
						'ContractsTypes'	=> $PaymentSystem['ContractsTypes'],
						'IsContinuePaying'	=> $PaymentSystem['IsContinuePaying'],
						'Course'		=> $PaymentSystem['Course'],
						'Measure'		=> $PaymentSystem['Course'],
						'Valute'		=> $PaymentSystem['Valute'],
						'MinimumPayment'	=> $PaymentSystem['MinimumPayment'],
						'MaximumPayment'	=> $PaymentSystem['MaximumPayment'],
						'IsActive'		=> $PaymentSystem['IsActive'],
						'Collations'		=> $Collations
						);
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
// уведомленния
// перебираем методы, выбираем все. Необходимо проставить Use{Method}
$Notifies = $Methods = Array();
#-------------------------------------------------------------------------------
// отдельный массив с активными типами уведомлений
foreach(Array_Keys($Config['Notifies']['Methods']) as $Key){
	#-------------------------------------------------------------------------------
	$Methods[] = $Key;
	#-------------------------------------------------------------------------------
	$Config['Notifies']['Methods'][$Key]['IMG'] = Styles_Url(SPrintF('Images/Icons/IM/%s.svg',$Key));
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
foreach(Array_Keys($Config['Notifies']['Types']) as $Key){
	#-------------------------------------------------------------------------------
	foreach($Methods as $Method){
		#-------------------------------------------------------------------------------
		// название ключа
		$KeyName = SPrintF('Use%s',$Method);
		#-------------------------------------------------------------------------------
		// если ключ задан - то оставляем его значение, если нет - то "1" - тут обратная логика
		if(IsSet($Config['Notifies']['Types'][$Key][$KeyName]))
			continue;
		#-------------------------------------------------------------------------------
		$Config['Notifies']['Types'][$Key][$KeyName] = "1";
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
$Out['Notifies'] = $Config['Notifies'];
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
// тикеты
$Out['Edesks'] = $Config['Edesks'];
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
// сервисы
$Out['Services'] = $Config['Services'];
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
// статусы
$Out['Statuses'] = $Config['Statuses'];
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
// докУменты
$Out['MotionDocuments'] = $Config['MotionDocuments'];
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
// цвета нового интерфейса
$Out['Colors'] = $Config['Interface']['Colors'];
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
// регулярки
$Out['Regulars'] = Regulars();
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
// сообщения
$Out['Messages'] = Messages();
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
// логотип
$Out['TopLogo'] = Styles_Url('Images/TopLogo.png');
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
if(IsSet($GLOBALS['__USER'])){
	// весь покаываем
}else{
	#-------------------------------------------------------------------------------
	UnSet($Out['PaymentSystems']);
	UnSet($Out['Profiles']);
	UnSet($Out['Contracts']);
	UnSet($Out['Notifies']);
	UnSet($Out['Edesks']);
	UnSet($Out['Services']);
	UnSet($Out['Statuses']);
	UnSet($Out['MotionDocuments']);
	UnSet($Out['Regulars']);
	UnSet($Out['Messages']);
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
// сохраняем кэш
CacheManager::add($CacheID,$Out,60);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
// дата сервера
$Out['MicroTime'] = MicroTime(TRUE);
$Out['Date'] = Date('d/m/Y');
$Out['Time'] = Time();
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
return $Out;
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------

