<?php
#-------------------------------------------------------------------------------
/** @author Великодный В.В. (Joonte Ltd.) */
#-------------------------------------------------------------------------------
class DOM{
# Хранилище дерева объектов
public $Object = NULL;
# Массив ссылок
public $Links = Array();
# Путь шаблона документа DOM
public $TemplateID = NULL;

#-------------------------------------------------------------------------------
/**
* Конструктор класса
*
* Создает документ из XML строки.
*
* @param string <иницилиазирующая строка>
*/
public function __construct($Source = NULL){
  /****************************************************************************/
  $__args_types = Array('string,object');
  #-----------------------------------------------------------------------------
  $__args__ = Func_Get_Args(); Eval(FUNCTION_INIT);
  /****************************************************************************/
  if(!Is_Null($Source)){
    #---------------------------------------------------------------------------
    if(Is_Object($Source)){
      #-------------------------------------------------------------------------
      $this->Object = $Source;
      #-------------------------------------------------------------------------
      $this->Linking();
    }
    #---------------------------------------------------------------------------
    if(Is_String($Source)){
      #-------------------------------------------------------------------------
      if(Mb_StrLen($Source) > 1){
        #-----------------------------------------------------------------------
        $this->Object = String_XML_Parse($Source);
        if(Is_Exception($this->Object))
          return ERROR | Trigger_Error('[DOM->DOM]: не удалось преобразовать XML');
        #-----------------------------------------------------------------------
        $this->Object = Current($this->Object->Childs);
        #-----------------------------------------------------------------------
        $this->Linking();
      }
    }
  }
}
#-------------------------------------------------------------------------------
/**
* Загружает шаблон в документ
*
* Загружает в документ XML шаблон с именем из директории domtempales.
*
* @param string <Имя шаблона>
*/
#-------------------------------------------------------------------------------
public function Load($TemplateID){
  /****************************************************************************/
  $__args_types = Array('string');
  #-----------------------------------------------------------------------------
  $__args__ = Func_Get_Args();
  Eval(FUNCTION_INIT);
  /****************************************************************************/
  foreach($__args__ as $__arg__){
    #---------------------------------------------------------------------------
    $this->TemplateID = $__arg__;
    #---------------------------------------------------------------------------
    $Path = System_Element(SPrintF('templates/%s.xml',$__arg__));
    if(!Is_Error($Path)){
      #-------------------------------------------------------------------------
      $Source = IO_Read($Path);
      if(Is_Error($Source))
        return ERROR | @Trigger_Error('[DOM->Load]: не удалось загрузить файл шаблона');
      #-------------------------------------------------------------------------
      $this->Object = String_XML_Parse($Source);
      if(Is_Exception($this->Object))
        return ERROR | @Trigger_Error('[DOM->Load]: не удалось преобразовать XML');
      #-------------------------------------------------------------------------
      $this->Object = Current($this->Object->Childs);
      #-------------------------------------------------------------------------
      $this->Linking();
      #-------------------------------------------------------------------------
      break;
    }
  }
  #-----------------------------------------------------------------------------
  $Trigger = SPrintF('Triggers/DOM/Before/%s',$this->TemplateID);
  #-----------------------------------------------------------------------------
  if($this->TemplateID){
    #---------------------------------------------------------------------------
    if(!Is_Error(System_Element(SPrintF('comp/%s.comp.php',$Trigger)))){
      #-------------------------------------------------------------------------
      $LinkID = UniqID('DOM-');
      #-------------------------------------------------------------------------
      $Links = &Links();
      # Коллекция ссылок
      $Links[$LinkID] = &$this;
      #-------------------------------------------------------------------------
      $Comp = Comp_Load($Trigger,$LinkID,COMP_ALL_HOSTS);
      if(Is_Error($Comp))
        return ERROR | @Trigger_Error('[DOM->Load]: ошибка загрузки предобработчика');
      #-------------------------------------------------------------------------
      UnSet($Links[$LinkID]);
    }
  }
  #-----------------------------------------------------------------------------
  return TRUE;
}
#-------------------------------------------------------------------------------
/**
* Производит линковку документа
*
* Формирует массив ссылок на объекты, исходя из идентификаторов объектов.
*/
public function Linking(&$Object = NULL){
  /****************************************************************************/
  $__args_types = Array('object,NULL');
  #-----------------------------------------------------------------------------
  $__args__ = Func_Get_Args(); Eval(FUNCTION_INIT);
  /****************************************************************************/
  if(Is_Null($Object)){
    #---------------------------------------------------------------------------
    $Object = &$this->Object;
    #---------------------------------------------------------------------------
    $this->Links = Array();
  }
  #-----------------------------------------------------------------------------
  $Attribs = $Object->Attribs;
  #-----------------------------------------------------------------------------
  if(Count($Attribs) > 0){
    #---------------------------------------------------------------------------
    if(IsSet($Attribs['id'])){
      #-------------------------------------------------------------------------
      $LinkID = $Attribs['id'];
      #-------------------------------------------------------------------------
      if(IsSet($this->Links[$LinkID]))
        $LinkID = UniqID(SPrintF('%s#',$LinkID));
      #-------------------------------------------------------------------------
      $this->Links[$LinkID] = &$Object;
    }
  }
  #-----------------------------------------------------------------------------
  $Childs = &$Object->Childs;
  #-----------------------------------------------------------------------------
  if(Count($Childs) > 0){
    #---------------------------------------------------------------------------
    $ChildsIDs = Array_Keys($Childs);
    #---------------------------------------------------------------------------
    foreach($ChildsIDs as $ChildID){
      #-------------------------------------------------------------------------
      $Child = &$Childs[$ChildID];
      #-------------------------------------------------------------------------
      if(Is_Null($Child))
        UnSet($Childs[$ChildID]);
      else
        $this->Linking($Child);
    }
  }
}
#-------------------------------------------------------------------------------
/**
* Создает коолекцию ссылок на объекты документа
*
* Осуществляет поиск объектов с определённым именем тэга и возвращает их
* в качестве массива ссылок.
*
* @param string <имя тега>
*/
public function GetByTagName($TagName,&$Object = NULL,&$Result = Array()){
  /****************************************************************************/
  $__args_types = Array('string','object,NULL','array');
  #-----------------------------------------------------------------------------
  $__args__ = Func_Get_Args(); Eval(FUNCTION_INIT);
  /****************************************************************************/
  if(Is_Null($Object))
    $Object = &$this->Object;
  #-----------------------------------------------------------------------------
  if(StrTolower($Object->Name) == StrTolower($TagName))
    $Result[] = &$Object;
  #-----------------------------------------------------------------------------
  $Childs = &$Object->Childs;
  #-----------------------------------------------------------------------------
  if(Count($Childs) > 0){
    #---------------------------------------------------------------------------
    $ChildsIDs = Array_Keys($Childs);
    #---------------------------------------------------------------------------
    foreach($ChildsIDs as $ChildID){
      #-------------------------------------------------------------------------
      $Child = &$Childs[$ChildID];
      #-------------------------------------------------------------------------
      $this->GetByTagName($TagName,$Child,$Result);
    }
  }
  #-----------------------------------------------------------------------------
  return $Result;
}
#-------------------------------------------------------------------------------
/**
* Производит нормализацию объекта
*
* Удаляет всю служебную информацию, подргужает компоненты в документ,
* подготавливает объект к выводу.
*/
public function Normalize(&$Object = NULL){
  /****************************************************************************/
  $__args_types = Array('object,NULL');
  #-----------------------------------------------------------------------------
  $__args__ = Func_Get_Args();Eval(FUNCTION_INIT);
  /****************************************************************************/
  if(Is_Null($Object))
    $Object = &$this->Object;
  #-----------------------------------------------------------------------------
  $Childs = &$Object->Childs;
  #-----------------------------------------------------------------------------
  if(Count($Childs) > 0){
    #---------------------------------------------------------------------------
    $i = 0;
    #---------------------------------------------------------------------------
    while($i<Count($ChildsIDs = Array_Keys($Childs))){
      #-------------------------------------------------------------------------
      $Child = &$Childs[$ChildID = $ChildsIDs[$i]];
      #-------------------------------------------------------------------------
      $Name = $Child->Name;
      #-------------------------------------------------------------------------
      switch($Name){
        case 'NOBODY':
          #---------------------------------------------------------------------
          $Object->AddAttribs($Child->Attribs);
          #---------------------------------------------------------------------
          $Object->AddText($Child->Text);
          #---------------------------------------------------------------------
          Array_Splice($Childs,$ChildID,1,$Child->Childs);
        continue 2;
        case 'COMP':
          #---------------------------------------------------------------------
          $Attribs = &$Child->Attribs;
          #---------------------------------------------------------------------
          $IsHasChilds = (Count($Object->Childs) > 0);
          #---------------------------------------------------------------------
          $FunctionID = ($IsHasChilds?'AddChild':'AddText');
          #---------------------------------------------------------------------
          $CompPath = (string)@$Attribs['path'];
          #---------------------------------------------------------------------
          if(Is_Error(System_Element(SPrintF('comp/%s.comp.php',$CompPath)))){
            #-------------------------------------------------------------------
            $String = SPrintF('Компонент не найден (%s)',$CompPath);
            #-------------------------------------------------------------------
            $Object->$FunctionID($IsHasChilds?new Tag('SPAN',$String):$String);
          }else{
            #-------------------------------------------------------------------
            $Args = (IsSet($Attribs['args'])?Explode('|',$Attribs['args']):Array());
            #-------------------------------------------------------------------
            Array_UnShift($Args,$CompPath);
            #-------------------------------------------------------------------
            $Comp = Call_User_Func_Array('Comp_Load',$Args);
            #-------------------------------------------------------------------
            switch($Type = ValueOf($Comp)){
              case 'error':
                #---------------------------------------------------------------
                $String = SPrintF('Ошибка загрузки компонента (%s)',$CompPath);
                #---------------------------------------------------------------
                if(IsSet($Attribs['debug']))
                  $Object->AddChild(new Tag('PRE',Implode("\n",$GLOBALS['__SYSLOG'])));
                else
                  $Object->$FunctionID($IsHasChilds?new Tag('SPAN',$String):$String);
              break 2;
              case 'exception':
                #---------------------------------------------------------------
                $String = $Comp->String;
                #---------------------------------------------------------------
                $Object->$FunctionID($IsHasChilds?new Tag('SPAN',$String):$String);
              break 2;
              case 'object':
                $Child = $Comp;
              break 2;
              case 'string':
                #---------------------------------------------------------------
                $Object->AddText($Comp);
                #---------------------------------------------------------------
                Array_Splice($Childs,$ChildID,1,$Child->Childs);
              continue 3;
              case 'false':
                # No more...
              case 'true':
                # No more...
              break 2;
              default:
                #---------------------------------------------------------------
                $String = SPrintF('Компонент вернул результат неверного типа (%s)',$Type);
                #---------------------------------------------------------------
                $Object->$FunctionID($IsHasChilds?new Tag('SPAN',$String):$String);
            }
          }
        default:
          # No more...
      }
      #-------------------------------------------------------------------------
      $i++;
      #-------------------------------------------------------------------------
      $this->Normalize($Child);
    }
  }
}
#-------------------------------------------------------------------------------
/**
* Применяет пользовательскую функцию ко всему объекту
*
* Пользователь формирует свою функцию, а затем с помощью $Function  передает ее
* имя в функцию Apply().
*
* @param string <имя функции>
* @param object <объект типа Tag>
*/
public function Apply($Function,&$Object = NULL){
  /****************************************************************************/
  $__args_types = Array('string','object,NULL');
  #-----------------------------------------------------------------------------
  $__args__ = Func_Get_Args();Eval(FUNCTION_INIT);
  /****************************************************************************/
  if(Is_Null($Object))
    $Object = &$this->Object;
  #-----------------------------------------------------------------------------
  $Function($Object);
  #-----------------------------------------------------------------------------
  $Childs = &$Object->Childs;
  #-----------------------------------------------------------------------------
  if(Count($Childs) > 0){
    #---------------------------------------------------------------------------
    $ChildsIDs = Array_Keys($Childs);
    #---------------------------------------------------------------------------
    foreach($ChildsIDs as $ChildID){
      #-------------------------------------------------------------------------
      $Child = &$Childs[$ChildID];
      #-------------------------------------------------------------------------
      $this->Apply($Function,$Child);
    }
  }
}
#-------------------------------------------------------------------------------
/**
* Добавляет аттрибуты в тег
*
* Добавляет в тег, которому  ранне был присвоен свой ID - $Names (при формировании инициа-
* лизирующей строки и передачи ее в конструктор класса DOM или при создании
* объекта класса Tag), аттрибут $Attribs, который является массивом. Одновременно
* можно организовать добавление нескольких аттрибутов. Если $IsRewrite = TRUE, то
* тег записывается поверх установленных ранее тегов.
*
* @param string <идентификатор тега>
* @param array <массив атрибутов и их значений>
* @param boolean <замена предыдущих аттрибутов>
*/
public function AddAttribs($Names,$Attribs,$IsRewrite = FALSE){
  /****************************************************************************/
  $__args_types = Array('string','array','boolean');
  #-----------------------------------------------------------------------------
  $__args__ = Func_Get_Args();Eval(FUNCTION_INIT);
  /****************************************************************************/
  $Names = Explode(',',$Names);
  #-----------------------------------------------------------------------------
  foreach(Array_Keys($this->Links) as $LinkID){
    #---------------------------------------------------------------------------
    foreach($Names as $Name){
      #-------------------------------------------------------------------------
      if(Preg_Match(SPrintF('/^%s(#[a-zA-Z0-9]+){0,1}$/',$Name),$LinkID)){
        #-----------------------------------------------------------------------
        # Debug(SPrintF('[DOM->AddAttribs]: добавление атрибутов по ссылке (%s -> %s)',$Name,$LinkID));
        #-----------------------------------------------------------------------
        $this->Links[$LinkID]->AddAttribs($Attribs,$IsRewrite);
      }
    }
  }
}
#-------------------------------------------------------------------------------
/**
* Вставляет текст в тег для вывода в браузер
*
* В переменную $Text записывается текст. Значение $Text вставляется в тег, которому  ранне
* был присвоен свой ID - $Names (при формировании инициализирующей строки и передачи
* ее в конструктор класса DOM или при создании объекта класса Tag). Если $IsRewrite = true,
* то предыдущая запись стирается.
*
* @param string <идентификатор тега>
* @param string <текст>
* @param boolean <замена предыдущих записей>
*/
public function AddText($Names,$Text,$IsRewrite = FALSE){
  /****************************************************************************/
  $__args_types = Array('string','string','boolean');
  #-----------------------------------------------------------------------------
  $__args__ = Func_Get_Args(); Eval(FUNCTION_INIT);
  /****************************************************************************/
  $Names = Explode(',',$Names);
  #-----------------------------------------------------------------------------
  foreach(Array_Keys($this->Links) as $LinkID){
    #---------------------------------------------------------------------------
    foreach($Names as $Name){
      #-------------------------------------------------------------------------
      if(Preg_Match(SPrintF('/^%s(#[a-zA-Z0-9]+){0,1}$/',$Name),$LinkID)){
        #-----------------------------------------------------------------------
        # Debug(SPrintF('[DOM->AddText]: добавление атрибутов по ссылке (%s -> %s)',$Name,$LinkID));
        #-----------------------------------------------------------------------
        $this->Links[$LinkID]->AddText($Text,$IsRewrite);
      }
    }
  }
}
#-------------------------------------------------------------------------------
/**
* Добавляет объект в тег
*
* Данная функция служит для добавления объекта $Child в тег, которому  ранне был присвоен свой ID - $Names
* (при формировании инициализирующей строки и передачи ее в конструктор класса DOM или
* при создании объекта класса Tag). Обычно служит для создания вложенных тегов.
* Если $IsAfter = true, то $Child вставляется в начало списка объектов. $Child - экземпляр
* класса Tag.
*
* @param string <идентификатор тега>
* @param object <передаваемый объект>
* @param boolean <вставка в началло списка объектов>
*/
public function AddChild($Names,$Child,$IsAfter = FALSE){
  /****************************************************************************/
  $__args_types = Array('string','object','boolean');
  #-----------------------------------------------------------------------------
  $__args__ = Func_Get_Args(); Eval(FUNCTION_INIT);
  /****************************************************************************/
  $Names = Explode(',',$Names);
  #-----------------------------------------------------------------------------
  foreach(Array_Keys($this->Links) as $LinkID){
    #---------------------------------------------------------------------------
    foreach($Names as $Name){
      #-------------------------------------------------------------------------
      if(Preg_Match(SPrintF('/^%s(#[a-zA-Z0-9]+){0,1}$/',$Name),$LinkID)){
        #-----------------------------------------------------------------------
        # Debug(SPrintF('[DOM->AddChild]: добавление атрибутов по ссылке (%s -> %s)',$Name,$LinkID));
        #-----------------------------------------------------------------------
        $Index = &$this->Links[$LinkID]->AddChild($Child,$IsAfter);
        #-----------------------------------------------------------------------
        $this->Linking($Index);
      }
    }
  }
}
#-------------------------------------------------------------------------------
/**
* Вставляет HTML код
*
* Функция вставляет HTML код $HTML в тег которому  ранне был присвоен свой ID - $Names
* (при формировании инициализирующей строки и передачи ее в конструктор класса DOM или
* при создании объекта класса Tag). Если $IsAfter = true, то $HTML вставляется в начало
* списка тегов.
*
* @param string <идентификатор тега>
* @param string <HTML код>
* @param boolean <вставка в начало списка тегов>
*/
public function AddHTML($Names,$HTML,$IsAfter = FALSE){
  /****************************************************************************/
  $__args_types = Array('string','string','boolean');
  #-----------------------------------------------------------------------------
  $__args__ = Func_Get_Args(); Eval(FUNCTION_INIT);
  /****************************************************************************/
  $Names = Explode(',',$Names);
  #-----------------------------------------------------------------------------
  foreach(Array_Keys($this->Links) as $LinkID){
    #---------------------------------------------------------------------------
    foreach($Names as $Name){
      #-------------------------------------------------------------------------
      if(Preg_Match(SPrintF('/^%s(#[a-zA-Z0-9]+){0,1}$/',$Name),$LinkID)){
        #-----------------------------------------------------------------------
        # Debug(SPrintF('[DOM->AddHTML]: добавление атрибутов по ссылке (%s -> %s)',$Name,$LinkID));
        #-----------------------------------------------------------------------
        $Indexes = $this->Links[$LinkID]->AddHTML($HTML,$IsAfter);
        #-----------------------------------------------------------------------
        for($i=0;$i<Count($Indexes);$i++)
          $this->Linking($Indexes[$i]);
      }
    }
  }
}
#-------------------------------------------------------------------------------
/**
* Удаляет идентификаторы тегов
*
* Функция необходима в случае, когда необходимо исключить id тега из списка всех аттрибутов данного тега.
*/
public function DeleteIDs(){
  #-----------------------------------------------------------------------------
  $Names = Func_Get_Args();
  #-----------------------------------------------------------------------------
  $Links = &$this->Links;
  #-----------------------------------------------------------------------------
  foreach(Array_Keys($Links) as $LinkID){
    #---------------------------------------------------------------------------
    $Attribs = &$Links[$LinkID]->Attribs;
    #---------------------------------------------------------------------------
    if(IsSet($Attribs['id'])){
      #-------------------------------------------------------------------------
      if(Count($Names)){
        #-----------------------------------------------------------------------
        if(In_Array($Attribs['id'],$Names))
          UnSet($Attribs['id']);
      }else
        UnSet($Attribs['id']);
    }
  }
}
#-------------------------------------------------------------------------------
/**
* Удаляет объект из списка объектов
*
* Функция удаляет объект из массива ссылок на объкты по идентификатору $LinkID.
*
* @param string <идентификатор ссылки>
*/
public function Delete($LinkID){
  #-----------------------------------------------------------------------------
  $Names = Func_Get_Args();
  #-----------------------------------------------------------------------------
  foreach(Array_Keys($this->Links) as $LinkID){
    #---------------------------------------------------------------------------
    foreach($Names as $Name){
      #-------------------------------------------------------------------------
      if(Preg_Match(SPrintF('/^%s(#[a-zA-Z0-9]+){0,1}$/',$Name),$LinkID)){
        #-----------------------------------------------------------------------
        # Debug(SPrintF('[DOM->Delete]: удаление объектов по ссылке (%s -> %s)',$Name,$LinkID));
        #-----------------------------------------------------------------------
        $this->Links[$LinkID] = NULL;
      }
    }
  }
  #-----------------------------------------------------------------------------
  $this->Linking();
}
#-------------------------------------------------------------------------------
/**
* Формирует объект
*
* Сформировывает объект класса DOM и подготавливает к выводу в браузер. После
* вызова этой функции переменная, куда записывался результат выполнения функции
* выводится с помощью оператора echo.
*
* @param boolean <необходимость преобразования в XML строку>
*/
public function Build($IsToXML = TRUE){
  #-----------------------------------------------------------------------------
  if($this->TemplateID){
    #---------------------------------------------------------------------------
    $Trigger = SPrintF('Triggers/DOM/After/%s',$this->TemplateID);
    #---------------------------------------------------------------------------
    if(!Is_Error(System_Element(SPrintF('comp/%s.comp.php',$Trigger)))){
      #-------------------------------------------------------------------------
      $LinkID = UniqID('DOM-');
      #-------------------------------------------------------------------------
      $Links = &Links();
      # Коллекция ссылок
      $Links[$LinkID] = &$this;
      #-------------------------------------------------------------------------
      if(Is_Error(Comp_Load($Trigger,$LinkID,COMP_ALL_HOSTS)))
        return ERROR | @Trigger_Error('[DOM->Build]: ошибка загрузки предобработчика');
      #-------------------------------------------------------------------------
      UnSet($Links[$LinkID]);
    }
  }
  #-----------------------------------------------------------------------------
  # Номализация документа
  $this->Normalize();
  #-----------------------------------------------------------------------------
  $this->Apply('Sources');
  #-----------------------------------------------------------------------------
  if($IsToXML){
    #---------------------------------------------------------------------------
    $Result = $this->Object->ToXMLString();
    if(Is_Error($Result))
      return ERROR | Trigger_Error('[DOM->Build]: не удалось преобразовать DOM в строку');
    #---------------------------------------------------------------------------
    return SPrintF("<!-- Joonte Billing System https://www.joonte.com -->\n%s",$Result);
  }
  #-----------------------------------------------------------------------------
  return TRUE;
}
#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
function Sources(&$Object){
  #-----------------------------------------------------------------------------
  $Attribs = &$Object->Attribs;
  #-----------------------------------------------------------------------------
  foreach(Array('src','style','href','onclick') as $AttribID){
    #---------------------------------------------------------------------------
    if(!IsSet($Attribs[$AttribID]))
      continue;
    #---------------------------------------------------------------------------
    $Attrib = &$Attribs[$AttribID];
    #---------------------------------------------------------------------------
    if(Preg_Match_All('/SRC\:\{([a-zA-Z0-9\.\/\_\-]+)[?a-zA-Z\=\,]*\}/',$Attrib,$Matches)){
      #-------------------------------------------------------------------------
      $Matches = Array_Combine(Current($Matches),Next($Matches));
      #-------------------------------------------------------------------------
      foreach(Array_Keys($Matches) as $What){
        #-----------------------------------------------------------------------
        $Url = Styles_Url($Matches[$What]);
        if(!Is_Error($Url))
          $Attrib = Str_Replace($What,$Url,$Attrib);
      }
    }
  }
}
#-------------------------------------------------------------------------------
?>
