<?php
#-------------------------------------------------------------------------------
/** @author Бреславский А.В. (Joonte Ltd.) */
#-------------------------------------------------------------------------------
class Session{
#-------------------------------------------------------------------------------
# Идентификатор сессии
public $SessionID = '';
# Данные сессии
public $Data = Array();
#-------------------------------------------------------------------------------
function __construct($SessionID){
	#-------------------------------------------------------------------------------
	if(Preg_Match('/^[0-9a-zA-Z]{8,64}$/u',$SessionID)){
		#-------------------------------------------------------------------------------
		$this->SessionID = $SessionID;
		#-------------------------------------------------------------------------------
	}else{
		#-------------------------------------------------------------------------------
		Debug(SPrintF('[system/classes/Session]: мусор в имени сессии: %s',$SessionID));
		#-------------------------------------------------------------------------------
		$this->SessionID = FALSE;
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
}

#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
public function Load(){
  #-----------------------------------------------------------------------------
  $SessionID = $this->SessionID;
  #-----------------------------------------------------------------------------
  if(!$SessionID)
    return FALSE;
  #-----------------------------------------------------------------------------
  $Tmp = System_Element('tmp');
  if(Is_Error($Tmp))
    return ERROR | @Trigger_Error('[Session->Load]: не удалось найти временную папку');
  #-----------------------------------------------------------------------------
  $Path = SPrintF('%s/sessions/%s',$Tmp,$SessionID);
  #-----------------------------------------------------------------------------
  if(!File_Exists($Path))
    return FALSE;
  #-----------------------------------------------------------------------------
  $Content = IO_Read($Path);
  if(Is_Error($Content))
    return ERROR | @Trigger_Error('[Session->Load]: не удалось прочитать файл сессии');
  #-----------------------------------------------------------------------------
  #$this->Data = @UnSerialize($Content);
  $this->Data = @JSON_Decode($Content,true);
  if($this->Data === FALSE)
    return ERROR | @Trigger_Error('[Session->Load]: не удалось восстановить данные из файла сессии');
  #-----------------------------------------------------------------------------
  return TRUE;
}
#-------------------------------------------------------------------------------
public function Save(){
  #-----------------------------------------------------------------------------
  $SessionID = $this->SessionID;
  #-----------------------------------------------------------------------------
  if(!$SessionID)
    return ERROR | @Trigger_Error('[Session->Save]: пустой идентификатор сессии');
  #-----------------------------------------------------------------------------
  $Tmp = System_Element('tmp');
  if(Is_Error($Tmp))
    return ERROR | @Trigger_Error('[Session->Save]: не удалось найти временную папку');
  #-----------------------------------------------------------------------------
  #$IsWrited = IO_Write(SPrintF('%s/sessions/%s',$Tmp,$SessionID),Serialize($this->Data),TRUE);
  $IsWrited = IO_Write(SPrintF('%s/sessions/%s',$Tmp,$SessionID),JSON_Encode($this->Data),TRUE);
  if(Is_Error($IsWrited))
    return ERROR | @Trigger_Error('[Session->Save]: не удалось сохранить сессию');
  #-----------------------------------------------------------------------------
  return TRUE;
}
#-------------------------------------------------------------------------------
public function IsExists(){
  #-----------------------------------------------------------------------------
  $SessionID = $this->SessionID;
  #-----------------------------------------------------------------------------
  if(!$SessionID)
    return FALSE;
  #-----------------------------------------------------------------------------
  $Tmp = System_Element('tmp');
  if(Is_Error($Tmp))
    return ERROR | @Trigger_Error('[Session->IsExists]: не удалось найти временную папку');
  #-----------------------------------------------------------------------------
  if(!File_Exists(SPrintF('%s/sessions/%s',$Tmp,$SessionID)))
    return FALSE;
  #-----------------------------------------------------------------------------
  return TRUE;
}
#-------------------------------------------------------------------------------
public function Delete(){
  #-----------------------------------------------------------------------------
  $SessionID = $this->SessionID;
  #-----------------------------------------------------------------------------
  if(!$SessionID)
    return ERROR | @Trigger_Error('[Session->Delete]: пустой идентификатор сессии');
  #-----------------------------------------------------------------------------
  $Tmp = System_Element('tmp');
  if(Is_Error($Tmp))
    return ERROR | @Trigger_Error('[Session->Delete]: не удалось найти временную папку');
  #-----------------------------------------------------------------------------
  if(!UnLink(SPrintF('%s/sessions/%s',$Tmp,$SessionID)))
    return ERROR | @Trigger_Error('[Session->Delete]: не удалось удалить файл сессии');
  #-----------------------------------------------------------------------------
  return TRUE;
}
#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
?>
