<?php
/**
 * Manage of system cache.
 *
 * @author vvelikodny
 */
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
class CacheManager {
	#-------------------------------------------------------------------------------
	/** Cache singleton instance. */
	protected static $instance = NULL;
	#-------------------------------------------------------------------------------
	public static function init() {
		#-------------------------------------------------------------------------------
		if(self::$instance === NULL){
			#-------------------------------------------------------------------------------
			try{
				#-------------------------------------------------------------------------------
				Debug("[system/classes/auto/CacheManager.class.php]: Start initializing cache system.");
				#-------------------------------------------------------------------------------
				$CacheSystems = Array('Memcached','APCu','Memcache','APC');
				#-------------------------------------------------------------------------------
				// перебираем системы кэширования, пробуем загрузить ту что указана принудительно
				foreach($CacheSystems as $CacheSystem){
					#-------------------------------------------------------------------------------
					// кастыль для php 5.6
					$className = SPrintF('%sCache',$CacheSystem);
					#-------------------------------------------------------------------------------
					// проверяем наличие файла по имени php-модуля
					if(File_Exists(SPrintF('%s/.%s',SYSTEM_PATH,$className::EXT_NAME))){
						#-------------------------------------------------------------------------------
						// проверяем, загружено ли расширение php
						if(Extension_Loaded($className::EXT_NAME)){
							#-------------------------------------------------------------------------------
							Debug(SPrintF('[system/classes/auto/CacheManager.class.php]: Force load %s',$className));
							#-------------------------------------------------------------------------------
							self::$instance = $className::getInstance();
							#-------------------------------------------------------------------------------
							break;
							#-------------------------------------------------------------------------------
						}
						#-------------------------------------------------------------------------------
					}
					#-------------------------------------------------------------------------------
				}
				#-------------------------------------------------------------------------------
				#-------------------------------------------------------------------------------
				// если принудительно ничего не загрузилось, то перебираем все, и грузим первую найденную
				if(self::$instance === NULL){
					#-------------------------------------------------------------------------------
					foreach($CacheSystems as $CacheSystem){
						#-------------------------------------------------------------------------------
						// кастыль для php 5.6
						$className = SPrintF('%sCache',$CacheSystem);
						#-------------------------------------------------------------------------------
						if(Extension_Loaded($className::EXT_NAME)){
							#-------------------------------------------------------------------------------
							Debug(SPrintF('[system/classes/auto/CacheManager.class.php]: load %s',$className));
							#-------------------------------------------------------------------------------
							self::$instance = $className::getInstance();
							#-------------------------------------------------------------------------------
							break;
							#-------------------------------------------------------------------------------
						}
						#-------------------------------------------------------------------------------
					}
					#-------------------------------------------------------------------------------
				}
				#-------------------------------------------------------------------------------
				#-------------------------------------------------------------------------------
				// ничего не загрузилось
				if(self::$instance === NULL)
					throw new Exception("Any supported cache not installed in your sysytem.");
				#-------------------------------------------------------------------------------
				#-------------------------------------------------------------------------------
				Debug("Cache system has been initialized.");
				#-------------------------------------------------------------------------------
			}
			#-------------------------------------------------------------------------------
			#-------------------------------------------------------------------------------
			catch(Exception $e){
				#-------------------------------------------------------------------------------
				Debug("Cache system has not been installed: ".$e->getTraceAsString());
				#-------------------------------------------------------------------------------
			}
			#-------------------------------------------------------------------------------
			#-------------------------------------------------------------------------------
		}
		#-------------------------------------------------------------------------------
		return self::$instance;
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	protected function __construct() { }
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	/**
	* Adds new pair key/value to cache.
	*
	* @return
	*/
	#-------------------------------------------------------------------------------
	public static function add($key, $value, $ttl = 0) {
		#-------------------------------------------------------------------------------
		if (self::isEnabled()) {
			#-------------------------------------------------------------------------------
			//Debug(sprintf("Adds new key/value to cache [key=%s, ttl=%d]", $key, $ttl));
			return self::$instance->add($key, $value, $ttl);
			#-------------------------------------------------------------------------------
		}
		#-------------------------------------------------------------------------------
		return FALSE;
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	/**
	* Gets value for given key from cache.
	*
	* @return
	*/
	#-------------------------------------------------------------------------------
	public static function get($key) {
		#-------------------------------------------------------------------------------
		if (self::isEnabled()) {
			#-------------------------------------------------------------------------------
			//Debug(sprintf("Gets value from cache [key=%s]", $key));
			return self::$instance->get($key);
			#-------------------------------------------------------------------------------
		}
		#-------------------------------------------------------------------------------
		return FALSE;
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	public static function flush() {
		#-------------------------------------------------------------------------------
		if (self::isEnabled()) {
			#-------------------------------------------------------------------------------
			Debug("Flush the system cache.");
			#-------------------------------------------------------------------------------
			return self::$instance->flush();
			#-------------------------------------------------------------------------------
		}
		#-------------------------------------------------------------------------------
		return FALSE;
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	public static function getStat() {
		#-------------------------------------------------------------------------------
		if (self::isEnabled()) {
			#-------------------------------------------------------------------------------
			return self::$instance->getStatistic();
			#-------------------------------------------------------------------------------
		}
		#-------------------------------------------------------------------------------
		return FALSE;
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	public static function isEnabled() {
		#-------------------------------------------------------------------------------
		return IsSet(self::$instance);
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------

?>
