<?php

#-------------------------------------------------------------------------------
/** @author Alex Keda for www.host-food.ru */
/******************************************************************************/
/******************************************************************************/
require_once 'Cache.class.php';
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
class MemcachedCache implements Cache {
	// PHP lib name.
	const EXT_NAME = 'memcached';
	// Default memcached port.
	const DFLT_PORT = 11211;

	protected static $memcached;

	// Memcached singleton instance
	protected static $instance;

	// Constructor
	private function __construct(){
		#-------------------------------------------------------------------------------
		Debug("Initializing memcached system...");
		#-------------------------------------------------------------------------------
		// Check library.
		if(!Extension_Loaded(self::EXT_NAME))
			throw new Exception(SPrintF("PHP extension %s not installed or enabled in your system.", self::EXT_NAME));
		#-------------------------------------------------------------------------------
		$Port = (IsSet($GLOBALS['HOST_CONF']['memcached.port'])?$GLOBALS['HOST_CONF']['memcached.port']:self::DFLT_PORT);
		#-------------------------------------------------------------------------------
		self::$memcached = new Memcached();
		self::$memcached->addServer('localhost', $Port, 1);
		#-------------------------------------------------------------------------------
		#-------------------------------------------------------------------------------
		$version = self::$memcached->getVersion();
		#-------------------------------------------------------------------------------
		// сбрасываем указатель массива
		Reset($version);
		Debug(SPrintF('[Memcached]: memcached connected [version=%s]', $version[Key($version)]));
		#-------------------------------------------------------------------------------
	}

	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	private function __clone() {}

	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	// Gets Memcached instance if exists, otherwise creates a new instance.
	// @return Memcached instance.
	public static function getInstance(){
		#-------------------------------------------------------------------------------
		if(self::$instance === null){
			#-------------------------------------------------------------------------------
			self::$instance = new self;
			#-------------------------------------------------------------------------------
		}
		#-------------------------------------------------------------------------------
		return self::$instance;
		#-------------------------------------------------------------------------------
	}

	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	function add($key, $value, $time = 0) {
		#-------------------------------------------------------------------------------
		// Checks args.
		$__args_types = Array('string', 'boolean,integer,double,string,array,object', 'integer');
		$__args__ = Func_Get_Args(); Eval(FUNCTION_INIT);
		#-------------------------------------------------------------------------------
		$key = SPrintF('[%s]-[%s]-%s', HOST_ID, self::EXT_NAME, $key);
		#-------------------------------------------------------------------------------
		$result = self::$memcached->add($key, $value, $time);
		#-------------------------------------------------------------------------------
		if(!$result){
			#-------------------------------------------------------------------------------
			Debug(SPrintF('[MemcachedCache::add]: не удалось закешировать объект [key=%s]', $key));
			#-------------------------------------------------------------------------------
			// пробуем тупо удалить ключ и воткнуть значение заново, ибо ключи у memcached нельзя перезаписывать
			$IsDelete = self::$memcached->delete($key);
			$result = self::$memcached->add($key, $value, $time);
		}
		#-------------------------------------------------------------------------------
		return $result;
		#-------------------------------------------------------------------------------
	}

	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	function get($key){
		#-------------------------------------------------------------------------------
		// Check args.
		$__args_types = Array('string');
		$__args__ = Func_Get_Args(); Eval(FUNCTION_INIT);
		#-------------------------------------------------------------------------------
		$key = SPrintF('[%s]-[%s]-%s', HOST_ID, self::EXT_NAME, $key);
		#-------------------------------------------------------------------------------
		$result = self::$memcached->get($key);
		#-------------------------------------------------------------------------------
		if(!$result && !Is_Array($result))
			Debug(SPrintF('[MemcachedCache::get]: не удалось извлечь объект [key=%s]', $key));
		#-------------------------------------------------------------------------------
		return $result;
		#-------------------------------------------------------------------------------
	}

	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	function flush(){
		#-------------------------------------------------------------------------------
		$result = self::$memcached->flush();
		#-------------------------------------------------------------------------------
		if(!$result)
			Debug('[MemcachedCache::flush]: не удалось очистить память');
		#-------------------------------------------------------------------------------
		return $result;
		#-------------------------------------------------------------------------------
	}

	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	function getStatistic() {
		#-------------------------------------------------------------------------------
		$result = self::$memcached->getStats();
		#-------------------------------------------------------------------------------
		if($result === FALSE) {
			#-------------------------------------------------------------------------------
			Debug('[MemcachedCache::getStatistic]: не удалось получить статистику кэшированной памяти');
			#-------------------------------------------------------------------------------
		}else{
			#-------------------------------------------------------------------------------
			Reset($result);
			#-------------------------------------------------------------------------------
			$result = $result[Key($result)];
			#-------------------------------------------------------------------------------
			$result['type'] = self::EXT_NAME;
			#-------------------------------------------------------------------------------
		}
		#-------------------------------------------------------------------------------
		return $result;
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
?>
