<?php
#-------------------------------------------------------------------------------
/** @author Великодный В.В. (Joonte Ltd.) */
#-------------------------------------------------------------------------------
class MySQL extends stdClass{
	#-------------------------------------------------------------------------------
	# Ссыклка на соединения
	private $Link = NULL;
	# Последний выполненный запрос
	private $Query = "";
	/*------------------------------------------------------------------------------
	      Задача:
	Создать объект MySQL.
	------------------------------------------------------------------------------*/
	function __construct($Settings = Array()){
		#-------------------------------------------------------------------------------
		$this->Settings = Array(
					'Server'	=> 'localhost',
					'Port'		=> 3306,
					'User'		=> 'root',
					'Password'	=> '*',
					'DbName'	=> 'UnSelected'
					);
		#-------------------------------------------------------------------------------
		Array_Union($this->Settings,$Settings);
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	public function GetLink() {
		#-------------------------------------------------------------------------------
		return $this->Link;
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	public function Escape($String){
		#-------------------------------------------------------------------------------
		if(!$String)
			return $String;
		#-------------------------------------------------------------------------------
		if(!$this->Link)
			return ERROR | @Trigger_Error('[MySQLi->Escape]: нет соединения с MySQL');
		#-------------------------------------------------------------------------------
		$this->Escape = $String;
		#-------------------------------------------------------------------------------
		$Result = MySQLi_Real_Escape_String($this->Link,$String);
		if($Result)
			return $Result;
		#-------------------------------------------------------------------------------
		$Error = $this->GetError();
		#-------------------------------------------------------------------------------
		return ERROR | @Trigger_Error(SPrintF('[MySQLi->Escape]: %s',$Error));
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	/*------------------------------------------------------------------------------
	      Задача:
	Открыть соединение с базой данных.
	------------------------------------------------------------------------------*/
	public function Open(){
		#-------------------------------------------------------------------------------
		$Settings = $this->Settings;
		#-------------------------------------------------------------------------------
		$Address = SPrintF('%s:%u',$Settings['Server'],$Settings['Port']);
		#-------------------------------------------------------------------------------
		$this->Link = @MySQLi_Connect($Settings['Server'],$User = $Settings['User'],$Settings['Password'],$Settings['DbName'],$Settings['Port']);
		#-------------------------------------------------------------------------------
		if(!$this->Link)
			return ERROR | @Trigger_Error(SPrintF('[MySQLi->Open]: не возможно соединиться с (%s@%s)',$User,$Address));
		#-------------------------------------------------------------------------------
		Debug(SPrintF('[MySQLi->Open]: связь как (%s@%s) установлена',$User,$Address));
		#-------------------------------------------------------------------------------
		$Init = System_XML('config/MySqlInit.xml');
		#-------------------------------------------------------------------------------
		if(Is_Error($Init))
			return ERROR | @Trigger_Error('[MySQLi->Open]: не возможно загрузить запросы инициализации');
		#-------------------------------------------------------------------------------
		foreach($Init as $Query)
			if(Is_Error($this->Query($Query)))
				return ERROR | @Trigger_Error('[MySQLi->Open]: не удалось произвести инициализацию подключения');
		#-------------------------------------------------------------------------------
		return TRUE;
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	/*------------------------------------------------------------------------------
	      Задача:
	Закрыть соединение с базой данных.
	------------------------------------------------------------------------------*/
	public function Close(){
		#-----------------------------------------------------------------------------
		if(!$this->Link)
			return ERROR | @Trigger_Error('[MySQLi->Close]: нет соединения с MySQL');
		#-------------------------------------------------------------------------------
		$IsClose = MySQLi_Close($this->Link);
		if(!$IsClose)
			return ERROR | @Trigger_Error('[MySQLi->Close]: ошибка закрытия соединения с MySQL');
		#-------------------------------------------------------------------------------
		Debug('[MySQLi->Close]: закрываем соединение с MySQL');
		#-------------------------------------------------------------------------------
		$this->Link = NULL;
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	/*------------------------------------------------------------------------------
		Задача:
	Выбрать базу данных.
	------------------------------------------------------------------------------*/
	public function SelectDB(){
		/******************************************************************************/
		$__args_types = Array('string');
		#-------------------------------------------------------------------------------
		$__args__ = Func_Get_Args(); Eval(FUNCTION_INIT);
		/******************************************************************************/
		if(!$this->Link)
			return ERROR | @Trigger_Error('[MySQLi->SelectDB]: нет соединения с MySQL');
		#-------------------------------------------------------------------------------
		$DbName = $this->Settings['DbName'];
		#-------------------------------------------------------------------------------
		$SqlResult = $this->Query(SPrintF('USE `%s`',$DbName));
		if(Is_Error($SqlResult))
			return ERROR | @Trigger_Error(SPrintF('[MySQLi->SelectDB]: невозможно выбрать базу данных (%s)',$DbName));
		#-------------------------------------------------------------------------------
		return TRUE;
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	/*------------------------------------------------------------------------------
	      Задача:
	Получить строку ошибки.
	------------------------------------------------------------------------------*/
	public function GetError(){
		#-------------------------------------------------------------------------------
		if(!$this->Link)
			return ERROR | @Trigger_Error('[MySQLi->GetError]: нет соединения с MySQL');
		#-------------------------------------------------------------------------------
		return MySQLi_Error($this->Link);
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	/*------------------------------------------------------------------------------
	      Задача:
	Выполнить запрос в базу данных.
	------------------------------------------------------------------------------*/
	public function Query($Query){
		#-------------------------------------------------------------------------------
		Debug('[MySQLi->Query]: выполняем запрос к MySQL');
		#-------------------------------------------------------------------------------
		if(!Is_String($Query))
			return ERROR | @Trigger_Error('[MySQLi->Query]: первый параметр не является строкой');
		#-------------------------------------------------------------------------------
		if(!$this->Link)
			return ERROR | @Trigger_Error('[MySQLi->Query]: нет соединения с MySQL');
		#-------------------------------------------------------------------------------
		Debug(SPrintF('[root/system/classes/auto/MySQL]: Query = %s',$Query));
		#-------------------------------------------------------------------------------
		$this->Query = $Query;
		#-------------------------------------------------------------------------------
		$Result = MySQLi_Query($this->Link,$Query);
		#Debug(SPrintF('[root/system/classes/auto/MySQL]: Result in Query = %s,',print_r($Result,true)));
		if($Result)
			return $Result;
		#-------------------------------------------------------------------------------
		$Error = $this->GetError();
		#-------------------------------------------------------------------------------
		return ERROR | @Trigger_Error(SPrintF('[MySQLi->Query]: %s',$Error));
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	/*------------------------------------------------------------------------------
	      Задача:
	Получить последний выполненный запрос.
	------------------------------------------------------------------------------*/
	public function GetQuery(){
		#-------------------------------------------------------------------------------
		return $this->Query;
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	/*------------------------------------------------------------------------------
	      Задача:
	Проверить наличие соединения с базой данных.
	------------------------------------------------------------------------------*/
	public function IsConnected(){
		#-------------------------------------------------------------------------------
		if(!$this->Link)
			return FALSE;
		#-------------------------------------------------------------------------------
		return (bool)MySQLi_Query('status',$this->Link);
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	static function Result($Object){
		#-------------------------------------------------------------------------------
		Debug('[MySQLi->Result]: обработка результата запроса к MySQL');
		#-------------------------------------------------------------------------------
		if(!Is_Object($Object))
			return ERROR | @Trigger_Error('[MySQLi->Result]: параметр не является ресурсом');
		#-------------------------------------------------------------------------------
		$Result = Array();
		#-------------------------------------------------------------------------------
		#while($Row = $Object->fetch_array()){
		while($Row = $Object->fetch_assoc())
			$Result[] = $Row;
		#-------------------------------------------------------------------------------
		#if(IsSet($Result[0]) && Is_Array($Result[0]))
		#	$Result = $Result[0];
		#-------------------------------------------------------------------------------
		#Debug(SPrintF('[root/system/classes/auto/MySQL]: Result in Result = %s',print_r($Result,true)));
		return $Result;
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------

?>
