<?php
#-------------------------------------------------------------------------------
/** @author Бреславский А.В. (Joonte Ltd.) 
 ** переписано Alex Keda, для www.host-food.ru */
#-------------------------------------------------------------------------------

#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
// функция генерации пути к размещению файла
function GetFilePath($ID){
	#-------------------------------------------------------------------------------
	// директория файлов
	$DirPath = SPrintF('%s/hosts/%s/files',SYSTEM_PATH,HOST_ID);
	#-------------------------------------------------------------------------------
	// раскладываем по 100 файлов-директорий
	$p1 = Ceil($ID / 100);
	$p2 = Ceil($p1 / 100);
	$p3 = Ceil($p2 / 100);
	#-------------------------------------------------------------------------------
	// путь к файлу
	$FileDirPath = SPrintF('%s/%s/%s/%s',$DirPath,$p3,$p2,$p1);
	#-------------------------------------------------------------------------------
	$FilePath = SPrintF('%s/%s.bin',$FileDirPath,$ID);
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	return Array('FileDir'=>$FileDirPath,'FilePath'=>$FilePath);
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
}

#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
// достаём загруженные файлы и возвращаем в виде переменных
function Upload_Get($TypeID,$Hashes = FALSE){
	/******************************************************************************/
	#$__args_types = Array('string');
	#-------------------------------------------------------------------------------
	$__args__ = Func_Get_Args(); Eval(FUNCTION_INIT);
	/******************************************************************************/
	$Args = Args();
	#-------------------------------------------------------------------------------
	$Hashes = (IsSet($Args[$TypeID])?$Args[$TypeID]:$Hashes);
	#-------------------------------------------------------------------------------
	if(!$Hashes)
		return new gException('HASH_IS_EMPTY','Хешь файла загрузки пуст');
	#-------------------------------------------------------------------------------
	// затычка, если прилетит строка а не массив
	if(!Is_Array($Hashes)){
		#-------------------------------------------------------------------------------
		Debug(SPrintF('[Upload_Get]: TODO $Hashes не массив: %s',$Hashes));
		#-------------------------------------------------------------------------------
		$Hashes = Array($Hashes);
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	$Tmp = System_Element('tmp');
	if(Is_Error($Tmp))
		return ERROR | @Trigger_Error('[Upload_Get]: не удалось получить путь до временной директории');
	#-------------------------------------------------------------------------------
	$Uploads = SPrintF('%s/uploads',$Tmp);
	#-------------------------------------------------------------------------------
	if(!File_Exists($Uploads))
		return new gException('HASH_IS_EMPTY','Директория файлов загрузки не создана');
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	// читаем имена файлов
	$Names = IO_Read(SPrintF('%s/names.txt',$Uploads));
	if(Is_Error($Names))
		return ERROR | @Trigger_Error('[Upload_Get]: не удалось прочитать файл имён');
	#-------------------------------------------------------------------------------
	$Names = JSON_Decode($Names,TRUE);
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	$Out = Array();
	#-------------------------------------------------------------------------------
	// перебираем файлы, собираем в массив
	foreach($Hashes as $Hash){
		#-------------------------------------------------------------------------------
		$Path = SPrintF('%s/%s',$Uploads,$Hash);
		#-------------------------------------------------------------------------------
		if(!File_Exists($Path))
			return new gException('FILE_NOT_FOUND',SPrintF('Файл не найден на сервере: %s',$Path));
		#-------------------------------------------------------------------------------
		$Data = IO_Read($Path);
		if(Is_Error($Data))
			return ERROR | @Trigger_Error('[Upload_Get]: не удалось прочитать файл');
		#-------------------------------------------------------------------------------
		// имя файла
		$Name = (IsSet($Names[$Hash])?$Names[$Hash]:'Default');
		#-------------------------------------------------------------------------------
		// размер файла
		$Stat = Stat($Path);
		#-------------------------------------------------------------------------------
		// тип файла
		$Mime = Mime_Content_Type($Path);
		#-------------------------------------------------------------------------------
		#-------------------------------------------------------------------------------
		$Out[] = Array('Name'=>$Name,'Data'=>$Data,'Hash'=>$Hash,'Path'=>$Path,'Size'=>$Stat['size'],'Mime'=>$Mime);
		#-------------------------------------------------------------------------------
		Debug(SPrintF('[Upload_Get]: файл (%s), Mime (%s), Size (%s), Hash (%s)',$Name,$Mime,$Stat['size'],$Hash));
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	return $Out;
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
}

#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
// сохранение загруженных файлов
function SaveUploadedFile($Files,$Table,$ID){
	#-------------------------------------------------------------------------------
	// если массив пустой - ничего не делаем
	if(SizeOf($Files) < 1){
		#-------------------------------------------------------------------------------
		Debug(SPrintF('[SaveUploadedFile]: пустой массив, нечего сохранять Table/ID = %s/%s',$Table,$ID));
		#-------------------------------------------------------------------------------
		return TRUE;
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	// перебираем переданые файлы
	foreach($Files as $File){
		#-------------------------------------------------------------------------------
		#Debug(SPrintF('[SaveUploadedFile]: File = %s',print_r($File,true)));
		// втыкаем данные в таблицу
		$Array = Array(
				'CreateDate'	=> Time(),
				'TableID'	=> $Table,
				'RowID'		=> $ID,
				'Name'		=> Trim($File['Name']),
				'Size'		=> $File['Size'],
				'Mime'		=> $File['Mime']
				);
		$IsInsert = DB_Insert('Files',$Array);
		if(Is_Error($IsInsert))
			return ERROR | @Trigger_Error(500);
		#-------------------------------------------------------------------------------
		// путь куда сохраняется файл
		$FilePaths = GetFilePath($IsInsert);
		#-------------------------------------------------------------------------------
		// создаём директорию
		if(!File_Exists($FilePaths['FileDir']))
			if(!MkDir($FilePaths['FileDir'], 0700, true))
				return new gException('CANNOT_CREATE_DIRECTORY','Не удалось создать директорию для сохранения файла');
		#-------------------------------------------------------------------------------
		// возможны два варианта - передан путь к файлу, или файл в переменной. если путь - файл переместим, если в переменной - сохраним
		if(IsSet($File['Path']) && File_Exists($File['Path'])){
			#-------------------------------------------------------------------------------
			if(!ReName($File['Path'],$FilePaths['FilePath']))
				return new gException('CANNOT_RENAME_FILE','Не удалось переместить файл');
			#-------------------------------------------------------------------------------
		}else{
			#-------------------------------------------------------------------------------
			if(!IO_Write($FilePaths['FilePath'],$File['Data'],TRUE))
				return new gException('CANNOT_WRITE_FILE','Не удалось записать файл');
			#-------------------------------------------------------------------------------
		}
		#-------------------------------------------------------------------------------
		Debug(SPrintF('[SaveUploadedFile]: сохранён файл (%s), ID (%s)',$File['Name'],$IsInsert));
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
        return TRUE;
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
}

#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
// достаём все приаттаченные к этой строке таблицы файлы
function GetUploadedFiles($Table,$RowID,$IsB64 = FALSE){
	#-------------------------------------------------------------------------------
	$Out = Array();
	#-------------------------------------------------------------------------------
	$Files = DB_Select('FilesOwners','*',Array('Where'=>Array(SPrintF('`TableID` = "%s"',$Table),SPrintF('`RowID` = %u',$RowID))));
	#-------------------------------------------------------------------------------
	switch(ValueOf($Files)){
	case 'error':
		return ERROR | @Trigger_Error(500);
	case 'exception':
		return $Out;
	case 'array':
		break;
	default:
		return ERROR | @Trigger_Error(101);
	}
	#-------------------------------------------------------------------------------
	foreach($Files as $File){
		#-------------------------------------------------------------------------------
		// путь к файлу
		$FilePaths = GetFilePath($File['ID']);
		#-------------------------------------------------------------------------------
		// считываем файл
		$Data = IO_Read($FilePaths['FilePath']);
		if(Is_Error($Data))
			return ERROR | @Trigger_Error('[GetUploadedFiles]: не удалось прочитать файл');
		#-------------------------------------------------------------------------------
		$Out[] = Array('ID'=>$File['ID'],'Name'=>$File['Name'],'Size'=>$File['Size'],'Mime'=>$File['Mime'],'Data'=>(($IsB64)?Chunk_Split(Base64_Encode($Data)):$Data));
		#-------------------------------------------------------------------------------
		Debug(SPrintF('[GetUploadedFiles]: прочитан файл (%s), Table (%s), RowID (%s)',$File['Name'],$Table,$RowID));
		#-------------------------------------------------------------------------------
        }
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	return $Out;
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
}

#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
// достаём все приаттаченные к этой строке таблицы файлы, только информация
function GetUploadedFilesInfo($Table,$RowID){
	#-------------------------------------------------------------------------------
	$Out = Array();
	#-------------------------------------------------------------------------------
	$Files = DB_Select('FilesOwners','*',Array('Where'=>Array(SPrintF('`TableID` = "%s"',$Table),SPrintF('`RowID` = %u',$RowID))));
	#-------------------------------------------------------------------------------
	switch(ValueOf($Files)){
	case 'error':
		return ERROR | @Trigger_Error(500);
	case 'exception':
		return $Out;
	case 'array':
		break;
	default:
		return ERROR | @Trigger_Error(101);
	}
	#-------------------------------------------------------------------------------
	foreach($Files as $File)
		$Out[] = $File;
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	return $Out;
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
}

#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
// удаление файла
function DeleteUploadedFile($FileID){
	#-------------------------------------------------------------------------------
	// удаляем сам файл
	$Path = GetFilePath($FileID);
	#-------------------------------------------------------------------------------
	if(File_Exists($Path['FilePath'])){
		#-------------------------------------------------------------------------------
		Debug(SPrintF('[DeleteUploadedFile]: delete file: %s',$Path['FilePath']));
		#-------------------------------------------------------------------------------
		if(!UnLink($Path['FilePath']))
			return new gException('CANNOT_DELETE_FILE',SPrintF('Не удалось удалить файл: %s',$File['FilePath']));
		#-------------------------------------------------------------------------------
		#-------------------------------------------------------------------------------
		// пробуем удалить директории
		@RmDir($Path['FileDir']);
		#-------------------------------------------------------------------------------
		@RmDir(DirName($Path['FileDir']));
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	// удаляем строку в таблице
	$IsDeleted = DB_Delete('Files',Array('ID'=>$FileID));
	if(Is_Error($IsDeleted))
		return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	return TRUE;
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
}


#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
# added by lissyara, 2011-12-02 in 15:15 MSK, for JBS-210
function oldGetFilePath($Table, $ID){
	#-------------------------------------------------------------------------------
        # директория файлов
        $DirPath = SPrintF('%s/hosts/%s/files/%s',SYSTEM_PATH,HOST_ID,$Table);
	#-------------------------------------------------------------------------------
        # путь к файлу
	$SubDirPath = '';
	#-------------------------------------------------------------------------------
	$IDa = $ID;
	#-------------------------------------------------------------------------------
	while ($IDa > 0) {
		#-------------------------------------------------------------------------------
		$SubDirPath = SPrintF('/%s%s',($IDa % 100),$SubDirPath);
		$IDa = Floor($IDa / 100);
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
        $FileDirPath = SPrintF('%s%s',$DirPath,$SubDirPath);
	#-------------------------------------------------------------------------------
        $FilePath = SPrintF('%s/%s.bin',$FileDirPath,$ID);
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
        return Array('FileDir'=>$FileDirPath, 'FilePath'=>$FilePath);
	#-------------------------------------------------------------------------------
}


?>
