<?php
#-------------------------------------------------------------------------------
/** @author Alex Keda, for www.host-food.ru */
#-------------------------------------------------------------------------------
// https://github.com/openssl/openssl/blob/master/README-PROVIDERS.md
// /etc/ssl/openssl.cnf
// [provider_sect]
// default = default_sect
// legacy = legacy_sect
// [default_sect]
// activate = 1
// [legacy_sect]
// activate = 1

if(!Extension_Loaded('openssl'))
	$GLOBALS['__MESSAGES'][] = 'Модуль openssl не установлен. Функции шифрования могут работать не правильно. Пожалуйста, исправьте ошибку.';

#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
function Crypt_Encode($String, $Key = HOST_ID){
	/******************************************************************************/
	$__args_types = Array('string','string');
	#-------------------------------------------------------------------------------
	$__args__ = Func_Get_Args(); Eval(FUNCTION_INIT);
	/******************************************************************************/
	//Debug(SPrintF('[system/libs/auto/Crypt]: String = %s; Key = %s',$String,$Key));
	if(Extension_Loaded('openssl')){
		#-------------------------------------------------------------------------------
		if(StrLen($String) % 8)
			$String = Str_Pad($String,StrLen($String) + 8 - StrLen($String) % 8,"\0");
		#-------------------------------------------------------------------------------
		//Debug(SPrintF('[system/libs/auto/Crypt]: String = %s; Key = %s',$String,$Key));
		#-------------------------------------------------------------------------------
		$Cipher = 'des-ecb';
		if(!$String = @OpenSSL_Encrypt($String,$Cipher,$Key, OPENSSL_RAW_DATA | OPENSSL_NO_PADDING))
			return ERROR | @Trigger_Error(SPrintF('[Crypt_Encode]: не удалось зашифровать данные'));
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	return Base64_Encode($String);
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
}

# des-ecb
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
function Crypt_Decode($String,$Key = HOST_ID){
	/******************************************************************************/
	$__args_types = Array('string','string');
	#-------------------------------------------------------------------------------
	$__args__ = Func_Get_Args(); Eval(FUNCTION_INIT);
	/******************************************************************************/
	$String = Base64_Decode($String);
	#-------------------------------------------------------------------------------
	if(Empty($String))
		return $String;
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	if(Extension_Loaded('openssl')){
		#-------------------------------------------------------------------------------
		$Cipher = 'des-ecb';
		if(!$String = @OpenSSL_Decrypt($String,$Cipher,$Key,OPENSSL_RAW_DATA | OPENSSL_NO_PADDING)){
			return ERROR | @Trigger_Error('[Crypt_Decode]: не удалось дешифровать данные');
			}
		#-------------------------------------------------------------------------------
		$String = Trim($String);
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	return $String;
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
}

#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
?>
