<?php

#-------------------------------------------------------------------------------
/** @author Alex Keda, for www.host-food.ru */
/******************************************************************************/
/******************************************************************************/
$ConfigPath = SPrintF('%s/hosts/%s/config/Config.xml',SYSTEM_PATH,HOST_ID);
#-------------------------------------------------------------------------------
if(File_Exists($ConfigPath)){
	#-------------------------------------------------------------------------------
	$File = IO_Read($ConfigPath);
	if(Is_Error($File))
		return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------------
	$XML = String_XML_Parse($File);
	if(Is_Exception($XML))
		return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------------
	$Config = $XML->ToArray();
	#-------------------------------------------------------------------------------
	$Config = $Config['XML'];
	#-------------------------------------------------------------------------------
}else{
	#-------------------------------------------------------------------------------
	$Config = Array();
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
if(IsSet($Config['JabberClient'])){
	#-------------------------------------------------------------------------------
	$JabberClient = $Config['JabberClient'];
	Debug(SPrintF('[patches/billing/files/1000062.php]: JabberClient = %s',print_r($JabberClient,true)));
	#-------------------------------------------------------------------------------
	UnSet($Config['JabberClient']);
	#-------------------------------------------------------------------------------
	if(!IsSet($Config['Notifies']) || !Is_Array($Config['Notifies']))
		$Config['Notifies'] = Array();
	#-------------------------------------------------------------------------------
	if(!IsSet($Config['Notifies']['Settings']) || !Is_Array($Config['Notifies']['Settings']))
		$Config['Notifies']['Settings'] = Array();
	#-------------------------------------------------------------------------------
	$Config['Notifies']['Settings']['JabberClient'] = $JabberClient;
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
if(IsSet($Config['SMSGateway'])){
	#-------------------------------------------------------------------------------
	$SMSGateway = $Config['SMSGateway'];
	Debug(SPrintF('[patches/billing/files/1000062.php]: SMSGateway = %s',print_r($SMSGateway,true)));
	#-------------------------------------------------------------------------------
	UnSet($Config['SMSGateway']);
	#-------------------------------------------------------------------------------
	if(!IsSet($Config['Notifies']) || !Is_Array($Config['Notifies']))
		$Config['Notifies'] = Array();
	#-------------------------------------------------------------------------------
	if(!IsSet($Config['Notifies']['Settings']) || !Is_Array($Config['Notifies']['Settings']))
		$Config['Notifies']['Settings'] = Array();
	#-------------------------------------------------------------------------------
	$Config['Notifies']['Settings']['SMSGateway'] = $SMSGateway;
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
if(IsSet($Config['IcqClient'])){
	#-------------------------------------------------------------------------------
	$IcqClient = $Config['IcqClient'];
	Debug(SPrintF('[patches/billing/files/1000062.php]: IcqClient = %s',print_r($IcqClient,true)));
	#-------------------------------------------------------------------------------
	UnSet($Config['IcqClient']);
	#-------------------------------------------------------------------------------
	if(!IsSet($Config['Notifies']) || !Is_Array($Config['Notifies']))
		$Config['Notifies'] = Array();
	#-------------------------------------------------------------------------------
	if(!IsSet($Config['Notifies']['Settings']) || !Is_Array($Config['Notifies']['Settings']))
		$Config['Notifies']['Settings'] = Array();
	#-------------------------------------------------------------------------------
	$Config['Notifies']['Settings']['ICQClient'] = $IcqClient;
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$File = IO_Write($ConfigPath,To_XML_String($Config),TRUE);
if(Is_Error($File))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$IsFlush = CacheManager::flush();
if(!$IsFlush)
	@Trigger_Error(500);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
return TRUE;
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
?>
