<?php

#-------------------------------------------------------------------------------
/** @author Alex Keda, for www.host-food.ru */
/******************************************************************************/
/******************************************************************************/
$ConfigPath = SPrintF('%s/hosts/%s/config/Config.xml',SYSTEM_PATH,HOST_ID);
#-------------------------------------------------------------------------------
if(File_Exists($ConfigPath)){
	#-------------------------------------------------------------------------------
	$File = IO_Read($ConfigPath);
	if(Is_Error($File))
		return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------------
	$XML = String_XML_Parse($File);
	if(Is_Exception($XML))
		return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------------
	$Config = $XML->ToArray();
	#-------------------------------------------------------------------------------
	$Config = $Config['XML'];
	#-------------------------------------------------------------------------------
}else{
	#-------------------------------------------------------------------------------
	$Config = Array();
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
// вычищаем из конфига удалённую систему оповещения - ICQ
if(IsSet($Config['Notifies']['Methods']['ICQ']))
	UnSet($Config['Notifies']['Methods']['ICQ']);
#-------------------------------------------------------------------------------
if(IsSet($Config['Interface']['User']['Notes']['ICQ']))
	UnSet($Config['Interface']['User']['Notes']['ICQ']);
#-------------------------------------------------------------------------------
if(IsSet($Config['Tasks']['Types']['ICQ']))
	UnSet($Config['Tasks']['Types']['ICQ']);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
if(IsSet($Config['Notifies']['Types'])){
	#-------------------------------------------------------------------------------
	foreach(Array_Keys($Config['Notifies']['Types']) as $Key)
		if(IsSet($Config['Notifies']['Types'][$Key]['UseICQ']))
			UnSet($Config['Notifies']['Types'][$Key]['UseICQ']);
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$File = IO_Write($ConfigPath,To_XML_String($Config),TRUE);
if(Is_Error($File))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$IsFlush = CacheManager::flush();
if(!$IsFlush)
	@Trigger_Error(500);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
return TRUE;
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
?>
