<?php

#-------------------------------------------------------------------------------
/** @author Alex Keda, for www.host-food.ru */
/******************************************************************************/
/******************************************************************************/
#-------------------------------------------------------------------------------
$ConfigPath = SPrintF('%s/hosts/%s/config/Config.xml',SYSTEM_PATH,HOST_ID);
#-------------------------------------------------------------------------------
if(File_Exists($ConfigPath)){
	#-----------------------------------------------------------------------------
	$File = IO_Read($ConfigPath);
	if(Is_Error($File))
		return ERROR | @Trigger_Error(500);
	#-----------------------------------------------------------------------------
	$XML = String_XML_Parse($File);
	if(Is_Exception($XML))
		return ERROR | @Trigger_Error(500);
	#-----------------------------------------------------------------------------
	$Config = $XML->ToArray();
	#-----------------------------------------------------------------------------
	$Config = $Config['XML'];
	#-------------------------------------------------------------------------------
}else{
	#-------------------------------------------------------------------------------
	$Config = Array();
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
if(IsSet($Config['EncryptionKey']))
	$OldEncryptionKey = $Config['EncryptionKey'];
#-------------------------------------------------------------------------------
$Config['EncryptionKey'] = Md5(MicroTime().Rand(0,1000000));
#-------------------------------------------------------------------------------
Debug(SPrintF("[patches/hosting/files/1000011.php]: Config = %s",print_r($Config,true)));
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$File = IO_Write($ConfigPath,To_XML_String($Config),TRUE);
if(Is_Error($File))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$IsFlush = CacheManager::flush();
if(!$IsFlush)
	@Trigger_Error(500);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$NoTypesDB = &Link_Get('NoTypesDB','boolean');
#-------------------------------------------------------------------------------
$NoTypesDB = TRUE;
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Tables = Array('Registrators','HostingServers','VPSServers','DSServers','HostingOrders','VPSOrders','ExtraIPOrders','ExtraIPs');
#-------------------------------------------------------------------------------
foreach($Tables as $Table){
	#-------------------------------------------------------------------------------
	$Rows = DB_Select($Table,Array('ID','Password'));
	#-------------------------------------------------------------------------------
	switch(ValueOf($Rows)){
	case 'error':
		return ERROR | @Trigger_Error(500);
	case 'exception':
		# No more...
		break;
	case 'array':
		#-------------------------------------------------------------------------------
		foreach($Rows as $Row){
			#-------------------------------------------------------------------------
			$Password = Crypt_Decode1($Row['Password'],(IsSet($OldEncryptionKey)?$OldEncryptionKey:HOST_ID));
			if(Is_Error($Password))
				$Password = SubStr(Md5(MicroTime()), 0, 5);
			Debug(SPrintF("[patches/hosting/files/1000011.php]: Password Decoded = %s",$Password));
			#-------------------------------------------------------------------------
			$Password = Crypt_Encode1($Password,$Config['EncryptionKey']);
			if(Is_Error($Password))
				return ERROR | @Trigger_Error(500);
			Debug(SPrintF("[patches/hosting/files/1000011.php]: Password Encoded = %s",$Password));
			#-------------------------------------------------------------------------
			$IsUpdate = DB_Update($Table,Array('Password'=>$Password),Array('ID'=>$Row['ID']));
			if(Is_Error($IsUpdate))
				return ERROR | @Trigger_Error(500);
			#-------------------------------------------------------------------------------
		}
		#-------------------------------------------------------------------------------
		break;
	default:
		return ERROR | @Trigger_Error(101);
	}
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
function Crypt_Encode1($String, $Key = HOST_ID){
	/****************************************************************************/
	$__args_types = Array('string','string');
	#-----------------------------------------------------------------------------
	$__args__ = Func_Get_Args(); Eval(FUNCTION_INIT);
	/****************************************************************************/
	if(Extension_Loaded('mcrypt')){
		#---------------------------------------------------------------------------
		#-------------------------------------------------------------------------
		$Module = @MCrypt_Module_Open(MCRYPT_DES,'',MCRYPT_MODE_ECB,'');
		if(!Is_Resource($Module))
			return ERROR | @Trigger_Error('[Crypt_Encode]: не удалось открыть дескриптор');
		#-------------------------------------------------------------------------
		$Iv = @MCrypt_Create_Iv(MCrypt_Enc_Get_Iv_Size($Module),MCRYPT_RAND);
		if(!$Iv)
			return ERROR | @Trigger_Error('[Crypt_Encode]: не удалось создать IV');
		#-------------------------------------------------------------------------
		$Key = SubStr($Key,0,MCrypt_Enc_Get_Key_Size($Module));
		Debug(SPrintF("[Crypt_Encode1]: Encode Key = %s",$Key));
		#-------------------------------------------------------------------------
		$IsInit = @MCrypt_Generic_Init($Module,$Key,$Iv);
		if(!Is_Integer($IsInit))
			return ERROR | @Trigger_Error('[Crypt_Encode]: не удалось инициализовать модуль шифрования');
		#-------------------------------------------------------------------------------
		#MCrypt_Generic_DeInit($Module);
		#---------------------------------------------------------------------------
	}
	#---------------------------------------------------------------------------
	$String = @MCrypt_Generic($Module,$String);
	if(!Is_String($String))
		return ERROR | @Trigger_Error('[Crypt_Encode]: не удалось зашифровать данные');
	#---------------------------------------------------------------------------
	return Base64_Encode($String);
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
function Crypt_Decode1($String,$Key = HOST_ID){
	/****************************************************************************/
	$__args_types = Array('string','string');
	#-----------------------------------------------------------------------------
	$__args__ = Func_Get_Args(); Eval(FUNCTION_INIT);
	/****************************************************************************/
	$String = Base64_Decode($String);
	#-----------------------------------------------------------------------------
	if (Empty($String)) { return $String; }
	#-----------------------------------------------------------------------------
	if(Extension_Loaded('mcrypt')){
		#---------------------------------------------------------------------------
		$Module = @MCrypt_Module_Open(MCRYPT_DES,'',MCRYPT_MODE_ECB,'');
		if(!Is_Resource($Module))
			return ERROR | @Trigger_Error('[Crypt_Decode]: не удалось открыть дескриптор');
		#-------------------------------------------------------------------------
		$Iv = @MCrypt_Create_Iv(MCrypt_Enc_Get_Iv_Size($Module),MCRYPT_RAND);
		if(!$Iv)
			return ERROR | @Trigger_Error('[Crypt_Decode]: не удалось создать IV');
		#-------------------------------------------------------------------------
		$Key = SubStr($Key,0,MCrypt_Enc_Get_Key_Size($Module));
		Debug(SPrintF("[Crypt_Decode1]: Decode Key = %s",$Key));
		#-------------------------------------------------------------------------
		$IsInit = @MCrypt_Generic_Init($Module,$Key,$Iv);
		if(!Is_Integer($IsInit))
			return ERROR | @Trigger_Error('[Crypt_Decode]: не удалось инициализовать модуль дешифрования');
		#-------------------------------------------------------------------------------
	}
	#---------------------------------------------------------------------------
	$String = @MDecrypt_Generic($Module,$String);
	if(!Is_String($String))
		return ERROR | @Trigger_Error('[Crypt_Decode]: не удалось дешифровать данные');
	#---------------------------------------------------------------------------
	MCrypt_Generic_DeInit($Module);
	#---------------------------------------------------------------------------
	$String = Trim($String);
	#---------------------------------------------------------------------------
	return $String;
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
return TRUE;
#-------------------------------------------------------------------------------
?>

