<?php

#-------------------------------------------------------------------------------
/** @author Alex Keda, for www.host-food.ru */
/******************************************************************************/
/******************************************************************************/
$ConfigPath = SPrintF('%s/hosts/%s/config/Config.xml',SYSTEM_PATH,HOST_ID);
#-------------------------------------------------------------------------------
if(File_Exists($ConfigPath)){
	#-------------------------------------------------------------------------------
	$File = IO_Read($ConfigPath);
	if(Is_Error($File))
		return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------------
	$XML = String_XML_Parse($File);
	if(Is_Exception($XML))
		return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------------
	$Config = $XML->ToArray();
	#-------------------------------------------------------------------------------
	$Config = $Config['XML'];
	#-------------------------------------------------------------------------------
}else{
	#-------------------------------------------------------------------------------
	$Config = Array();
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
if(IsSet($Config['Notifies']['Settings']['ICQClient']['Uin'])){
	#-------------------------------------------------------------------------------
	$ICQClient = $Config['Notifies']['Settings']['ICQClient'];
	Debug(SPrintF('[patches/hosting/files/1000015.php]: ICQClient = %s',print_r($ICQClient,true)));
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	$IsDelete = DB_Delete('Servers',Array('Where'=>'`TemplateID` = "ICQ"'));
	if(Is_Error($IsDelete))
		return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	$Server = Array(
			'TemplateID'	=> 'ICQ',
			'IsActive'	=> TRUE,
			'IsDefault'	=> TRUE,
			'Protocol'	=> 'tcp',
			'Address'	=> 'login.icq.com',
			'Port'		=> 5190,
			'Login'		=> $ICQClient['Uin'],
			'Password'	=> (IsSet($ICQClient['Password'])?$ICQClient['Password']:''),
			'Params'	=> Array(
						'Encoding'=>(IsSet($ICQClient['Encoding'])?$ICQClient['Encoding']:'CP1251'),
						),
			'AdminNotice'	=> 'Можно указать несколько UIN в поле "Логин" перечислив их через запятую. Для отсылки будет выбираться случайный из них. Пароль должен быть одинаковым.',
			'SortID'	=> 100000,
			'Monitoring'	=> 'ICQ=5190'
			);
	#-------------------------------------------------------------------------------
	$IsInsert = DB_Insert('Servers',$Server);
	if(Is_Error($IsInsert))
		return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	UnSet($Config['Notifies']['Settings']['ICQClient']);
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$File = IO_Write($ConfigPath,To_XML_String($Config),TRUE);
if(Is_Error($File))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$IsFlush = CacheManager::flush();
if(!$IsFlush)
	@Trigger_Error(500);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
return TRUE;
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
?>
