<?php

#-------------------------------------------------------------------------------
/** @author Alex Keda, for www.host-food.ru */
/******************************************************************************/
/******************************************************************************/
$ConfigPath = SPrintF('%s/hosts/%s/config/Config.xml',SYSTEM_PATH,HOST_ID);
#-------------------------------------------------------------------------------
if(File_Exists($ConfigPath)){
	#-------------------------------------------------------------------------------
	$File = IO_Read($ConfigPath);
	if(Is_Error($File))
		return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------------
	$XML = String_XML_Parse($File);
	if(Is_Exception($XML))
		return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------------
	$Config = $XML->ToArray();
	#-------------------------------------------------------------------------------
	$Config = $Config['XML'];
	#-------------------------------------------------------------------------------
}else{
	#-------------------------------------------------------------------------------
	$Config = Array();
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
if(IsSet($Config['Notifies']['Settings']['JabberClient']['Password'])){
	#-------------------------------------------------------------------------------
	$JabberClient = $Config['Notifies']['Settings']['JabberClient'];
	Debug(SPrintF('[patches/hosting/files/1000016.php]: JabberClient = %s',print_r($JabberClient,true)));
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	$IsDelete = DB_Delete('Servers',Array('Where'=>'`TemplateID` = "Jabber"'));
	if(Is_Error($IsDelete))
		return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	$Server = Array(
			'TemplateID'	=> 'Jabber',
			'IsActive'	=> TRUE,
			'IsDefault'	=> TRUE,
			'Protocol'	=> 'ssl',
			'Address'	=> (IsSet($JabberClient['Server'])?$JabberClient['Server']:'jabber.isp.su'),
			'Port'		=> 5222,
			'Login'		=> $JabberClient['JabberID'],
			'Password'	=> (IsSet($JabberClient['Password'])?$JabberClient['Password']:''),
			'SortID'	=> 100000,
			'Monitoring'	=> 'Jabber=5222'
			);
	#-------------------------------------------------------------------------------
	$IsInsert = DB_Insert('Servers',$Server);
	if(Is_Error($IsInsert))
		return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	UnSet($Config['Notifies']['Settings']['JabberClient']);
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$File = IO_Write($ConfigPath,To_XML_String($Config),TRUE);
if(Is_Error($File))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$IsFlush = CacheManager::flush();
if(!$IsFlush)
	@Trigger_Error(500);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
return TRUE;
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
?>
