<?php


#-------------------------------------------------------------------------------
/** @author Alex Keda, for www.host-food.ru */
/******************************************************************************/
/******************************************************************************/
#-------------------------------------------------------------------------------
#---------------------------TRANSACTION-----------------------------------------
if(Is_Error(DB_Transaction($TransactionID = UniqID('Dedicated'))))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$CPUtype = Array(	'Opteron'	=> 'AMD Opteron',
			'Athlon'	=> 'AMD Athlon',
			'Phenom'	=> 'AMD Phenom',
			'Sempron'	=> 'AMD Sempron',
			'Xeon'		=> 'Intel Xeon',
			'Nehalem'	=> 'Intel Nehalem',
			'PentiumD'	=> 'Pentium D',
			'i5'		=> 'Intel Core i5',
			'i3'		=> 'Intel Core i3',
			'c2'		=> 'Intel Core 2 Duo',
			'c4'		=> 'Intel Core 2 Quad',
			'p4'		=> 'Intel Pentium IV',
			'Celeron'	=> 'Intel Celeron',
			'Atom'		=> 'Intel Atom',
			'PIII'		=> 'Intel Pentium 3'
		);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Schemes = DB_Select('DSSchemes','*');
#-------------------------------------------------------------------------------
switch(ValueOf($Schemes)){
case 'error':
	return ERROR | @Trigger_Error(500);
case 'exception':
	#-------------------------------------------------------------------------------
	$IsUpdate = FALSE;
	#-------------------------------------------------------------------------------
	break;
	#-------------------------------------------------------------------------------
case 'array':
	#-------------------------------------------------------------------------------
	$IsUpdate = TRUE;
	#-------------------------------------------------------------------------------
	break;
	#-------------------------------------------------------------------------------
default:
	return ERROR | @Trigger_Error(101);
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
# добавляем новую колонку к таблице
$IsQuery = DB_Query('ALTER TABLE `DSSchemes` ADD `CPU` VARCHAR(128) NOT NULL AFTER `SortID`');
if(Is_Error($IsQuery))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
if($IsUpdate){
	#-------------------------------------------------------------------------------
	foreach($Schemes as $Scheme){
		#-------------------------------------------------------------------------------
		$IsUpdate = DB_Update('DSSchemes',Array('CPU'=>SPrintF('%sx %s %s (%s cores)',$Scheme['numcpu'],$CPUtype[$Scheme['cputype']],$Scheme['cpufreq'],$Scheme['numcores'])),Array('ID'=>$Scheme['ID']));
		if(Is_Error($IsUpdate))
			return ERROR | @Trigger_Error(500);
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
# Удаляем колонки
foreach(Array('cputype','cpuarch','numcpu','numcores','cpufreq') as $Column){
	#-------------------------------------------------------------------------------
	$IsQuery = DB_Query(SPrintF('ALTER TABLE `DSSchemes` DROP `%s`',$Column));
	if(Is_Error($IsQuery))
		return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
return TRUE;
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------

?>
