<?php

#-------------------------------------------------------------------------------
/** @author Alex Keda, for www.host-food.ru */
/******************************************************************************/
/******************************************************************************/

// добавляем колонку для хранения информации о заказах
$IsQuery = DB_Query('ALTER TABLE `OrdersHistory` ADD `Parked` text AFTER `OrderID`');
if(Is_Error($IsQuery))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
// достаём список доменов для заказов на хостинг
$Orders = DB_Select('HostingOrders',Array('OrderID','Parked'),Array('Where'=>'`StatusID` != "Waiting"'));
#-------------------------------------------------------------------------------
switch(ValueOf($Orders)){
case 'error':
	return ERROR | @Trigger_Error(500);
case 'exception':
	#-------------------------------------------------------------------------------
	break;
	#-------------------------------------------------------------------------------
case 'array':
	#-------------------------------------------------------------------------------
	foreach($Orders as $Order){
		#-------------------------------------------------------------------------------
		// проверяем наличие такой записи в таблице истории заказов
		$Count = DB_Count('OrdersHistory',Array('Where'=>Array(SPrintF('`OrderID` = %u',$Order['OrderID']))));
		if(Is_Error($Count))
			return ERROR | Trigger_Error(500);
		#-------------------------------------------------------------------------------
		if($Count){
			#-------------------------------------------------------------------------------
			$IsUpdate = DB_Update('OrdersHistory',Array('Parked'=>$Order['Parked']),Array('Where'=>SPrintF('`OrderID` = %u',$Order['OrderID'])));
			if(Is_Error($IsUpdate))
				return ERROR | @Trigger_Error(500);
			#-------------------------------------------------------------------------------
		}
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	break;
	#-------------------------------------------------------------------------------
default:
	return ERROR | @Trigger_Error(101);
}

#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
// достаём список доменов для заказов на вторичный ДНС
$Orders = DB_Select('DNSmanagerOrders',Array('OrderID','Parked'),Array('Where'=>'`StatusID` != "Waiting"'));
#-------------------------------------------------------------------------------
switch(ValueOf($Orders)){
case 'error':
	return ERROR | @Trigger_Error(500);
case 'exception':
	#-------------------------------------------------------------------------------
	break;
	#-------------------------------------------------------------------------------
case 'array':
	#-------------------------------------------------------------------------------
	foreach($Orders as $Order){
		#-------------------------------------------------------------------------------
		// проверяем наличие такой записи в таблице истории заказов
		$Count = DB_Count('OrdersHistory',Array('Where'=>Array(SPrintF('`OrderID` = %u',$Order['OrderID']))));
		if(Is_Error($Count))
			return ERROR | Trigger_Error(500);
		#-------------------------------------------------------------------------------
		if($Count){
			#-------------------------------------------------------------------------------
			$IsUpdate = DB_Update('OrdersHistory',Array('Parked'=>$Order['Parked']),Array('Where'=>SPrintF('`OrderID` = %u',$Order['OrderID'])));
			if(Is_Error($IsUpdate))
				return ERROR | @Trigger_Error(500);
			#-------------------------------------------------------------------------------
		}
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	break;
	#-------------------------------------------------------------------------------
default:
	return ERROR | @Trigger_Error(101);
}

#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
// достаём список IP адресов для ВПС
$Orders = DB_Select('VPSOrders',Array('OrderID','IP'),Array('Where'=>'`StatusID` != "Waiting"'));
#-------------------------------------------------------------------------------
switch(ValueOf($Orders)){
case 'error':
	return ERROR | @Trigger_Error(500);
case 'exception':
	#-------------------------------------------------------------------------------
	break;
	#-------------------------------------------------------------------------------
case 'array':
	#-------------------------------------------------------------------------------
	foreach($Orders as $Order){
		#-------------------------------------------------------------------------------
		// проверяем наличие такой записи в таблице истории заказов
		$Count = DB_Count('OrdersHistory',Array('Where'=>Array(SPrintF('`OrderID` = %u',$Order['OrderID']))));
		if(Is_Error($Count))
			return ERROR | Trigger_Error(500);
		#-------------------------------------------------------------------------------
		if($Count){
			#-------------------------------------------------------------------------------
			$IsUpdate = DB_Update('OrdersHistory',Array('Parked'=>$Order['IP']),Array('Where'=>SPrintF('`OrderID` = %u',$Order['OrderID'])));
			if(Is_Error($IsUpdate))
				return ERROR | @Trigger_Error(500);
			#-------------------------------------------------------------------------------
		}
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	break;
	#-------------------------------------------------------------------------------
default:
	return ERROR | @Trigger_Error(101);
}

#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
// достаём список IP адресов для выделенных серверов
$Orders = DB_Select('DSOrders',Array('OrderID','IP','ExtraIP'),Array('Where'=>'`StatusID` != "Waiting"'));
#-------------------------------------------------------------------------------
switch(ValueOf($Orders)){
case 'error':
	return ERROR | @Trigger_Error(500);
case 'exception':
	#-------------------------------------------------------------------------------
	break;
	#-------------------------------------------------------------------------------
case 'array':
	#-------------------------------------------------------------------------------
	foreach($Orders as $Order){
		#-------------------------------------------------------------------------------
		// проверяем наличие такой записи в таблице истории заказов
		$Count = DB_Count('OrdersHistory',Array('Where'=>Array(SPrintF('`OrderID` = %u',$Order['OrderID']))));
		if(Is_Error($Count))
			return ERROR | Trigger_Error(500);
		#-------------------------------------------------------------------------------
		if($Count){
			#-------------------------------------------------------------------------------
			// проверяем дубликаты записей
			$Array = ($Order['ExtraIP'])?Explode("\n",$Order['ExtraIP']):Array();
			#-------------------------------------------------------------------------------
			$IPs = Array(Trim($Order['IP']));
			#-------------------------------------------------------------------------------
			foreach($Array as $IP)
				if(!In_Array(Trim($IP),$IPs))
					$IPs[] = Trim($IP);
			#-------------------------------------------------------------------------------
			#-------------------------------------------------------------------------------
			$IsUpdate = DB_Update('OrdersHistory',Array('Parked'=>Implode(',',$IPs)),Array('Where'=>SPrintF('`OrderID` = %u',$Order['OrderID'])));
			if(Is_Error($IsUpdate))
				return ERROR | @Trigger_Error(500);
			#-------------------------------------------------------------------------------
		}
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	break;
	#-------------------------------------------------------------------------------
default:
	return ERROR | @Trigger_Error(101);
}

#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
// достаём список доменных имён
$Orders = DB_Select('DomainOrdersOwners',Array('OrderID','DomainName','Name'),Array('Where'=>'`StatusID` != "Waiting"'));
#-------------------------------------------------------------------------------
switch(ValueOf($Orders)){
case 'error':
	return ERROR | @Trigger_Error(500);
case 'exception':
	#-------------------------------------------------------------------------------
	break;
	#-------------------------------------------------------------------------------
case 'array':
	#-------------------------------------------------------------------------------
	foreach($Orders as $Order){
		#-------------------------------------------------------------------------------
		// проверяем наличие такой записи в таблице истории заказов
		$Count = DB_Count('OrdersHistory',Array('Where'=>Array(SPrintF('`OrderID` = %u',$Order['OrderID']))));
		if(Is_Error($Count))
			return ERROR | Trigger_Error(500);
		#-------------------------------------------------------------------------------
		if($Count){
			#-------------------------------------------------------------------------------
			$IsUpdate = DB_Update('OrdersHistory',Array('Parked'=>SPrintF('%s.%s',$Order['DomainName'],$Order['Name'])),Array('Where'=>SPrintF('`OrderID` = %u',$Order['OrderID'])));
			if(Is_Error($IsUpdate))
				return ERROR | @Trigger_Error(500);
			#-------------------------------------------------------------------------------
		}
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	break;
	#-------------------------------------------------------------------------------
default:
	return ERROR | @Trigger_Error(101);
}

#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
// достаём список дополнительных IP адресов 
$Orders = DB_Select('ExtraIPOrders',Array('OrderID','Login'),Array('Where'=>'`StatusID` != "Waiting"'));
#-------------------------------------------------------------------------------
switch(ValueOf($Orders)){
case 'error':
	return ERROR | @Trigger_Error(500);
case 'exception':
	#-------------------------------------------------------------------------------
	break;
	#-------------------------------------------------------------------------------
case 'array':
	#-------------------------------------------------------------------------------
	foreach($Orders as $Order){
		#-------------------------------------------------------------------------------
		// проверяем наличие такой записи в таблице истории заказов
		$Count = DB_Count('OrdersHistory',Array('Where'=>Array(SPrintF('`OrderID` = %u',$Order['OrderID']))));
		if(Is_Error($Count))
			return ERROR | Trigger_Error(500);
		#-------------------------------------------------------------------------------
		if($Count){
			#-------------------------------------------------------------------------------
			$IsUpdate = DB_Update('OrdersHistory',Array('Parked'=>$Order['Login']),Array('Where'=>SPrintF('`OrderID` = %u',$Order['OrderID'])));
			if(Is_Error($IsUpdate))
				return ERROR | @Trigger_Error(500);
			#-------------------------------------------------------------------------------
		}
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	break;
	#-------------------------------------------------------------------------------
default:
	return ERROR | @Trigger_Error(101);
}

#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
// достаём список заказов на ПО
$Orders = DB_Select('ISPswOrders',Array('OrderID','IP'),Array('Where'=>'`StatusID` != "Waiting"'));
#-------------------------------------------------------------------------------
switch(ValueOf($Orders)){
case 'error':
	return ERROR | @Trigger_Error(500);
case 'exception':
	#-------------------------------------------------------------------------------
	break;
	#-------------------------------------------------------------------------------
case 'array':
	#-------------------------------------------------------------------------------
	foreach($Orders as $Order){
		#-------------------------------------------------------------------------------
		// проверяем наличие такой записи в таблице истории заказов
		$Count = DB_Count('OrdersHistory',Array('Where'=>Array(SPrintF('`OrderID` = %u',$Order['OrderID']))));
		if(Is_Error($Count))
			return ERROR | Trigger_Error(500);
		#-------------------------------------------------------------------------------
		if($Count){
			#-------------------------------------------------------------------------------
			$IsUpdate = DB_Update('OrdersHistory',Array('Parked'=>$Order['IP']),Array('Where'=>SPrintF('`OrderID` = %u',$Order['OrderID'])));
			if(Is_Error($IsUpdate))
				return ERROR | @Trigger_Error(500);
			#-------------------------------------------------------------------------------
		}
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	break;
	#-------------------------------------------------------------------------------
default:
	return ERROR | @Trigger_Error(101);
}

#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
// достаём список заказов на прокси-сервера
$Orders = DB_Select('ProxyOrders',Array('OrderID','IP','Host'),Array('Where'=>'`StatusID` != "Waiting"'));
#-------------------------------------------------------------------------------
switch(ValueOf($Orders)){
case 'error':
	return ERROR | @Trigger_Error(500);
case 'exception':
	#-------------------------------------------------------------------------------
	break;
	#-------------------------------------------------------------------------------
case 'array':
	#-------------------------------------------------------------------------------
	foreach($Orders as $Order){
		#-------------------------------------------------------------------------------
		// проверяем наличие такой записи в таблице истории заказов
		$Count = DB_Count('OrdersHistory',Array('Where'=>Array(SPrintF('`OrderID` = %u',$Order['OrderID']))));
		if(Is_Error($Count))
			return ERROR | Trigger_Error(500);
		#-------------------------------------------------------------------------------
		if($Count){
			#-------------------------------------------------------------------------------
			$Array = Array();
			#-------------------------------------------------------------------------------
			if($Order['IP'])
				$Array[] = $Order['IP'];
			#-------------------------------------------------------------------------------
			if($Order['Host'])
				$Array[] = $Order['Host'];
			#-------------------------------------------------------------------------------
			#-------------------------------------------------------------------------------
			$IsUpdate = DB_Update('OrdersHistory',Array('Parked'=>Implode(',',$Array)),Array('Where'=>SPrintF('`OrderID` = %u',$Order['OrderID'])));
			if(Is_Error($IsUpdate))
				return ERROR | @Trigger_Error(500);
			#-------------------------------------------------------------------------------
		}
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	break;
	#-------------------------------------------------------------------------------
default:
	return ERROR | @Trigger_Error(101);
}


#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
return TRUE;
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------

?>
