<?php                   
                        
#-------------------------------------------------------------------------------
/** @author Alex Keda, for www.host-food.ru */
/******************************************************************************/
/******************************************************************************/
$Tmp = System_Element('tmp');
if(Is_Error($Tmp))
	return ERROR | @Trigger_Error('[files/1000031.php]: не удалось найти временную папку');
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
// импортируем сбербанк
$SberBankFileDB = SPrintF('%s/SberBank.txt',$Tmp);
#-------------------------------------------------------------------------------
if(File_Exists($SberBankFileDB)){
	#-------------------------------------------------------------------------------
	$IsRead = IO_Read($SberBankFileDB);
	if(Is_Error($IsRead))
		return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------------
	$Lines = Explode("\n", Trim($IsRead));
	#-------------------------------------------------------------------------------
	foreach($Lines as $Line){
		#-------------------------------------------------------------------------------
		List($InvoiceID, $URL) = Preg_Split("/[\s]+/",$Line);
		#-------------------------------------------------------------------------------
		$IsInsert = DB_Insert('TmpData',Array('AppID'=>'SberBank','Col1'=>$InvoiceID,'Col4'=>$URL));
		if(Is_Error($IsInsert))
			return ERROR | @Trigger_Error(500);
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	if(!UnLink($SberBankFileDB))
		return new gException('CANNOT_DELETE_FILE',SPrintF('Не удалось удалить файл: %s',$SberBankFileDB));
	#-------------------------------------------------------------------------------
}

#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
// импортируем счета и сессии ККМ
$TaxationFileDB = SPrintF('%s/Taxation.txt',$Tmp);
#-------------------------------------------------------------------------------
if(File_Exists($TaxationFileDB)){
	#-------------------------------------------------------------------------------
	$IsRead = IO_Read($TaxationFileDB);
	if(Is_Error($IsRead))
		return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------------
	$Lines = Explode("\n", Trim($IsRead));
	#-------------------------------------------------------------------------------
	foreach($Lines as $Line){
		#-------------------------------------------------------------------------------
		List($docNumber, $SessionId) = Preg_Split("/[\s]+/",$Line);
		#-------------------------------------------------------------------------------
		$IsInsert = DB_Insert('TmpData',Array('AppID'=>'Taxation','Col1'=>$docNumber,'Col2'=>$SessionId));
		if(Is_Error($IsInsert))
			return ERROR | @Trigger_Error(500);
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	if(!UnLink($TaxationFileDB))
		return new gException('CANNOT_DELETE_FILE',SPrintF('Не удалось удалить файл: %s',$TaxationFileDB));
	#-------------------------------------------------------------------------------
}

#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
// импортируем треды телеграмма
$TelegramFileDB = SPrintF('%s/Telegram.txt',$Tmp);
#-------------------------------------------------------------------------------
if(File_Exists($TelegramFileDB)){
	#-------------------------------------------------------------------------------
	$IsRead = IO_Read($TelegramFileDB);
	if(Is_Error($IsRead))
		return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------------
	$Lines = Explode("\n", Trim($IsRead));
	#-------------------------------------------------------------------------------
	foreach($Lines as $Line){
		#-------------------------------------------------------------------------------
		List($UserID,$TicketID,$MessageID,$TgMessageIDtmp) = Preg_Split("/[\s]+/",$Line);
		#-------------------------------------------------------------------------------
		if(IntVal($UserID) > 100){
			#-------------------------------------------------------------------------------
			$IsInsert = DB_Insert('TmpData',Array('UserID'=>$UserID,'AppID'=>'Telegram','Col1'=>$TicketID,'Col2'=>$MessageID,'Col3'=>$TgMessageIDtmp));
			if(Is_Error($IsInsert))
				return ERROR | @Trigger_Error(500);
			#-------------------------------------------------------------------------------
		}
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	if(!UnLink($TelegramFileDB))
		return new gException('CANNOT_DELETE_FILE',SPrintF('Не удалось удалить файл: %s',$TelegramFileDB));
	#-------------------------------------------------------------------------------
}

#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
// импортируем треды телеграмма
$VkFileDB = SPrintF('%s/VK.txt',$Tmp);
#-------------------------------------------------------------------------------
if(File_Exists($VkFileDB)){
	#-------------------------------------------------------------------------------
	$IsRead = IO_Read($VkFileDB);
	if(Is_Error($IsRead))
		return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------------
	$Lines = Explode("\n", Trim($IsRead));
	#-------------------------------------------------------------------------------
	foreach($Lines as $Line){
		#-------------------------------------------------------------------------------
		List($UserID,$TicketID,$MessageID,$VkMessageIDtmp) = Preg_Split("/[\s]+/",$Line);
		#-------------------------------------------------------------------------------
		if(IntVal($UserID) > 100){
			#-------------------------------------------------------------------------------
			$IsInsert = DB_Insert('TmpData',Array('UserID'=>$UserID,'AppID'=>'VK','Col1'=>$TicketID,'Col2'=>$MessageID,'Col3'=>$VkMessageIDtmp));
			if(Is_Error($IsInsert))
				return ERROR | @Trigger_Error(500);
			#-------------------------------------------------------------------------------
		}
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	if(!UnLink($VkFileDB))
		return new gException('CANNOT_DELETE_FILE',SPrintF('Не удалось удалить файл: %s',$VkFileDB));
	#-------------------------------------------------------------------------------
}




return TRUE;

