//------------------------------------------------------------------------------
/** @author Alex Keda, for www.host-food.ru */
//------------------------------------------------------------------------------
var $MonthsNames = ['Января','Февраля','Марта','Апреля','Мая','Июня','Июля','Августа','Сентября','Октября','Ноября','Декабря'];
//------------------------------------------------------------------------------
var $Period = {};
//------------------------------------------------------------------------------
function PeriodInit($Code){
	//------------------------------------------------------------------------------
	//----------------------------------------------------------------------------
	var $Form = document.forms[$Code+'OrderPayForm'];
	//------------------------------------------------------------------------------
	$Period = ($Form.Period?Periods[$Form.Period.value]:{Day:new Date().getDay(),Month:new Date().getMonth(),Year:new Date().getYear()});
	//------------------------------------------------------------------------------
	$Form.Year.value = $Period.Year;
	//------------------------------------------------------------------------------
	CalendarUpdateMonth($Code);
	//------------------------------------------------------------------------------
}
//------------------------------------------------------------------------------
//------------------------------------------------------------------------------
function PeriodUpdate($Code){
	//------------------------------------------------------------------------------
	var $Form = document.forms[$Code+'OrderPayForm'];
	//------------------------------------------------------------------------------
	$Period = Periods[$Form.Period.value];
	//------------------------------------------------------------------------------
	$Form.Year.value = $Period.Year;
	//------------------------------------------------------------------------------
	$Form.Month.value = $Period.Month;
	//------------------------------------------------------------------------------
	CalendarUpdateMonth($Code);
	//------------------------------------------------------------------------------
	$Form.Day.value = $Period.Day;
	//------------------------------------------------------------------------------
}
//------------------------------------------------------------------------------
//------------------------------------------------------------------------------
function CalendarUpdateDay($Code){
	//------------------------------------------------------------------------------
	var $Form = document.forms[$Code+'OrderPayForm'];
	//------------------------------------------------------------------------------
	var $DayIndex = ($Form.Day.value != 'init'?$Form.Day.value:$Period.Day);
	//------------------------------------------------------------------------------
	var $Month = Calendar[$Form.Year.value][$Form.Month.value];
	//------------------------------------------------------------------------------
	var $Options = $Form.Day.options;
	//------------------------------------------------------------------------------
	var $DaySelected = Math.min($Month.Stop,$DayIndex);
	//----------------------------------------------------------------------------
	while($Options.length != 0){
		//------------------------------------------------------------------------------
		try{ $Form.Day.remove($Options.length - 1); }catch(e){};
		//------------------------------------------------------------------------------
	}
	//------------------------------------------------------------------------------
	for(var $Day=$Month.Start;$Day<=$Month.Stop;$Day++){
		//------------------------------------------------------------------------------
		var $Adding = document.createElement('OPTION');
		//------------------------------------------------------------------------------
		$Adding.value = $Day;
		//------------------------------------------------------------------------------
		$Adding.innerHTML = $Day;
		//------------------------------------------------------------------------------
		if($Day == $DaySelected)
			$Adding.selected = true;
		//------------------------------------------------------------------------------
		$Form.Day.appendChild($Adding);
		//------------------------------------------------------------------------------
	}
	//------------------------------------------------------------------------------
}
//------------------------------------------------------------------------------
//------------------------------------------------------------------------------
function CalendarUpdateMonth($Code){
	//------------------------------------------------------------------------------
	var $Form = document.forms[$Code+'OrderPayForm'];
	//------------------------------------------------------------------------------
	var $MonthSelected = ($Form.Month.value != 'init'?$Form.Month.value:$Period.Month);
	//------------------------------------------------------------------------------
	var $Months = Calendar[$Form.Year.value];
	//------------------------------------------------------------------------------
	var $Options = $Form.Month.options;
	//------------------------------------------------------------------------------
	while($Options.length != 0)
		try{ $Form.Month.remove($Options.length - 1); }catch(e){};
	//------------------------------------------------------------------------------
	for(var $Month in $Months){
		//------------------------------------------------------------------------------
		if(typeof $Months[$Month] != 'object')
			continue;
		//------------------------------------------------------------------------------
		var $Adding = document.createElement('OPTION');
		//------------------------------------------------------------------------------
		$Adding.value = $Month;
		//------------------------------------------------------------------------------
		$Adding.innerHTML = $MonthsNames[$Month];
		//------------------------------------------------------------------------------
		if($Month == $MonthSelected)
			$Adding.selected = true;
		//------------------------------------------------------------------------------
		$Form.Month.appendChild($Adding);
		//------------------------------------------------------------------------------
	}
	//------------------------------------------------------------------------------
	CalendarUpdateDay($Code);
	//------------------------------------------------------------------------------
}
//------------------------------------------------------------------------------
//------------------------------------------------------------------------------
function OrderPay($Code){
	//------------------------------------------------------------------------------
	var $Form = document.forms[$Code+'OrderPayForm'];
	//------------------------------------------------------------------------------
	$HTTP = new HTTP();
	//------------------------------------------------------------------------------
	if(!$HTTP.Resource){
		//------------------------------------------------------------------------------
		alert('Не удалось создать HTTP соединение');
		//------------------------------------------------------------------------------
		return false;
		//------------------------------------------------------------------------------
	}
	//------------------------------------------------------------------------------
	$HTTP.onLoaded = function(){
		//------------------------------------------------------------------------------
		HideProgress();
		//------------------------------------------------------------------------------
	}
	//------------------------------------------------------------------------------
	$HTTP.onAnswer = function($Answer){
		//------------------------------------------------------------------------------
		switch($Answer.Status){
		case 'Error':
			//------------------------------------------------------------------------------
			ShowAlert($Answer.Error.String,'Warning');
			//------------------------------------------------------------------------------
			break;
			//------------------------------------------------------------------------------
		case 'Exception':
			//------------------------------------------------------------------------------
			ShowAlert(ExceptionsStack($Answer.Exception),'Warning');
			//------------------------------------------------------------------------------
			break;
			//------------------------------------------------------------------------------
		case 'UseBasket':
			//------------------------------------------------------------------------------
			GetURL('/Basket');
			//------------------------------------------------------------------------------
			break;
			//------------------------------------------------------------------------------
		case 'Ok':
			//------------------------------------------------------------------------------
			GetURL(document.location);
			//------------------------------------------------------------------------------
			break;
			//------------------------------------------------------------------------------
		default:
			alert('Не известный ответ');
		}
		//------------------------------------------------------------------------------
	}
	//------------------------------------------------------------------------------
	var $Args = FormGet($Form);
	//----------------------------------------------------------------------------
	if(!$HTTP.Send('/API/'+$Code+'OrderPay',$Args)){
		//------------------------------------------------------------------------------
		alert('Не удалось отправить запрос на сервер');
		//------------------------------------------------------------------------------
		return false;
		//------------------------------------------------------------------------------
	}
	//------------------------------------------------------------------------------
	ShowProgress('Оплата заказа');
	//------------------------------------------------------------------------------
}
//------------------------------------------------------------------------------
//------------------------------------------------------------------------------
